/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.pdn;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import net.damaq.pdn.LexSymbol;
import net.damaq.pdn.exceptions.LexException;
import net.damaq.utilities.Utils;

final class PDNLexAn {
    private Scanner scanner;
    private String buf = null;
    private int index;
    private int ch;
    private StringBuilder ident;
    private StringBuilder sectionValue;
    private StringBuilder comment;
    private int number;
    private int lineIndex;

    PDNLexAn() {
    }

    public final void init(String string) {
        this.scanner = new Scanner(string);
        this.ident = new StringBuilder();
        this.sectionValue = new StringBuilder();
        this.comment = new StringBuilder();
        this.number = -1;
        this.lineIndex = 0;
        this.index = 0;
        this.buf = null;
        this.ch = this.readCharacter();
    }

    private void lexError(char c, int n) throws LexException {
        String string = n == -1 ? "Unexpected end of file. '" + c + "' was expected" : "Unexpected character '" + (char)n + "' " + "'" + c + "' was expected.";
        throw new LexException(string, String.valueOf(c), String.valueOf((char)n), this.lineIndex);
    }

    private int readCharacter() {
        while (this.buf == null || this.index >= this.buf.length()) {
            if (this.scanner.hasNext()) {
                String string = this.scanner.nextLine();
                this.buf = this.scanner.hasNext() ? string + '\n' : string;
                ++this.lineIndex;
                this.index = 0;
                continue;
            }
            this.scanner.close();
            return -1;
        }
        return this.buf.charAt(this.index++);
    }

    private void processSectionValue() throws LexException {
        this.sectionValue.setLength(0);
        while ((this.ch = this.readCharacter()) != -1 && this.ch != 34) {
            this.sectionValue.append((char)this.ch);
        }
        if (this.ch == -1) {
            this.lexError('\"', this.ch);
        }
        this.ch = this.readCharacter();
    }

    private void processComment() throws LexException {
        this.comment.setLength(0);
        while ((this.ch = this.readCharacter()) != -1 && this.ch != 125) {
            this.comment.append((char)this.ch);
        }
        if (this.ch == -1) {
            this.lexError('}', this.ch);
        }
        this.ch = this.readCharacter();
    }

    private void processIdent() {
        this.ident.setLength(0);
        do {
            this.ident.append((char)this.ch);
            this.ch = this.readCharacter();
        } while ((this.ch != 120 || this.ident.length() != 2 || !Character.isDigit(this.ident.charAt(1))) && (Character.isLetterOrDigit(this.ch) || this.ch == 95));
    }

    public final LexSymbol readSymbol() throws LexException {
        LexSymbol lexSymbol;
        while (Character.isWhitespace(this.ch)) {
            this.ch = this.readCharacter();
        }
        if (Character.isLetter(this.ch)) {
            if (this.ch == 120) {
                this.ch = this.readCharacter();
                lexSymbol = LexSymbol.JUMP;
            } else {
                this.processIdent();
                lexSymbol = PDNLexAn.findCoords(this.ident.toString());
            }
        } else if (Character.isDigit(this.ch)) {
            this.number = this.processNumber();
            if (this.number == 1) {
                if (this.ch == 45) {
                    this.ch = this.readCharacter();
                    if (this.ch == 48) {
                        lexSymbol = LexSymbol.WHITE_WINS;
                        this.ch = this.readCharacter();
                    } else {
                        --this.index;
                        this.ch = 45;
                        lexSymbol = LexSymbol.POSITION;
                    }
                } else if (this.ch == 47) {
                    this.processSameValue("2-1/2");
                    lexSymbol = LexSymbol.DRAW;
                } else if (this.ch == 46) {
                    lexSymbol = LexSymbol.MOVE_NUMBER;
                    this.ch = this.readCharacter();
                } else {
                    lexSymbol = LexSymbol.POSITION;
                }
            } else if (this.number == 0) {
                if (this.ch == 45) {
                    this.ch = this.readCharacter();
                    if (this.ch == 49) {
                        lexSymbol = LexSymbol.BLACK_WINS;
                        this.ch = this.readCharacter();
                    } else {
                        lexSymbol = LexSymbol.BLACK_WINS;
                        this.lexError('1', this.ch);
                    }
                } else if (this.ch == 46) {
                    lexSymbol = LexSymbol.MOVE_NUMBER;
                    this.ch = this.readCharacter();
                } else {
                    lexSymbol = LexSymbol.POSITION;
                }
            } else if (this.ch == 46) {
                lexSymbol = LexSymbol.MOVE_NUMBER;
                this.ch = this.readCharacter();
            } else {
                lexSymbol = LexSymbol.POSITION;
            }
        } else if (this.ch == 45) {
            this.ch = this.readCharacter();
            lexSymbol = LexSymbol.DASH;
        } else if (this.ch == 91) {
            lexSymbol = LexSymbol.LEFT_BRACKET;
            this.ch = this.readCharacter();
        } else if (this.ch == 93) {
            lexSymbol = LexSymbol.RIGHT_BRACKET;
            this.ch = this.readCharacter();
        } else if (this.ch == 34) {
            this.processSectionValue();
            lexSymbol = LexSymbol.VALUE;
        } else if (this.ch == 123) {
            this.processComment();
            lexSymbol = LexSymbol.COMMENT;
        } else if (this.ch == 42) {
            this.ch = this.readCharacter();
            lexSymbol = LexSymbol.UNDECIDED;
        } else if (this.ch == 46) {
            lexSymbol = LexSymbol.DOTS;
            this.ch = this.readCharacter();
            if (this.ch == 46) {
                this.ch = this.readCharacter();
                if (this.ch == 46) {
                    this.ch = this.readCharacter();
                } else {
                    this.lexError('.', this.ch);
                }
            } else {
                this.lexError('.', this.ch);
            }
        } else if (this.ch == -1) {
            lexSymbol = LexSymbol.EOI;
        } else {
            lexSymbol = LexSymbol.EOI;
            this.lexError('-', this.ch);
        }
        return lexSymbol;
    }

    private void processSameValue(String string) throws LexException {
        int n = string.length();
        int n2 = 0;
        do {
            this.ch = this.readCharacter();
            char c = string.charAt(n2);
            if (this.ch == c) continue;
            this.lexError(c, this.ch);
        } while (++n2 < n);
        this.ch = this.readCharacter();
    }

    private int processNumber() {
        int n = 0;
        do {
            n = n * 10 + (this.ch - 48);
            this.ch = this.readCharacter();
        } while (Character.isDigit(this.ch));
        return n;
    }

    private static LexSymbol findCoords(String string) {
        char c;
        if (string.length() == 2 && (c = string.charAt(0)) >= 'a' && c <= 'j' && Character.isDigit(string.charAt(1))) {
            return LexSymbol.COORDS;
        }
        return LexSymbol.IDENT;
    }

    public static void main(String[] stringArray) throws IOException {
        File file = new File("e:\\My Programs\\JDamAQ\\gp2001.pdn");
        PDNLexAn pDNLexAn = new PDNLexAn();
        pDNLexAn.init(Utils.loadFile(file));
        try {
            LexSymbol lexSymbol;
            while ((lexSymbol = pDNLexAn.readSymbol()) != LexSymbol.EOI) {
                System.out.printf("%s", new Object[]{lexSymbol});
                switch (lexSymbol) {
                    case IDENT: {
                        System.out.printf("(%s)", pDNLexAn.ident);
                        break;
                    }
                    case COMMENT: {
                        System.out.printf("(%s)", pDNLexAn.comment);
                        break;
                    }
                    case BLACK_WINS: {
                        System.out.printf("(%s)", "0-1");
                        break;
                    }
                    case WHITE_WINS: {
                        System.out.printf("(%s)", "1-0");
                        break;
                    }
                    case DOTS: {
                        System.out.printf("(%s)", "...");
                        break;
                    }
                    case DASH: {
                        System.out.printf("(%s)", "-");
                        break;
                    }
                    case JUMP: {
                        System.out.printf("(%s)", "x");
                        break;
                    }
                    case LEFT_BRACKET: {
                        System.out.printf("(%s)", "[");
                        break;
                    }
                    case RIGHT_BRACKET: {
                        System.out.printf("(%s)", "]");
                        break;
                    }
                    case COORDS: {
                        System.out.printf("(%s)", pDNLexAn.ident);
                        break;
                    }
                    case DRAW: {
                        System.out.printf("(%s)", "1/2-1/2");
                        break;
                    }
                    case VALUE: {
                        System.out.printf("(%s)", pDNLexAn.sectionValue);
                        break;
                    }
                    case POSITION: {
                        System.out.printf("(%s)", pDNLexAn.number);
                        break;
                    }
                    case MOVE_NUMBER: {
                        System.out.printf("(%s)", pDNLexAn.number);
                        break;
                    }
                    case UNDECIDED: {
                        System.out.printf("(%s)", "*");
                        break;
                    }
                    case EOI: {
                        System.out.printf("(%s)", "end of input");
                        break;
                    }
                    default: {
                        assert (false) : "symbol:" + (Object)((Object)lexSymbol);
                        break;
                    }
                }
                System.out.println();
            }
        }
        catch (LexException lexException) {
            System.err.println(lexException);
        }
    }

    public final String getIdent() {
        return this.ident.toString();
    }

    public final String getSectionValue() {
        return this.sectionValue.toString();
    }

    public final String getComment() {
        return this.comment.toString();
    }

    public final int getLineIndex() {
        return this.lineIndex;
    }

    public int getPositionNumber() {
        return this.number;
    }

    public String getCoords() {
        return this.ident.toString();
    }
}

