/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.pdn;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.damaq.gamestyle.interfaces.GameStyle;
import net.damaq.gamestyle.interfaces.Move;
import net.damaq.pdn.PDNGameType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PDNMove {
    private final List<Object> move = new ArrayList<Object>(2);
    private String comment = null;
    private PDNGameType.Notation notation;
    private boolean jump = false;
    private boolean blackStarts = false;
    private String stringValue = null;
    private static final String BLACK_STARTS = "...";

    public PDNMove(boolean bl) {
        this.blackStarts = bl;
        if (bl) {
            this.stringValue = BLACK_STARTS;
        }
    }

    public PDNMove(GameStyle gameStyle, Move move, boolean bl, boolean bl2) {
        this.jump = bl2;
        this.stringValue = gameStyle.toPDN(move, bl, bl2);
    }

    public final void addPosition(String string) {
        this.move.add(string);
        this.notation = PDNGameType.Notation.ALPHANUMERIC;
    }

    public final void addPosition(int n) {
        this.move.add(n);
        this.notation = PDNGameType.Notation.NUMERIC;
    }

    public final String getComment() {
        return this.comment;
    }

    public final void setComment(String string) {
        this.comment = string;
    }

    public final List<Object> getMove() {
        return this.move;
    }

    public final PDNGameType.Notation getNotation() {
        return this.notation;
    }

    public final boolean isNumeric() {
        return this.notation == PDNGameType.Notation.NUMERIC;
    }

    public final void setJump(boolean bl) {
        this.jump = bl;
    }

    public final boolean isJump() {
        return this.jump;
    }

    public final boolean isBlackStarts() {
        return this.blackStarts;
    }

    public final String toString() {
        if (this.stringValue == null) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<Object> iterator = this.move.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(this.jump ? "x" : "-");
            }
            this.stringValue = stringBuilder.toString();
        }
        return this.stringValue;
    }
}

