/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.pdn;

import java.util.IllegalFormatException;
import java.util.UnknownFormatConversionException;
import net.damaq.pdn.GameStatus;
import net.damaq.pdn.PDNSection;

public final class PDNResultSection
extends PDNSection {
    private static final String END_DRAW = "\u00bd\u2013\u00bd";
    private static final String END_WHITE_WINS = "1\u20130";
    private static final String END_BLACK_WINS = "0\u20131";
    private static final String UNDECIDED = "*";
    private final GameStatus result;
    private static final String PDN_WHITE_WINS = "1-0";
    private static final String PDN_BLACK_WINS = "0-1";
    private static final String PDN_DRAW = "1/2-1/2";
    private static final String PDN_UNDECIDED = "*";

    public PDNResultSection(GameStatus gameStatus) {
        super("Result");
        this.result = gameStatus;
        switch (gameStatus) {
            case BLACK_WINS: {
                this.stringValue = PDN_BLACK_WINS;
                break;
            }
            case WHITE_WINS: {
                this.stringValue = PDN_WHITE_WINS;
                break;
            }
            case DRAW: {
                this.stringValue = PDN_DRAW;
                break;
            }
            case UNDECIDED: {
                this.stringValue = "*";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public PDNResultSection(String string) throws IllegalFormatException {
        super("Result");
        if (string.equals(PDN_WHITE_WINS)) {
            this.result = GameStatus.WHITE_WINS;
            this.stringValue = END_WHITE_WINS;
        } else if (string.equals(PDN_BLACK_WINS)) {
            this.result = GameStatus.BLACK_WINS;
            this.stringValue = END_BLACK_WINS;
        } else if (string.equals(PDN_DRAW)) {
            this.result = GameStatus.DRAW;
            this.stringValue = END_DRAW;
        } else if (string.equals("*")) {
            this.stringValue = "*";
            this.result = GameStatus.UNDECIDED;
        } else {
            throw new UnknownFormatConversionException(string);
        }
    }

    public final GameStatus getResult() {
        return this.result;
    }
}

