/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.pdn;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.LinkedList;
import java.util.List;
import net.damaq.core.AppPrefs;
import net.damaq.pdn.GameStatus;
import net.damaq.pdn.LexSymbol;
import net.damaq.pdn.PDNGame;
import net.damaq.pdn.PDNLexAn;
import net.damaq.pdn.PDNMove;
import net.damaq.pdn.exceptions.AnalyseException;
import net.damaq.pdn.exceptions.InvalidStructureFormatException;
import net.damaq.pdn.exceptions.LexException;
import net.damaq.pdn.exceptions.SyntException;
import net.damaq.utilities.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PDNSynAn {
    private LexSymbol symbol;
    private final PDNLexAn lexan = new PDNLexAn();
    private boolean initialized = false;
    private List<PDNGame> pdnGames;

    public final void init(String string) throws LexException {
        this.lexan.init(string);
        this.readSymbol();
        this.pdnGames = new ArrayList<PDNGame>();
        this.initialized = true;
    }

    public final void parse() throws LexException, SyntException, InvalidStructureFormatException {
        if (!this.initialized) {
            throw new IllegalStateException("Syntakticky analyzator nebyl inicializovan.");
        }
        this.pdnDocument();
        if (this.getSymbol() != LexSymbol.EOI) {
            this.sAError(this.symbol);
        }
        this.initialized = false;
    }

    private void readSymbol() throws LexException {
        this.symbol = this.lexan.readSymbol();
    }

    private void sAError() throws SyntException {
        throw new SyntException("Line :" + this.lexan.getLineIndex() + " Unexpected symbol: " + (Object)((Object)this.symbol) + "\n", this.lexan.getLineIndex());
    }

    private void sAError(LexSymbol lexSymbol) throws SyntException {
        throw new SyntException("Line :" + this.lexan.getLineIndex() + " Expected symbol: " + (Object)((Object)lexSymbol) + " , found symbol: " + (Object)((Object)this.symbol) + "\n", this.lexan.getLineIndex());
    }

    private void compare(LexSymbol lexSymbol) throws LexException, SyntException {
        if (this.symbol == lexSymbol) {
            this.symbol = this.lexan.readSymbol();
        } else {
            this.sAError(lexSymbol);
        }
    }

    private void pdnDocument() throws LexException, SyntException, InvalidStructureFormatException {
        switch (this.symbol) {
            case LEFT_BRACKET: {
                this.game();
                this.pdnDocument();
                break;
            }
        }
    }

    private void game() throws LexException, SyntException, InvalidStructureFormatException {
        switch (this.symbol) {
            case LEFT_BRACKET: {
                PDNGame pDNGame = new PDNGame();
                this.sections(pDNGame);
                if (pDNGame.getEventSection() == null) {
                    throw new InvalidStructureFormatException("Event section does not exist.", this.lexan.getLineIndex());
                }
                if (pDNGame.getResultSection() == null) {
                    throw new InvalidStructureFormatException("Result section does not exist.", this.lexan.getLineIndex());
                }
                this.moves(pDNGame);
                GameStatus gameStatus = this.end();
                if (pDNGame.getResultSection().getResult() != gameStatus) {
                    throw new InvalidStructureFormatException("Game result differs from its declaration.", this.lexan.getLineIndex());
                }
                this.pdnGames.add(pDNGame);
                break;
            }
            default: {
                this.sAError();
            }
        }
    }

    private String compareIdent() throws LexException, SyntException {
        if (this.symbol == LexSymbol.IDENT) {
            String string = this.lexan.getIdent();
            this.symbol = this.lexan.readSymbol();
            return string;
        }
        this.sAError(LexSymbol.IDENT);
        return "";
    }

    private String compareValue() throws LexException, SyntException {
        if (this.symbol == LexSymbol.VALUE) {
            String string = this.lexan.getSectionValue();
            this.symbol = this.lexan.readSymbol();
            return string;
        }
        this.sAError(LexSymbol.VALUE);
        return "";
    }

    private void sections(PDNGame pDNGame) throws LexException, SyntException {
        switch (this.symbol) {
            case LEFT_BRACKET: {
                this.readSymbol();
                String string = this.compareIdent();
                String string2 = this.compareValue();
                this.compare(LexSymbol.RIGHT_BRACKET);
                pDNGame.addSection(string, string2);
                this.comment(null);
                this.nextsection(pDNGame);
                break;
            }
            default: {
                this.sAError();
            }
        }
    }

    private void nextsection(PDNGame pDNGame) throws LexException, SyntException {
        switch (this.symbol) {
            case LEFT_BRACKET: {
                this.sections(pDNGame);
                break;
            }
            case DRAW: 
            case WHITE_WINS: 
            case BLACK_WINS: 
            case UNDECIDED: 
            case MOVE_NUMBER: {
                break;
            }
            default: {
                this.sAError();
            }
        }
    }

    private void moves(PDNGame pDNGame) throws LexException, SyntException {
        switch (this.symbol) {
            case MOVE_NUMBER: {
                this.move(pDNGame);
                this.moves(pDNGame);
                break;
            }
            case DRAW: 
            case WHITE_WINS: 
            case BLACK_WINS: 
            case UNDECIDED: {
                break;
            }
            default: {
                this.sAError();
            }
        }
    }

    private void move(PDNGame pDNGame) throws LexException, SyntException {
        switch (this.symbol) {
            case MOVE_NUMBER: {
                this.readSymbol();
                this.whitemove(pDNGame);
                this.blackmove(pDNGame);
                break;
            }
            default: {
                this.sAError();
            }
        }
    }

    private void whitemove(PDNGame pDNGame) throws LexException, SyntException {
        switch (this.symbol) {
            case DOTS: {
                this.readSymbol();
                PDNMove pDNMove = new PDNMove(true);
                if (!pDNGame.getMoveList().isEmpty()) {
                    this.sAError(LexSymbol.DOTS);
                }
                pDNGame.addMove(pDNMove);
                LinkedList<String> linkedList = new LinkedList<String>();
                this.comment(linkedList);
                if (linkedList.isEmpty()) break;
                pDNMove.setComment(linkedList.get(0));
                break;
            }
            case POSITION: 
            case COORDS: {
                PDNMove pDNMove = new PDNMove(false);
                this.position(pDNMove);
                this.movepart(pDNMove);
                pDNGame.addMove(pDNMove);
                break;
            }
            default: {
                this.sAError();
            }
        }
    }

    private void blackmove(PDNGame pDNGame) throws LexException, SyntException {
        switch (this.symbol) {
            case POSITION: 
            case COORDS: {
                PDNMove pDNMove = new PDNMove(false);
                this.position(pDNMove);
                this.movepart(pDNMove);
                pDNGame.addMove(pDNMove);
                break;
            }
            case DRAW: 
            case WHITE_WINS: 
            case BLACK_WINS: 
            case UNDECIDED: 
            case MOVE_NUMBER: {
                break;
            }
            default: {
                this.sAError();
            }
        }
    }

    private void movepart(PDNMove pDNMove) throws LexException, SyntException {
        switch (this.symbol) {
            case DASH: {
                this.readSymbol();
                this.position(pDNMove);
                LinkedList<String> linkedList = new LinkedList<String>();
                this.comment(linkedList);
                if (linkedList.isEmpty()) break;
                pDNMove.setComment(linkedList.get(0));
                break;
            }
            case JUMP: {
                this.readSymbol();
                this.position(pDNMove);
                pDNMove.setJump(true);
                this.jumps(pDNMove);
                LinkedList<String> linkedList = new LinkedList<String>();
                this.comment(linkedList);
                if (linkedList.isEmpty()) break;
                pDNMove.setComment(linkedList.get(0));
                break;
            }
            default: {
                this.sAError();
            }
        }
    }

    private void jumps(PDNMove pDNMove) throws LexException, SyntException {
        switch (this.symbol) {
            case JUMP: {
                this.readSymbol();
                this.position(pDNMove);
                this.jumps(pDNMove);
                break;
            }
            case DRAW: 
            case WHITE_WINS: 
            case BLACK_WINS: 
            case UNDECIDED: 
            case MOVE_NUMBER: 
            case POSITION: 
            case COORDS: 
            case COMMENT: {
                break;
            }
            default: {
                this.sAError();
            }
        }
    }

    private void position(PDNMove pDNMove) throws LexException, SyntException {
        switch (this.symbol) {
            case POSITION: {
                pDNMove.addPosition(this.lexan.getPositionNumber());
                this.readSymbol();
                break;
            }
            case COORDS: {
                pDNMove.addPosition(this.lexan.getCoords());
                this.readSymbol();
                break;
            }
            default: {
                this.sAError();
            }
        }
    }

    private void comment(List<String> list) throws LexException, SyntException {
        switch (this.symbol) {
            case COMMENT: {
                if (list != null && list.isEmpty()) {
                    list.add(this.lexan.getComment());
                }
                this.readSymbol();
                this.comment(list);
                break;
            }
            case LEFT_BRACKET: 
            case DRAW: 
            case WHITE_WINS: 
            case BLACK_WINS: 
            case UNDECIDED: 
            case MOVE_NUMBER: 
            case POSITION: 
            case COORDS: {
                break;
            }
            default: {
                this.sAError();
            }
        }
    }

    private GameStatus end() throws LexException, SyntException {
        switch (this.symbol) {
            case DRAW: {
                this.readSymbol();
                return GameStatus.DRAW;
            }
            case WHITE_WINS: {
                this.readSymbol();
                return GameStatus.WHITE_WINS;
            }
            case BLACK_WINS: {
                this.readSymbol();
                return GameStatus.BLACK_WINS;
            }
            case UNDECIDED: {
                this.readSymbol();
                return GameStatus.UNDECIDED;
            }
        }
        this.sAError();
        return null;
    }

    public static void main(String[] stringArray) {
        File file = new File("e:\\My Programs\\JDamAQ\\test2.pdn");
        String string = AppPrefs.getProperty("pdnCharset", Charset.defaultCharset().name());
        try {
            PDNSynAn pDNSynAn = new PDNSynAn();
            pDNSynAn.init(Utils.loadFile(file, string));
            pDNSynAn.parse();
        }
        catch (AnalyseException analyseException) {
            analyseException.printStackTrace();
        }
        catch (IllegalFormatException illegalFormatException) {
            illegalFormatException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("konec");
    }

    private LexSymbol getSymbol() {
        return this.symbol;
    }

    public final List<PDNGame> getPdnGames() {
        return this.pdnGames;
    }
}

