/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.utilities;

import java.util.logging.Logger;
import net.damaq.utilities.LogUtils;

public final class BrowserControl {
    private static final Logger logger = Logger.getLogger(BrowserControl.class.getName());
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    private BrowserControl() {
    }

    public static void showHomepage() {
        BrowserControl.showURL("http://wordrider.net/damaq");
    }

    public static void showURL(String string) {
        boolean bl = BrowserControl.isWindowsPlatform();
        String string2 = "";
        try {
            if (bl) {
                string2 = "rundll32 url.dll,FileProtocolHandler " + string;
                Runtime.getRuntime().exec(string2);
            } else {
                string2 = "netscape -remote openURL(" + string + ")";
                Process process = Runtime.getRuntime().exec(string2);
                int n = process.waitFor();
                if (n != 0) {
                    string2 = "netscape " + string;
                    Runtime.getRuntime().exec(string2);
                }
            }
        }
        catch (Exception exception) {
            logger.severe("Couldn't invoke browser, command=" + string2);
            LogUtils.processException(logger, exception);
        }
    }

    private static boolean isWindowsPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith(WIN_ID);
    }
}

