/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.utilities;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;

public final class Swinger {
    private static final Logger logger = Logger.getLogger(Swinger.class.getName());
    public static final int RESULT_NO = 1;
    public static final int RESULT_YES = 0;
    private static final String MESSAGE_ERROR_TITLE_CODE = "message.error.title";
    private static final String MESSAGE_CONFIRM_TITLE_CODE = "message.confirm.title";
    private static final String MESSAGE_INFORMATION_TITLE_CODE = "message.information.title";
    private static final String MESSAGE_WARNING_TITLE_CODE = "message.warning.title";
    private static final String MESSAGE_BTN_YES_CODE = "message.button.yes";
    private static final String MESSAGE_BTN_NO_CODE = "message.button.no";
    private static final String MESSAGE_BTN_CANCEL_CODE = "message.button.cancel";
    private static final double FACTOR = 0.92;
    private static final Map<String, AudioClip> clipsMap = new HashMap<String, AudioClip>(5);

    private Swinger() {
    }

    public static JRadioButton getRadio(String string) {
        JRadioButton jRadioButton = new JRadioButton(Lng.getLabel(string));
        jRadioButton.setMnemonic(Lng.getMnemonic(string));
        return jRadioButton;
    }

    public static JLabel getLabel(String string) {
        JLabel jLabel = new JLabel(Lng.getLabel(string));
        jLabel.setDisplayedMnemonic(Lng.getMnemonic(string));
        jLabel.setToolTipText(Lng.getHint(string));
        return jLabel;
    }

    public static JLabel getLabel(String string, String string2) {
        JLabel jLabel = Swinger.getLabel(string);
        jLabel.setIcon(Swinger.getIcon(string2));
        return jLabel;
    }

    public static JCheckBox getCheckBox(String string) {
        JCheckBox jCheckBox = new JCheckBox(Lng.getLabel(string));
        jCheckBox.setMnemonic(Lng.getMnemonic(string));
        jCheckBox.setToolTipText(Lng.getHint(string));
        return jCheckBox;
    }

    public static JCheckBox getCheckBox(String string, String string2, boolean bl) {
        JCheckBox jCheckBox = Swinger.getCheckBox(string);
        jCheckBox.setSelected(AppPrefs.getProperty(string2, bl));
        return jCheckBox;
    }

    public static JButton getButton(String string, Action action) {
        action.putValue("Name", Lng.getLabel(string));
        action.putValue("ActionCommandKey", string);
        action.putValue("MnemonicKey", Lng.getMnemonic(string));
        return new JButton(action);
    }

    public static JButton getButton(String string) {
        JButton jButton = new JButton(Lng.getLabel(string));
        jButton.setMnemonic(Lng.getMnemonic(string));
        return jButton;
    }

    public static JToggleButton getToggleButton(String string, boolean bl) {
        JToggleButton jToggleButton = new JToggleButton(Lng.getLabel(string));
        jToggleButton.setMnemonic(Lng.getMnemonic(string));
        jToggleButton.setSelected(bl);
        return jToggleButton;
    }

    public static Color getColor(String string, Color color) {
        String string2 = AppPrefs.getProperty(string, null);
        if (string2 != null) {
            return Color.decode(string2);
        }
        return color;
    }

    public static void setColor(String string, Color color) {
        AppPrefs.storeProperty(string, String.valueOf(color.getRGB()));
    }

    public static ImageIcon getIcon(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new ImageIcon(ImageIO.read(((URLClassLoader)Swinger.class.getClassLoader()).findResource("resources/images/" + string)));
        }
        catch (IOException iOException) {
            logger.severe("Cannot load image " + string + "\nReason:" + iOException.getMessage());
            return null;
        }
    }

    public static Image getIconImage(String string) {
        if (string == null) {
            return null;
        }
        try {
            return ImageIO.read(((URLClassLoader)Swinger.class.getClassLoader()).findResource("resources/images/" + string));
        }
        catch (IOException iOException) {
            logger.severe("Cannot load image " + string + "\nReason:" + iOException.getMessage());
            return null;
        }
    }

    public static Image loadPicture(File file) throws IOException {
        return ImageIO.read(file);
    }

    public static void addKeyActions(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(155, 2), new DefaultEditorKit.CopyAction());
        inputMap.put(KeyStroke.getKeyStroke(155, 1), new DefaultEditorKit.PasteAction());
        inputMap.put(KeyStroke.getKeyStroke(127, 1), new DefaultEditorKit.CutAction());
        jComponent.setInputMap(0, inputMap);
    }

    public static void centerDialog(Component component, Component component2) {
        Dimension dimension = component2.getPreferredSize();
        Dimension dimension2 = component.getSize();
        Point point = component.getLocation();
        component2.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
    }

    public static void inputFocus(JComboBox jComboBox) {
        Swinger.inputFocus((JComponent)jComboBox.getEditor().getEditorComponent());
    }

    public static void inputFocus(final JComponent jComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jComponent.grabFocus();
                jComponent.requestFocus();
            }
        });
    }

    public static void showErrorDialog(Frame frame, String string) {
        JOptionPane.showMessageDialog(frame, string, Lng.getLabel(MESSAGE_ERROR_TITLE_CODE), 0, Swinger.getIcon("error.gif"));
    }

    public static void showWarningDialog(Frame frame, String string) {
        JOptionPane.showMessageDialog(frame, string, Lng.getLabel(MESSAGE_WARNING_TITLE_CODE), 2, Swinger.getIcon("warning.gif"));
    }

    public static void showInformationDialog(Frame frame, String string) {
        JOptionPane.showMessageDialog(frame, string, Lng.getLabel(MESSAGE_INFORMATION_TITLE_CODE), 1, Swinger.getIcon("information.gif"));
    }

    public static void showInformationDialog(Frame frame, String string, Icon icon) {
        JOptionPane.showMessageDialog(frame, string, Lng.getLabel(MESSAGE_INFORMATION_TITLE_CODE), 1, icon);
    }

    public static int showOptionDialog(Component component, Object object, String string) {
        return JOptionPane.showOptionDialog(component, object, string, 2, -1, Swinger.getIcon("question.gif"), new Object[]{"OK", Lng.getLabel(MESSAGE_BTN_CANCEL_CODE)}, object);
    }

    public static int getChoice(Frame frame, String string) {
        return JOptionPane.showOptionDialog(frame, string, Lng.getLabel(MESSAGE_CONFIRM_TITLE_CODE), 1, 3, Swinger.getIcon("question.gif"), new String[]{Lng.getLabel(MESSAGE_BTN_YES_CODE), Lng.getLabel(MESSAGE_BTN_NO_CODE)}, null);
    }

    public static int getChoiceCancel(Frame frame, String string) {
        return JOptionPane.showOptionDialog(frame, string, Lng.getLabel(MESSAGE_CONFIRM_TITLE_CODE), 1, 3, Swinger.getIcon("question.gif"), new String[]{Lng.getLabel(MESSAGE_BTN_YES_CODE), Lng.getLabel(MESSAGE_BTN_NO_CODE), Lng.getLabel(MESSAGE_BTN_CANCEL_CODE)}, null);
    }

    public static Color brighter(Color color) {
        Color color2;
        if (color == null) {
            Color color3 = new JPanel().getBackground();
            if (color3 != null) {
                return color3;
            }
            return UIManager.getDefaults().getColor("window");
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(12, 12, 12);
        }
        if (n > 0 && n < 12) {
            n = 12;
        }
        if (n2 > 0 && n2 < 12) {
            n2 = 12;
        }
        if (n3 > 0 && n3 < 12) {
            n3 = 12;
        }
        if ((color2 = new Color(Math.min((int)((double)n / 0.92), 255), Math.min((int)((double)n2 / 0.92), 255), Math.min((int)((double)n3 / 0.92), 255))).equals(Color.WHITE)) {
            Color color4 = new JPanel().getBackground();
            if (color4 == null) {
                return color;
            }
            return color4;
        }
        return color2;
    }

    public static JComponent getTitleComponent(String string) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setLayout(new GridBagLayout());
        jToolBar.setFloatable(false);
        JLabel jLabel = new JLabel(string);
        jToolBar.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(0, 4, 0, 2), 0, 0));
        jToolBar.add((Component)new JSeparator(0), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(4, 0, 0, 0), 0, 0));
        return jToolBar;
    }

    public static boolean isEmpty(JComboBox jComboBox) {
        Object object = jComboBox.getEditor().getItem();
        return object == null || object.equals("");
    }

    public static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static AudioClip getCachedAudioClip(String string) {
        if (!clipsMap.containsKey(string)) {
            AudioClip audioClip = Swinger.getAudioClip(string);
            if (audioClip != null) {
                clipsMap.put(string, audioClip);
            }
            return audioClip;
        }
        return clipsMap.get(string);
    }

    public static AudioClip getAudioClip(String string) {
        URL uRL = ((URLClassLoader)Swinger.class.getClassLoader()).findResource("resources/sound/" + string);
        return Applet.newAudioClip(uRL);
    }

    public static void playSound(AudioClip audioClip) {
        if (audioClip != null && AppPrefs.getProperty("playSound", true)) {
            audioClip.play();
        }
    }

    public static void playSound(String string) {
        Swinger.playSound(Swinger.getCachedAudioClip(string));
    }

    public static final class SelectAllOnFocusListener
    implements FocusListener {
        public final void focusGained(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                ((JTextComponent)focusEvent.getComponent()).selectAll();
            }
        }

        public final void focusLost(FocusEvent focusEvent) {
        }
    }
}

