/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.logging.Logger;
import net.damaq.utilities.LogUtils;

public final class Utils {
    private static String actual_java_version = null;
    private static final Logger logger = Logger.getLogger(Utils.class.getName());

    private Utils() {
    }

    public static String generateXorString(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder(n);
            for (int i = 0; i < n; ++i) {
                stringBuilder.append((char)(cArray[i] ^ 0x893C));
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static String addParam(String string, String string2, String string3) {
        String string4;
        try {
            string4 = URLEncoder.encode(string3, "ISO-8859-2");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string4 = "";
            LogUtils.processException(logger, unsupportedEncodingException);
        }
        String string5 = string2 + "=" + string4;
        return string.length() > 0 ? string + "&" + string5 : string5;
    }

    public static String shortenFileName(String string, int n) {
        int n2 = string.length();
        if (n2 < n) {
            return string;
        }
        String string2 = File.separator;
        String[] stringArray = string.split(string2.equals("\\") ? "\\\\" : string2);
        int n3 = stringArray.length;
        if (n3 > 4) {
            int n4 = 0;
            for (int i = 2; i < n3 - 2 && n2 - (n4 += stringArray[i].length()) + 3 >= n; ++i) {
            }
            StringBuilder stringBuilder = new StringBuilder(n2 - n4 + 3);
            stringBuilder.append(stringArray[0]).append(string2).append(stringArray[1]).append(string2).append("...");
            for (int i = i + 1; i < n3; ++i) {
                stringBuilder.append(string2);
                stringBuilder.append(stringArray[i]);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public static boolean isJVMVersion(double d) {
        Object object;
        if (actual_java_version == null) {
            object = System.getProperty("java.version");
            if (object == null) {
                System.err.println("Java version was not specified. Fatal error.");
                return false;
            }
            actual_java_version = ((String)object).substring(0, 3);
        }
        return ((Double)(object = new Double(actual_java_version))).compareTo(d) >= 0;
    }

    public static String getExtension(File file) {
        return Utils.getExtension(file.getName());
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    public static String getPureFilename(File file) {
        String[] stringArray = file.getName().split("\\.", 2);
        return stringArray[0];
    }

    public static String addFileSeparator(String string) {
        return string.endsWith(File.separator) ? string : string + File.separator;
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string == null || string.startsWith("Windows");
    }

    public static Properties loadProperties(String string, boolean bl) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = !bl ? new FileInputStream(string) : ((URLClassLoader)Utils.class.getClassLoader()).getResourceAsStream(string);
            properties.load(inputStream);
            inputStream.close();
            return properties;
        }
        catch (IOException iOException) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException2) {
                LogUtils.processException(logger, iOException2);
            }
            if (Utils.isWindows()) {
                logger.severe("Couldn't load properties:" + string + " This is fatal error. Reinstal application may fix this problem.");
            }
            LogUtils.processException(logger, iOException);
            return properties;
        }
    }

    public static String loadFile(File file) throws IOException {
        return Utils.loadFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFile(File file, String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(2000);
        BufferedReader bufferedReader = null;
        if (string == null || !Charset.isSupported(string)) {
            string = Charset.defaultCharset().name();
        }
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), string);
            bufferedReader = new BufferedReader(inputStreamReader);
            char[] cArray = new char[2000];
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return stringBuilder.toString();
    }

    public static String trimRight(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        while (cArray[n - 1] <= ' ') {
            --n;
        }
        return string.substring(0, n);
    }
}

