/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.jvnet.lafwidget.tabbed.TabPreviewPainter;
import org.jvnet.lafwidget.text.PasswordStrengthChecker;
import org.jvnet.lafwidget.utils.LafConstants;

public class LafWidgetUtilities {
    public static final String PREVIEW_MODE = "lafwidgets.internal.previewMode";

    private LafWidgetUtilities() {
    }

    public static BufferedImage getBlankImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setColor(new Color(0, 0, 0, 0));
        graphics.setComposite(AlphaComposite.Src);
        graphics.fillRect(0, 0, width, height);
        graphics.dispose();
        return image;
    }

    public static boolean hasUseModelOnlyProperty(JComboBox combobox) {
        Object useModelOnlyProperty = combobox.getClientProperty("lafwidgets.comboboxUseModelOnly");
        if (Boolean.TRUE.equals(useModelOnlyProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(useModelOnlyProperty)) {
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("lafwidgets.comboboxUseModelOnly"));
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage compatibleImage = c.createCompatibleImage(image.getWidth(), image.getHeight());
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static BufferedImage createThumbnail(BufferedImage image, int requestedThumbWidth) {
        float ratio = (float)image.getWidth() / (float)image.getHeight();
        int width = image.getWidth();
        BufferedImage thumb = image;
        do {
            if ((width /= 2) < requestedThumbWidth) {
                width = requestedThumbWidth;
            }
            BufferedImage temp = new BufferedImage(width, (int)((float)width / ratio), 2);
            Graphics2D g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(thumb, 0, 0, temp.getWidth(), temp.getHeight(), null);
            g2.dispose();
            thumb = temp;
        } while (width != requestedThumbWidth);
        return thumb;
    }

    public static Icon getSearchIcon(int dimension, boolean leftToRight) {
        BufferedImage result = LafWidgetUtilities.getBlankImage(dimension, dimension);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(Color.black);
        graphics.setStroke(new BasicStroke(1.5f));
        if (leftToRight) {
            int xc = (int)(0.6 * (double)dimension);
            int yc = (int)(0.45 * (double)dimension);
            int r = (int)(0.3 * (double)dimension);
            graphics.drawOval(xc - r, yc - r, 2 * r, 2 * r);
            graphics.setStroke(new BasicStroke(3.0f));
            GeneralPath handle = new GeneralPath();
            handle.moveTo((float)((double)xc - (double)r / Math.sqrt(2.0)), (float)((double)yc + (double)r / Math.sqrt(2.0)));
            handle.lineTo(1.8f, (float)dimension - 2.2f);
            graphics.draw(handle);
        } else {
            int xc = (int)(0.4 * (double)dimension);
            int yc = (int)(0.45 * (double)dimension);
            int r = (int)(0.3 * (double)dimension);
            graphics.drawOval(xc - r, yc - r, 2 * r, 2 * r);
            graphics.setStroke(new BasicStroke(3.0f));
            GeneralPath handle = new GeneralPath();
            handle.moveTo((float)((double)xc + (double)r / Math.sqrt(2.0)), (float)((double)yc + (double)r / Math.sqrt(2.0)));
            handle.lineTo((float)dimension - 2.5f, (float)dimension - 2.2f);
            graphics.draw(handle);
        }
        graphics.dispose();
        return new ImageIcon(result);
    }

    public static Icon getHexaMarker(int value) {
        BufferedImage result = LafWidgetUtilities.getBlankImage(9, 9);
        Color offColor = Color.gray;
        Color onColor = Color.black;
        boolean bit1 = ((value %= 16) & 1) != 0;
        boolean bit2 = (value & 2) != 0;
        boolean bit3 = (value & 4) != 0;
        boolean bit4 = (value & 8) != 0;
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(bit1 ? onColor : offColor);
        graphics.fillOval(5, 5, 4, 4);
        graphics.setColor(bit2 ? onColor : offColor);
        graphics.fillOval(5, 0, 4, 4);
        graphics.setColor(bit3 ? onColor : offColor);
        graphics.fillOval(0, 5, 4, 4);
        graphics.setColor(bit4 ? onColor : offColor);
        graphics.fillOval(0, 0, 4, 4);
        graphics.dispose();
        return new ImageIcon(result);
    }

    public static TabPreviewPainter getTabPreviewPainter(JTabbedPane tabbedPane) {
        if (tabbedPane == null) {
            return null;
        }
        Object tabProp = tabbedPane.getClientProperty("lafwidgets.tabbedpanePreviewPainter");
        if (tabProp instanceof TabPreviewPainter) {
            return (TabPreviewPainter)tabProp;
        }
        Object globProp = UIManager.get("lafwidgets.tabbedpanePreviewPainter");
        if (globProp instanceof TabPreviewPainter) {
            return (TabPreviewPainter)globProp;
        }
        return null;
    }

    public static void makePreviewable(Component comp, Map dbSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            dbSnapshot.put(jcomp, jcomp.isDoubleBuffered());
            jcomp.setDoubleBuffered(false);
            jcomp.putClientProperty(PREVIEW_MODE, Boolean.TRUE);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                LafWidgetUtilities.makePreviewable(cont.getComponent(i), dbSnapshot);
            }
        }
    }

    public static void restorePreviewable(Component comp, Map dbSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (dbSnapshot.containsKey(comp)) {
                jcomp.setDoubleBuffered((Boolean)dbSnapshot.get(comp));
                jcomp.putClientProperty(PREVIEW_MODE, null);
            } else {
                Container parent = comp.getParent();
                if (parent instanceof JComponent) {
                    jcomp.setDoubleBuffered((Boolean)dbSnapshot.get(parent));
                    jcomp.putClientProperty(PREVIEW_MODE, null);
                }
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                LafWidgetUtilities.restorePreviewable(cont.getComponent(i), dbSnapshot);
            }
        }
    }

    public static LafConstants.AnimationKind getAnimationKind(Component component) {
        JPopupMenu popupMenu = null;
        while (component != null) {
            JComponent jcomp;
            Object jcompAnimationKind;
            if (component instanceof JComponent && (jcompAnimationKind = (jcomp = (JComponent)component).getClientProperty("lafwidgets.animationKind")) instanceof LafConstants.AnimationKind) {
                return (LafConstants.AnimationKind)jcompAnimationKind;
            }
            if (component instanceof JPopupMenu) {
                popupMenu = (JPopupMenu)component;
            }
            component = component.getParent();
        }
        if (popupMenu != null) {
            return LafWidgetUtilities.getAnimationKind(popupMenu.getInvoker());
        }
        Object globalAnimationKind = UIManager.get("lafwidgets.animationKind");
        if (globalAnimationKind instanceof LafConstants.AnimationKind) {
            return (LafConstants.AnimationKind)globalAnimationKind;
        }
        return LafConstants.AnimationKind.REGULAR;
    }

    public static PasswordStrengthChecker getPasswordStrengthChecker(JPasswordField jpf) {
        Object obj = jpf.getClientProperty("lafwidgets.passwordStrengthChecker");
        if (obj != null && obj instanceof PasswordStrengthChecker) {
            return (PasswordStrengthChecker)obj;
        }
        return null;
    }

    public static Icon getSmallLockIcon() {
        BufferedImage result = LafWidgetUtilities.getBlankImage(6, 8);
        Color fore = Color.black;
        Color fill = new Color(208, 208, 48);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setColor(fill);
        graphics.fillRect(1, 3, 4, 4);
        graphics.setColor(fore);
        graphics.drawLine(0, 3, 0, 7);
        graphics.drawLine(5, 3, 5, 7);
        graphics.drawLine(0, 7, 5, 7);
        graphics.drawLine(1, 2, 4, 2);
        graphics.drawLine(1, 1, 1, 2);
        graphics.drawLine(4, 1, 4, 2);
        graphics.drawLine(2, 0, 3, 0);
        graphics.drawLine(2, 4, 3, 4);
        graphics.drawLine(2, 5, 3, 5);
        graphics.dispose();
        return new ImageIcon(result);
    }

    public static boolean hasTextFocusSelectAllProperty(JTextComponent textComp) {
        Object textFocusSelectAllProperty = textComp.getClientProperty("lafwidgets.textSelectAllOnFocus");
        if (Boolean.TRUE.equals(textFocusSelectAllProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(textFocusSelectAllProperty)) {
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("lafwidgets.textSelectAllOnFocus"));
    }

    public static boolean hasTextEditContextMenu(JTextComponent textComp) {
        Object textEditContextMenuProperty = textComp.getClientProperty("lafwidgets.textEditContextMenu");
        if (Boolean.TRUE.equals(textEditContextMenuProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(textEditContextMenuProperty)) {
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("lafwidgets.textEditContextMenu"));
    }

    public static boolean hasAutomaticDnDSupport(JTree tree) {
        Object dndProperty = tree.getClientProperty("lafwidgets.treeAutoDnDSupport");
        if (Boolean.TRUE.equals(dndProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(dndProperty)) {
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("lafwidgets.treeAutoDnDSupport"));
    }
}

