/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceInternalFrameTitlePane;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceDesktopIconUI
extends BasicDesktopIconUI {
    private MouseInputListener labelMouseInputListener;
    private int width;
    protected PropertyChangeListener propertyListener;
    protected ActionListener closeListener;
    protected ActionListener restoreListener;
    protected ActionListener maximizeListener;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceDesktopIconUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        Font f = this.desktopIcon.getFont();
        if (f == null || f instanceof UIResource) {
            this.desktopIcon.setFont(UIManager.getFont("DesktopIcon.font"));
        }
        this.width = UIManager.getInt("DesktopIcon.width");
        this.desktopIcon.setBackground(SubstanceCoreUtilities.getActiveScheme(this.desktopIcon.getInternalFrame()).getExtraLightColor());
    }

    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        this.frame.setOpaque(false);
        this.iconPane = new SubstanceInternalFrameTitlePane(this.frame, false);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
    }

    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.iconPane);
        this.frame = null;
    }

    protected void installListeners() {
        super.installListeners();
        this.labelMouseInputListener = this.createMouseInputListener();
        this.iconPane.addMouseMotionListener(this.labelMouseInputListener);
        this.iconPane.addMouseListener(this.labelMouseInputListener);
    }

    protected void uninstallListeners() {
        this.iconPane.removeMouseMotionListener(this.labelMouseInputListener);
        this.iconPane.removeMouseListener(this.labelMouseInputListener);
        this.labelMouseInputListener = null;
        super.uninstallListeners();
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(this.width, this.desktopIcon.getLayout().minimumLayoutSize((Container)this.desktopIcon).height);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public void paint(Graphics g, JComponent c) {
        JInternalFrame.JDesktopIcon di = (JInternalFrame.JDesktopIcon)c;
        di.setOpaque(false);
        int width = di.getWidth();
        int height = di.getHeight();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(AlphaComposite.getInstance(10, 0.6f));
        SubstanceImageCreator.paintRectangularBackground(graphics, 0, 0, width, height, SubstanceCoreUtilities.getActiveScheme(this.desktopIcon.getInternalFrame()), false, false);
        di.paintComponents(graphics);
        graphics.dispose();
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public void uninstallUI(JComponent c) {
        SubstanceInternalFrameTitlePane thePane = (SubstanceInternalFrameTitlePane)this.iconPane;
        super.uninstallUI(c);
        thePane.uninstallListeners();
    }

    public JComponent getComponentForHover() {
        return this.iconPane;
    }
}

