/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;
import org.jvnet.substance.SubstanceIconFactory;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.title.TitleButtonManager;
import org.jvnet.substance.utils.ButtonBackgroundDelegate;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceInternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    protected PropertyChangeListener propertyListener;
    protected PropertyChangeListener winModifiedListener;
    protected List<AbstractButton> customTitleButtons;

    public SubstanceInternalFrameTitlePane(JInternalFrame f, boolean setCustomButtons) {
        super(f);
        this.setToolTipText(f.getTitle());
        if (setCustomButtons) {
            this.setCustomTitleButtons(TitleButtonManager.getManager().getCustomButtons(f.getRootPane()));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("title".equals(evt.getPropertyName())) {
                    SubstanceInternalFrameTitlePane.this.setToolTipText((String)evt.getNewValue());
                }
            }
        };
        this.frame.addPropertyChangeListener(this.propertyListener);
        this.winModifiedListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("windowModified".equals(evt.getPropertyName())) {
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        SubstanceInternalFrameTitlePane.this.closeButton.setToolTipText(UIManager.getString("InternalFrame.closeButtonToolTip") + " [" + SubstanceLookAndFeel.getLabelBundle().getString("Tooltip.contentsNotSaved") + "]");
                    } else {
                        SubstanceInternalFrameTitlePane.this.closeButton.setToolTipText(UIManager.getString("InternalFrame.closeButtonToolTip"));
                    }
                }
            }
        };
        this.frame.addPropertyChangeListener(this.winModifiedListener);
        this.frame.getRootPane().addPropertyChangeListener(this.winModifiedListener);
    }

    @Override
    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.propertyListener);
        this.propertyListener = null;
        this.frame.removePropertyChangeListener(this.winModifiedListener);
        this.frame.getRootPane().removePropertyChangeListener(this.winModifiedListener);
        this.winModifiedListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paintComponent(Graphics g) {
        String clippedTitle;
        int titleWidth;
        FontMetrics fm;
        Rectangle rect;
        int rightEnd;
        int leftEnd;
        Icon icon;
        if (this.isPalette) {
            this.paintPalette(g);
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        boolean isSelected = this.frame.isSelected();
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight() + 2;
        SubstanceTheme theme = isSelected ? SubstanceLookAndFeel.getTheme().getActiveTitlePaneTheme() : SubstanceCoreUtilities.getDefaultTheme(this.frame);
        int xOffset = 0;
        String theTitle = this.frame.getTitle();
        if (leftToRight) {
            xOffset = 5;
            icon = this.frame.getFrameIcon();
            if (icon != null) {
                xOffset += icon.getIconWidth() + 5;
            }
            int n = leftEnd = this.menuBar == null ? 0 : this.menuBar.getWidth() + 30;
            if (icon != null) {
                leftEnd += icon.getIconWidth() + 5;
            }
            xOffset += leftEnd;
            rightEnd = width - 5;
            AbstractButton leftmostButton = null;
            if (this.frame.isIconifiable()) {
                leftmostButton = this.iconButton;
            } else if (this.frame.isMaximizable()) {
                leftmostButton = this.maxButton;
            } else if (this.frame.isClosable()) {
                leftmostButton = this.closeButton;
            }
            if (this.customTitleButtons != null) {
                leftmostButton = this.customTitleButtons.get(this.customTitleButtons.size() - 1);
            }
            if (leftmostButton != null) {
                rect = leftmostButton.getBounds();
                rightEnd = rect.getBounds().x - 5;
            }
            if (theTitle != null) {
                fm = this.frame.getFontMetrics(graphics.getFont());
                clippedTitle = SubstanceCoreUtilities.clipString(fm, titleWidth = rightEnd - leftEnd - 30, theTitle);
                if (theTitle.equals(clippedTitle)) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText(theTitle);
                }
                theTitle = clippedTitle;
            }
        } else {
            xOffset = width - 5;
            icon = this.frame.getFrameIcon();
            if (icon != null) {
                xOffset -= icon.getIconWidth() + 5;
            }
            rightEnd = this.menuBar == null ? xOffset : xOffset - this.menuBar.getWidth() - 20;
            AbstractButton rightmostButton = null;
            if (this.frame.isIconifiable()) {
                rightmostButton = this.iconButton;
            } else if (this.frame.isMaximizable()) {
                rightmostButton = this.maxButton;
            } else if (this.frame.isClosable()) {
                rightmostButton = this.closeButton;
            }
            if (this.customTitleButtons != null) {
                rightmostButton = this.customTitleButtons.get(this.customTitleButtons.size() - 1);
            }
            leftEnd = 5;
            if (rightmostButton != null) {
                rect = rightmostButton.getBounds();
                leftEnd = rect.getBounds().x + 5;
            }
            if (theTitle != null) {
                fm = this.frame.getFontMetrics(graphics.getFont());
                clippedTitle = SubstanceCoreUtilities.clipString(fm, titleWidth = rightEnd - leftEnd - 30, theTitle);
                if (theTitle.equals(clippedTitle)) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText(theTitle);
                }
                theTitle = clippedTitle;
                xOffset = rightEnd - fm.stringWidth(theTitle);
            }
        }
        SubstanceTitlePainter titlePainter = SubstanceCoreUtilities.getTitlePainter(this.frame);
        titlePainter.paintTitleBackground(graphics, this.frame, width, height + 1, leftEnd, rightEnd, theme);
        if (!Boolean.TRUE.equals(this.getClientProperty("lafwidgets.internal.previewMode"))) {
            SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(graphics, this, 0, 0, width, height);
        }
        Composite oldComp = graphics.getComposite();
        graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
        titlePainter.paintTitleBackground(graphics, this.frame, width, height + 1, leftEnd, rightEnd, theme);
        graphics.setComposite(oldComp);
        Icon icon2 = this.frame.getFrameIcon();
        if (icon2 != null) {
            int iconY;
            if (leftToRight) {
                iconY = height / 2 - icon2.getIconHeight() / 2;
                icon2.paintIcon(this.frame, graphics, 5, iconY);
            } else {
                iconY = height / 2 - icon2.getIconHeight() / 2;
                icon2.paintIcon(this.frame, graphics, width - 5 - icon2.getIconWidth(), iconY);
            }
        }
        if (theTitle != null) {
            FontMetrics fm2 = this.frame.getFontMetrics(graphics.getFont());
            int yOffset = (height - fm2.getHeight()) / 2 + fm2.getAscent();
            Object oldAAValue = graphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            Color foregroundColor = SubstanceCoreUtilities.isThemeDark(theme) ? theme.getColorScheme().getForegroundColor() : theme.getColorScheme().getUltraDarkColor().darker();
            BufferedImage blurred = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D gBlurred = (Graphics2D)blurred.getGraphics();
            gBlurred.setFont(graphics.getFont());
            gBlurred.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            gBlurred.setColor(SubstanceColorUtilities.getNegativeColor(foregroundColor));
            ConvolveOp convolve = new ConvolveOp(new Kernel(3, 3, new float[]{0.0f, 0.05f, 0.1f, 0.05f, 0.0f, 0.1f, 0.1f, 0.1f, 0.1f}), 1, null);
            gBlurred.drawString(theTitle, xOffset + 1, yOffset + 1);
            blurred = convolve.filter(blurred, null);
            graphics.drawImage((Image)blurred, 0, 0, null);
            graphics.setColor(foregroundColor);
            graphics.drawString(theTitle, xOffset, yOffset);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        }
        graphics.dispose();
    }

    @Override
    protected void setButtonIcons() {
        super.setButtonIcons();
        SubstanceTheme iconTheme = SubstanceLookAndFeel.getTheme();
        Icon restoreIcon = SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.RESTORE, iconTheme);
        Icon maximizeIcon = SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, iconTheme);
        Icon minimizeIcon = SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MINIMIZE, iconTheme);
        Icon closeIcon = SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.CLOSE, iconTheme);
        if (this.frame.isIcon()) {
            this.iconButton.setIcon(restoreIcon);
            this.maxButton.setIcon(maximizeIcon);
        } else {
            this.iconButton.setIcon(minimizeIcon);
            if (this.frame.isMaximum()) {
                this.maxButton.setIcon(restoreIcon);
            } else {
                this.maxButton.setIcon(maximizeIcon);
            }
        }
        if (closeIcon != null) {
            this.closeButton.setIcon(closeIcon);
        }
    }

    @Override
    protected void createButtons() {
        super.createButtons();
        for (ActionListener listener : this.iconButton.getActionListeners()) {
            if (!(listener instanceof ClickListener)) continue;
            return;
        }
        this.iconButton.addActionListener(new ClickListener());
        for (ActionListener listener : this.maxButton.getActionListeners()) {
            if (!(listener instanceof ClickListener)) continue;
            return;
        }
        this.maxButton.addActionListener(new ClickListener());
        ButtonBackgroundDelegate.trackTitleButton(this.iconButton, SubstanceConstants.ButtonTitleKind.REGULAR);
        this.iconButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        ButtonBackgroundDelegate.trackTitleButton(this.maxButton, SubstanceConstants.ButtonTitleKind.REGULAR);
        this.maxButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        ButtonBackgroundDelegate.trackTitleButton(this.closeButton, SubstanceConstants.ButtonTitleKind.CLOSE);
        this.closeButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
    }

    public void setCustomTitleButtons(List<AbstractButton> customTitleButtons) {
        if (this.customTitleButtons != null) {
            for (AbstractButton tButton : this.customTitleButtons) {
                this.remove(tButton);
            }
        }
        this.customTitleButtons = customTitleButtons;
        if (this.customTitleButtons != null) {
            for (AbstractButton tButton : this.customTitleButtons) {
                this.add(tButton);
            }
        }
    }

    @Override
    protected LayoutManager createLayout() {
        return new SubstanceTitlePaneLayout();
    }

    protected class SubstanceTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        protected SubstanceTitlePaneLayout() {
            super(SubstanceInternalFrameTitlePane.this);
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 30;
            if (SubstanceInternalFrameTitlePane.this.frame.isClosable()) {
                width += 21;
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 16 + (SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 16 + (SubstanceInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fm = SubstanceInternalFrameTitlePane.this.frame.getFontMetrics(SubstanceInternalFrameTitlePane.this.getFont());
            String frameTitle = SubstanceInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 2 ? (width += title_w < (subtitle_w = fm.stringWidth(SubstanceInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? title_w : subtitle_w) : (width += title_w);
            int height = 0;
            if (SubstanceInternalFrameTitlePane.this.isPalette) {
                height = SubstanceInternalFrameTitlePane.this.paletteTitleHeight;
            } else {
                int fontHeight = fm.getHeight();
                fontHeight += 7;
                Icon icon = SubstanceInternalFrameTitlePane.this.frame.getFrameIcon();
                int iconHeight = 0;
                if (icon != null) {
                    iconHeight = Math.min(icon.getIconHeight(), 16);
                }
                height = Math.max(fontHeight, iconHeight += 5);
            }
            return new Dimension(width, height);
        }

        public void layoutContainer(Container c) {
            int spacing;
            boolean leftToRight = SubstanceInternalFrameTitlePane.this.frame.getComponentOrientation().isLeftToRight();
            int w = SubstanceInternalFrameTitlePane.this.getWidth();
            int x = leftToRight ? w : 0;
            int y = 2;
            int buttonHeight = SubstanceInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            int buttonWidth = SubstanceInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
            if (SubstanceInternalFrameTitlePane.this.frame.isClosable()) {
                if (SubstanceInternalFrameTitlePane.this.isPalette) {
                    spacing = 3;
                    SubstanceInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -spacing - (buttonWidth + 2) : spacing, y, buttonWidth + 2, SubstanceInternalFrameTitlePane.this.getHeight() - 4);
                    if (!leftToRight) {
                        x += buttonWidth + 2;
                    }
                } else {
                    spacing = 4;
                    SubstanceInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isMaximizable() && !SubstanceInternalFrameTitlePane.this.isPalette) {
                spacing = SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4;
                SubstanceInternalFrameTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isIconifiable() && !SubstanceInternalFrameTitlePane.this.isPalette) {
                spacing = SubstanceInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
                SubstanceInternalFrameTitlePane.this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (SubstanceInternalFrameTitlePane.this.customTitleButtons != null) {
                for (AbstractButton tButton : SubstanceInternalFrameTitlePane.this.customTitleButtons) {
                    spacing = 2;
                    tButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (leftToRight) continue;
                    x += buttonWidth;
                }
            }
        }
    }

    public static class ClickListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AbstractButton src = (AbstractButton)e.getSource();
            ButtonModel model = src.getModel();
            model.setArmed(false);
            model.setPressed(false);
            model.setRollover(false);
            model.setSelected(false);
        }
    }
}

