/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceListUI
extends BasicListUI {
    protected static String SELECTED_INDICES = "substancelaf.internal.listSelectedIndices";
    protected static String ROLLED_OVER_INDICES = "substancelaf.internal.listRolledOverIndices";
    protected boolean isFileList;
    protected boolean isLeftToRight;
    private static SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();
    protected ListSelectionListener fadeSelectionListener;
    protected RolloverFadeListener fadeRolloverListener;

    public static ComponentUI createUI(JComponent list) {
        return new SubstanceListUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.isFileList = Boolean.TRUE.equals(this.list.getClientProperty("List.isFileList"));
        this.isLeftToRight = this.list.getComponentOrientation().isLeftToRight();
        if (SubstanceLookAndFeel.toBleedWatermark()) {
            this.list.setOpaque(false);
        }
        HashMap selected = new HashMap();
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            if (!this.list.isSelectedIndex(i)) continue;
            selected.put(i, this.list.getModel().getElementAt(i));
        }
        this.list.putClientProperty(SELECTED_INDICES, selected);
    }

    protected void uninstallDefaults() {
        this.list.putClientProperty(SELECTED_INDICES, null);
        super.uninstallDefaults();
    }

    protected void installListeners() {
        super.installListeners();
        this.fadeSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (SubstanceLookAndFeel.toBleedWatermark()) {
                    return;
                }
                Map currSelected = (Map)SubstanceListUI.this.list.getClientProperty(SELECTED_INDICES);
                for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                    if (i >= SubstanceListUI.this.list.getModel().getSize()) continue;
                    if (SubstanceListUI.this.list.isSelectedIndex(i)) {
                        if (currSelected.containsKey(i)) continue;
                        FadeTracker.getInstance().trackFadeIn(FadeTracker.FadeKind.SELECTION, SubstanceListUI.this.list, i, false, new CellRepaintCallback(SubstanceListUI.this.list, i));
                        currSelected.put(i, SubstanceListUI.this.list.getModel().getElementAt(i));
                        continue;
                    }
                    if (!currSelected.containsKey(i)) continue;
                    if (currSelected.get(i) == SubstanceListUI.this.list.getModel().getElementAt(i)) {
                        FadeTracker.getInstance().trackFadeOut(FadeTracker.FadeKind.SELECTION, SubstanceListUI.this.list, i, false, new CellRepaintCallback(SubstanceListUI.this.list, i));
                    }
                    currSelected.remove(i);
                }
            }
        };
        this.list.getSelectionModel().addListSelectionListener(this.fadeSelectionListener);
        this.fadeRolloverListener = new RolloverFadeListener();
        this.list.addMouseMotionListener(this.fadeRolloverListener);
        this.list.addMouseListener(this.fadeRolloverListener);
    }

    protected void uninstallListeners() {
        this.list.getSelectionModel().removeListSelectionListener(this.fadeSelectionListener);
        this.fadeSelectionListener = null;
        this.list.removeMouseMotionListener(this.fadeRolloverListener);
        this.list.removeMouseListener(this.fadeRolloverListener);
        this.fadeRolloverListener = null;
        super.uninstallListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        int fadeCoef;
        Graphics2D g2d;
        boolean isRollover;
        Object value = dataModel.getElementAt(row);
        boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        if (this.isFileList) {
            int w = Math.min(cw, rendererComponent.getPreferredSize().width + 4);
            if (!this.isLeftToRight) {
                cx += cw - w;
            }
            cw = w;
        }
        boolean isSelectedAnim = FadeTracker.getInstance().isTracked(this.list, row, FadeTracker.FadeKind.SELECTION);
        boolean isRolloverAnim = FadeTracker.getInstance().isTracked(this.list, row, FadeTracker.FadeKind.ROLLOVER);
        Integer currRoIndex = (Integer)this.list.getClientProperty(ROLLED_OVER_INDICES);
        boolean bl = isRollover = currRoIndex != null && currRoIndex == row;
        if (isSelected || isSelectedAnim) {
            g2d = (Graphics2D)g.create();
            g2d.setColor(rendererComponent.getBackground());
            g2d.fillRect(cx, cy, cw, ch);
            if (isSelectedAnim) {
                fadeCoef = FadeTracker.getInstance().getFade(this.list, row, FadeTracker.FadeKind.SELECTION);
                g2d.setComposite(AlphaComposite.getInstance(3, (float)fadeCoef / 10.0f));
            }
            backgroundDelegate.update(g2d, rendererComponent, new Rectangle(cx, cy, cw, ch), SubstanceCoreUtilities.getActiveScheme(this.list), true);
            g2d.dispose();
        } else if (isRolloverAnim) {
            g2d = (Graphics2D)g.create();
            g2d.setColor(rendererComponent.getBackground());
            g2d.fillRect(cx, cy, cw, ch);
            fadeCoef = FadeTracker.getInstance().getFade(this.list, row, FadeTracker.FadeKind.ROLLOVER);
            g2d.setComposite(AlphaComposite.getInstance(3, 0.65f * (float)fadeCoef / 10.0f));
            backgroundDelegate.update(g2d, rendererComponent, new Rectangle(cx, cy, cw, ch), SubstanceCoreUtilities.getActiveScheme(this.list), true);
            g2d.dispose();
        } else if (isRollover) {
            g2d = (Graphics2D)g.create();
            g2d.setColor(rendererComponent.getBackground());
            g2d.fillRect(cx, cy, cw, ch);
            g2d.setComposite(AlphaComposite.getInstance(3, 0.65f));
            backgroundDelegate.update(g2d, rendererComponent, new Rectangle(cx, cy, cw, ch), SubstanceCoreUtilities.getActiveScheme(this.list), true);
            g2d.dispose();
        }
        if (rendererComponent instanceof JComponent) {
            JComponent jRenderer;
            JComponent jComponent = jRenderer = (JComponent)rendererComponent;
            synchronized (jComponent) {
                boolean newOpaque;
                boolean bl2 = newOpaque = !isSelected && !isSelectedAnim && !isRollover && !isRolloverAnim;
                if (SubstanceLookAndFeel.toBleedWatermark()) {
                    newOpaque = false;
                }
                HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
                if (!newOpaque) {
                    SubstanceCoreUtilities.makeNonOpaque(jRenderer, opacity);
                }
                this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
                if (!newOpaque) {
                    SubstanceCoreUtilities.restoreOpaque(jRenderer, opacity);
                }
            }
        } else {
            this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
        }
    }

    protected class CellRepaintCallback
    implements FadeTracker.FadeTrackerCallback {
        protected int cellIndex;
        protected JList list;

        public CellRepaintCallback(JList list, int tabIndex) {
            this.list = list;
            this.cellIndex = tabIndex;
        }

        public void fadePerformed(FadeTracker.FadeKind fadeKind) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceListUI.this.list == null) {
                        return;
                    }
                    SubstanceListUI.this.maybeUpdateLayoutState();
                    int cellCount = CellRepaintCallback.this.list.getModel().getSize();
                    if (cellCount > 0 && CellRepaintCallback.this.cellIndex < cellCount) {
                        Rectangle rect = SubstanceListUI.this.getCellBounds(CellRepaintCallback.this.list, CellRepaintCallback.this.cellIndex, CellRepaintCallback.this.cellIndex);
                        CellRepaintCallback.this.list.repaint(rect);
                    }
                }
            });
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            if (SubstanceLookAndFeel.toBleedWatermark()) {
                return;
            }
            this.fadeOut();
            SubstanceListUI.this.list.putClientProperty(ROLLED_OVER_INDICES, null);
        }

        public void mouseMoved(MouseEvent e) {
            if (SubstanceLookAndFeel.toBleedWatermark()) {
                return;
            }
            this.handleMove(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (SubstanceLookAndFeel.toBleedWatermark()) {
                return;
            }
            this.handleMove(e);
        }

        private void handleMove(MouseEvent e) {
            int roIndex = SubstanceListUI.this.list.locationToIndex(e.getPoint());
            if (roIndex < 0 || roIndex >= SubstanceListUI.this.list.getModel().getSize()) {
                this.fadeOut();
                SubstanceListUI.this.list.putClientProperty(ROLLED_OVER_INDICES, null);
            } else {
                Integer currRoIndex = (Integer)SubstanceListUI.this.list.getClientProperty(ROLLED_OVER_INDICES);
                if (currRoIndex != null && currRoIndex == roIndex) {
                    return;
                }
                this.fadeOut();
                FadeTracker.getInstance().trackFadeIn(FadeTracker.FadeKind.ROLLOVER, SubstanceListUI.this.list, roIndex, false, new CellRepaintCallback(SubstanceListUI.this.list, roIndex));
                SubstanceListUI.this.list.putClientProperty(ROLLED_OVER_INDICES, roIndex);
            }
        }

        private void fadeOut() {
            Integer prevRoIndex = (Integer)SubstanceListUI.this.list.getClientProperty(ROLLED_OVER_INDICES);
            if (prevRoIndex == null) {
                return;
            }
            FadeTracker.getInstance().trackFadeOut(FadeTracker.FadeKind.ROLLOVER, SubstanceListUI.this.list, prevRoIndex, false, new CellRepaintCallback(SubstanceListUI.this.list, prevRoIndex));
        }
    }
}

