/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalProgressBarUI;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceProgressBarUI
extends MetalProgressBarUI {
    private static Map<String, BufferedImage> stripeMap = new HashMap<String, BufferedImage>();
    private int animationIndex;

    public static synchronized void reset() {
        stripeMap.clear();
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceProgressBarUI();
    }

    private static synchronized BufferedImage getStripe(int baseSize, boolean isRotated, ColorScheme colorScheme) {
        String key = "" + baseSize + ":" + isRotated + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme);
        BufferedImage result = stripeMap.get(key);
        if (result == null) {
            result = SubstanceImageCreator.getStripe(baseSize, colorScheme.getUltraLightColor());
            if (isRotated) {
                result = SubstanceImageCreator.getRotated(result, 1);
            }
            stripeMap.put(key, result);
        }
        return result;
    }

    public void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        Graphics2D graphics = (Graphics2D)g;
        if (this.progressBar.getOrientation() == 0) {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth, barRectHeight + 1, SubstanceCoreUtilities.getDisabledScheme(this.progressBar), null, 0, false);
        } else {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth + 1, barRectHeight, SubstanceCoreUtilities.getDisabledScheme(this.progressBar), null, 0, true);
        }
        if (amountFull > 0) {
            ColorScheme fillColorScheme;
            ColorScheme colorScheme = fillColorScheme = this.progressBar.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(this.progressBar) : SubstanceCoreUtilities.getDefaultScheme(this.progressBar);
            if (this.progressBar.getOrientation() == 0) {
                int barWidth = amountFull;
                int barHeight = barRectHeight;
                if (barWidth > 0 && barHeight > 0) {
                    if (c.getComponentOrientation().isLeftToRight()) {
                        SubstanceImageCreator.paintProgressBar(g, b.left, b.top, barWidth, barHeight, fillColorScheme, false);
                    } else {
                        SubstanceImageCreator.paintProgressBar(g, b.left + barRectWidth - amountFull, b.top, barWidth, barHeight, fillColorScheme, false);
                    }
                }
            } else {
                int barWidth = this.progressBar.getHeight() - b.bottom - amountFull;
                int barHeight = barRectWidth;
                if (barWidth > 0 && barHeight > 0) {
                    SubstanceImageCreator.paintProgressBar(g, b.left, barWidth, barHeight, amountFull, fillColorScheme, true);
                }
            }
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    public void paintIndeterminate(Graphics g, JComponent c) {
        ColorScheme fillColorScheme;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int valComplete = this.animationIndex;
        Graphics2D graphics = (Graphics2D)g;
        if (this.progressBar.getOrientation() == 0) {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth, barRectHeight + 1, SubstanceCoreUtilities.getDisabledScheme(this.progressBar), null, 0, false);
        } else {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth + 1, barRectHeight, SubstanceCoreUtilities.getDisabledScheme(this.progressBar), null, 0, true);
        }
        ColorScheme colorScheme = fillColorScheme = this.progressBar.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(this.progressBar) : SubstanceCoreUtilities.getDefaultScheme(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth, barRectHeight + 1, fillColorScheme, SubstanceProgressBarUI.getStripe(barRectHeight + 1, false, fillColorScheme), valComplete, false);
        } else {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth + 1, barRectHeight, fillColorScheme, SubstanceProgressBarUI.getStripe(barRectWidth + 1, true, fillColorScheme), 2 * barRectWidth + 1 - valComplete, true);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, barRectWidth, b);
        }
    }

    protected void incrementAnimationIndex() {
        int newValue = this.animationIndex + 1;
        Insets b = this.progressBar.getInsets();
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int threshold = 0;
        threshold = this.progressBar.getOrientation() == 0 ? 2 * barRectHeight + 1 : 2 * barRectWidth + 1;
        this.animationIndex = newValue % threshold;
        this.progressBar.repaint();
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceProgressBarUI: \n");
        sb.append("\t" + stripeMap.size() + " stripes");
        return sb.toString();
    }
}

