/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalSeparatorUI;
import org.jvnet.substance.utils.MenuUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceSeparatorUI
extends MetalSeparatorUI {
    public static ComponentUI createUI(JComponent c) {
        return new SubstanceSeparatorUI();
    }

    public void paint(Graphics g, JComponent c) {
        Container parent = c.getParent();
        if (!(parent instanceof JPopupMenu)) {
            super.paint(g, c);
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        int xOffset = MenuUtilities.getTextOffset(g, parent);
        Dimension s = c.getSize();
        if (parent.getComponentOrientation().isLeftToRight()) {
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, SubstanceCoreUtilities.getActiveScheme((JComponent)parent).getUltraLightColor(), xOffset, 0.0f, SubstanceCoreUtilities.getActiveScheme((JComponent)parent).getLightColor());
            graphics.setPaint(gp);
            graphics.fillRect(0, 0, xOffset - 2, c.getHeight());
            g.setColor(c.getForeground());
            g.drawLine(xOffset, 0, s.width, 0);
            g.setColor(c.getBackground());
            g.drawLine(xOffset, 1, s.width, 1);
        } else {
            GradientPaint gp = new GradientPaint(s.width - xOffset, 0.0f, SubstanceCoreUtilities.getActiveScheme((JComponent)parent).getUltraLightColor(), s.width, 0.0f, SubstanceCoreUtilities.getActiveScheme((JComponent)parent).getLightColor());
            graphics.setPaint(gp);
            graphics.fillRect(s.width - xOffset - 2, 0, s.width, c.getHeight());
            g.setColor(c.getForeground());
            g.drawLine(0, 0, s.width - xOffset - 4, 0);
            g.setColor(c.getBackground());
            g.drawLine(0, 1, s.width - xOffset - 4, 1);
        }
        graphics.dispose();
    }

    public Dimension getPreferredSize(JComponent c) {
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(2, 0);
        }
        return new Dimension(0, 2);
    }
}

