/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.button;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.border.Border;
import org.jvnet.substance.SubstanceButtonBorder;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.button.RectangularButtonShaper;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class StandardButtonShaper
extends BaseButtonShaper
implements RectangularButtonShaper {
    public static final int DEFAULT_WIDTH = 70;
    public static final int DEFAULT_HEIGHT = 20;
    public static Map<String, GeneralPath> contours = new HashMap<String, GeneralPath>();

    public String getDisplayName() {
        return "Standard";
    }

    public GeneralPath getButtonOutline(AbstractButton button, Insets insets) {
        int width = button.getWidth();
        int height = button.getHeight();
        Object sideProp = button.getClientProperty("substancelaf.buttonside");
        HashSet<SubstanceConstants.Side> straightSides = null;
        if (sideProp != null) {
            if (sideProp instanceof String) {
                straightSides = new HashSet<SubstanceConstants.Side>();
                straightSides.add(SubstanceConstants.Side.valueOf((String)sideProp));
            } else {
                String[] clientSides = (String[])sideProp;
                straightSides = new HashSet();
                for (String side : clientSides) {
                    straightSides.add(SubstanceConstants.Side.valueOf(side));
                }
            }
        }
        float radius = this.getCornerRadius(button, insets);
        String key = width + ":" + height + ":";
        if (straightSides != null) {
            for (SubstanceConstants.Side side : straightSides) {
                key = key + (Object)((Object)side) + ":";
            }
        }
        key = key + radius + ":";
        GeneralPath result = contours.get(key = key + (insets == null ? "null" : insets.toString()));
        if (result != null) {
            return result;
        }
        result = StandardButtonShaper.getBaseOutline(button, radius, straightSides, insets);
        contours.put(key, result);
        return result;
    }

    public GeneralPath getButtonOutline(AbstractButton button) {
        return this.getButtonOutline(button, null);
    }

    public Border getButtonBorder(AbstractButton button) {
        return new SubstanceButtonBorder(StandardButtonShaper.class){

            public Insets getBorderInsets(Component c) {
                AbstractButton button;
                if (c instanceof AbstractButton && SubstanceCoreUtilities.hasText(button = (AbstractButton)c)) {
                    return new Insets(0, 10, 0, 10);
                }
                return new Insets(0, 0, 0, 0);
            }
        };
    }

    public Dimension getPreferredSize(AbstractButton button, Dimension uiPreferredSize) {
        Insets margin;
        boolean toTweakWidth = false;
        boolean toTweakHeight = false;
        Icon icon = button.getIcon();
        boolean hasIcon = SubstanceCoreUtilities.hasIcon(button);
        boolean hasText = SubstanceCoreUtilities.hasText(button);
        Dimension result = uiPreferredSize;
        boolean hasNoMinSizeProperty = SubstanceCoreUtilities.hasNoMinSizeProperty(button);
        if (!hasNoMinSizeProperty && hasText) {
            int baseWidth = uiPreferredSize.width;
            if (baseWidth < 70) {
                baseWidth = 70;
            }
            result = new Dimension(baseWidth, uiPreferredSize.height);
            int baseHeight = result.height;
            if (baseHeight < 20) {
                baseHeight = 20;
            }
            result = new Dimension(result.width, baseHeight);
        } else if (hasNoMinSizeProperty && (margin = button.getMargin()) != null) {
            result = new Dimension(result.width + margin.left + margin.right, result.height + margin.top + margin.bottom);
        }
        if (hasIcon) {
            int iconWidth;
            int iconHeight = icon.getIconHeight();
            if ((double)iconHeight > result.getHeight() - 6.0) {
                result = new Dimension(result.width, iconHeight);
                toTweakHeight = true;
            }
            if ((double)(iconWidth = icon.getIconWidth()) > result.getWidth() - 6.0) {
                result = new Dimension(iconWidth, result.height);
                toTweakWidth = true;
            }
        }
        if (SubstanceCoreUtilities.isScrollBarButton(button)) {
            toTweakWidth = false;
            toTweakHeight = false;
        }
        if (toTweakWidth) {
            result = new Dimension(result.width + 6, result.height);
        }
        if (toTweakHeight) {
            result = new Dimension(result.width, result.height + 6);
        }
        return result;
    }

    public static boolean isRoundButton(AbstractButton button) {
        return !SubstanceCoreUtilities.isComboBoxButton(button) && !SubstanceCoreUtilities.isScrollButton(button) && SubstanceCoreUtilities.hasText(button);
    }

    public boolean isProportionate() {
        return true;
    }

    public float getCornerRadius(AbstractButton button, Insets insets) {
        int width = button.getWidth();
        int height = button.getHeight();
        boolean isRoundCorners = StandardButtonShaper.isRoundButton(button);
        float radius = 2.0f;
        if (insets != null) {
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        if (isRoundCorners) {
            radius = width > height ? (float)height / 2.0f : (float)width / 2.0f;
        }
        if (SubstanceCoreUtilities.isToolBarButton(button)) {
            radius = SubstanceCoreUtilities.getToolbarButtonCornerRadius(button, insets);
        }
        return radius;
    }
}

