/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.color;

import java.awt.Color;
import org.jvnet.substance.color.BaseColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class MixBiColorScheme
extends BaseColorScheme {
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private ColorScheme origMainScheme;
    private ColorScheme origSecondaryScheme;

    public MixBiColorScheme(ColorScheme origMainScheme, ColorScheme origSecondaryScheme) {
        this.origMainScheme = origMainScheme;
        this.origSecondaryScheme = origSecondaryScheme;
        this.foregroundColor = origMainScheme.getForegroundColor();
        this.mainUltraDarkColor = origMainScheme.getUltraDarkColor();
        this.mainDarkColor = origMainScheme.getDarkColor();
        this.mainMidColor = origMainScheme.getMidColor();
        this.mainLightColor = origMainScheme.getLightColor();
        this.mainExtraLightColor = origMainScheme.getExtraLightColor();
        this.mainUltraLightColor = origMainScheme.getUltraLightColor();
        this.id = "Mixed " + SubstanceCoreUtilities.getSchemeId(origMainScheme) + " & " + SubstanceCoreUtilities.getSchemeId(origSecondaryScheme);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    public Color getLightColor() {
        return this.mainLightColor;
    }

    public Color getMidColor() {
        return this.mainMidColor;
    }

    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public ColorScheme getOrigMainScheme() {
        return this.origMainScheme;
    }

    public ColorScheme getOrigSecondaryScheme() {
        return this.origSecondaryScheme;
    }
}

