/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import org.jvnet.substance.color.AquaColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.ShiftColorScheme;
import org.jvnet.substance.color.SunsetColorScheme;
import org.jvnet.substance.theme.SubstanceAquaTheme;
import org.jvnet.substance.theme.SubstanceBarbyPinkTheme;
import org.jvnet.substance.theme.SubstanceBlendBiTheme;
import org.jvnet.substance.theme.SubstanceBottleGreenTheme;
import org.jvnet.substance.theme.SubstanceBrownTheme;
import org.jvnet.substance.theme.SubstanceCharcoalTheme;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceEbonyTheme;
import org.jvnet.substance.theme.SubstanceLimeGreenTheme;
import org.jvnet.substance.theme.SubstanceMixBiTheme;
import org.jvnet.substance.theme.SubstanceOrangeTheme;
import org.jvnet.substance.theme.SubstancePurpleTheme;
import org.jvnet.substance.theme.SubstanceSteelBlueTheme;
import org.jvnet.substance.theme.SubstanceSunGlareTheme;
import org.jvnet.substance.theme.SubstanceSunsetTheme;
import org.jvnet.substance.theme.SubstanceTheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexThemeFactory {
    public static SubstanceTheme getOffice2007Theme() {
        ShiftColorScheme shiftBlue = new ShiftColorScheme(new AquaColorScheme(), new Color(100, 150, 255), 0.3);
        SubstanceTheme activeTheme = new SubstanceOrangeTheme().saturate(0.4);
        SubstanceTheme defaultTheme = new SubstanceTheme(shiftBlue, "Aqua Blue", SubstanceTheme.ThemeKind.BRIGHT).saturate(-0.3);
        SubstanceTheme disabledTheme = new SubstanceBlendBiTheme(new SubstanceAquaTheme(), new SubstanceSteelBlueTheme(), 0.8).tint(0.6);
        SubstanceTheme activeTitleTheme = defaultTheme.saturate(0.2);
        return new SubstanceComplexTheme("Office 2007", SubstanceTheme.ThemeKind.BRIGHT, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
    }

    public static SubstanceTheme getGreenMagicTheme() {
        SubstanceTheme activeTheme = new SubstanceBlendBiTheme(new SubstanceAquaTheme(), new SubstanceBottleGreenTheme(), 0.5).saturate(0.7);
        SubstanceTheme defaultTheme = new SubstanceBlendBiTheme(new SubstanceAquaTheme(), new SubstanceLimeGreenTheme(), 0.5).tone(0.1).saturate(-0.2);
        SubstanceTheme disabledTheme = defaultTheme.saturate(-0.3);
        SubstanceTheme activeTitleTheme = defaultTheme.saturate(0.4);
        return new SubstanceComplexTheme("Green Magic", SubstanceTheme.ThemeKind.BRIGHT, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
    }

    public static SubstanceTheme getGreenTestTheme() {
        SubstanceTheme activeTheme = new SubstanceBlendBiTheme(new SubstanceAquaTheme(), new SubstanceBottleGreenTheme(), 0.5).saturate(0.7);
        SubstanceTheme defaultTheme = new SubstanceBlendBiTheme(new SubstanceAquaTheme(), new SubstanceLimeGreenTheme(), 0.5).tone(0.1).saturate(-0.2);
        SubstanceTheme disabledTheme = defaultTheme.saturate(-0.3);
        SubstanceTheme activeTitleTheme = new SubstanceBarbyPinkTheme().invert().saturate(0.2);
        return new SubstanceComplexTheme("Green Invert", SubstanceTheme.ThemeKind.BRIGHT, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
    }

    public static SubstanceTheme getMangoTheme() {
        SubstanceTheme activeTheme = new SubstanceMixBiTheme(new SubstanceSunGlareTheme(), new SubstanceBarbyPinkTheme()).saturate(0.2);
        SubstanceTheme defaultTheme = new SubstanceBlendBiTheme(new SubstanceAquaTheme(), new SubstanceLimeGreenTheme(), 0.5).tone(0.1).saturate(-0.2);
        SubstanceTheme disabledTheme = defaultTheme.saturate(-0.3);
        SubstanceTheme activeTitleTheme = activeTheme.saturate(-0.2);
        return new SubstanceComplexTheme("Mango", SubstanceTheme.ThemeKind.BRIGHT, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
    }

    public static SubstanceTheme getStreetlightsTheme() {
        SubstanceTheme activeTheme = new SubstanceSunsetTheme().saturate(0.4);
        SubstanceEbonyTheme defaultTheme = new SubstanceEbonyTheme();
        SubstanceMixBiTheme disabledTheme = new SubstanceMixBiTheme(new SubstanceBlendBiTheme(new SubstanceBottleGreenTheme(), new SubstanceSteelBlueTheme(), 0.8).shade(0.6), new SubstanceBlendBiTheme(new SubstanceAquaTheme(), new SubstanceSteelBlueTheme(), 0.8).shade(0.6));
        SubstanceTheme activeTitleTheme = defaultTheme.saturate(0.2);
        return new SubstanceComplexTheme("Streetlights", SubstanceTheme.ThemeKind.DARK, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
    }

    public static SubstanceTheme getMagmaTheme() {
        ShiftColorScheme shiftRed = new ShiftColorScheme(new SunsetColorScheme(){

            public Color getForegroundColor() {
                return Color.white;
            }
        }, Color.red, 0.3);
        SubstanceTheme activeTheme = new SubstanceTheme(shiftRed, "Red sunset", SubstanceTheme.ThemeKind.DARK).saturate(0.4);
        SubstanceCharcoalTheme defaultTheme = new SubstanceCharcoalTheme();
        SubstanceTheme disabledTheme = defaultTheme.tone(0.2);
        SubstanceTheme activeTitleTheme = defaultTheme.saturate(0.2);
        return new SubstanceComplexTheme("Magma", SubstanceTheme.ThemeKind.DARK, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
    }

    public static SubstanceTheme getFindingNemoTheme() {
        SubstanceTheme activeTheme = new SubstanceMixBiTheme(new SubstancePurpleTheme(), new SubstanceBarbyPinkTheme()).saturate(0.5);
        SubstanceTheme defaultTheme = new SubstanceMixBiTheme(new SubstanceAquaTheme(), new SubstanceBottleGreenTheme()).saturate(0.3).tint(0.2);
        SubstanceTheme disabledTheme = defaultTheme.saturate(-0.3);
        SubstanceTheme activeTitleTheme = activeTheme.saturate(-0.1);
        return new SubstanceComplexTheme("Finding Nemo", SubstanceTheme.ThemeKind.BRIGHT, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
    }

    public static SubstanceTheme getFieldOfWheatTheme() {
        SubstanceTheme activeTheme = new SubstanceAquaTheme().saturate(0.1);
        SubstanceBrownTheme defaultTheme = new SubstanceBrownTheme();
        SubstanceTheme disabledTheme = new SubstanceBlendBiTheme(new SubstanceBrownTheme(), new SubstanceSunGlareTheme(), 0.3f).saturate(-0.2);
        SubstanceTheme activeTitleTheme = defaultTheme.saturate(0.4);
        return new SubstanceComplexTheme("Field of Wheat", SubstanceTheme.ThemeKind.BRIGHT, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
    }

    public static SubstanceTheme getEbonyHighContrastTheme() {
        ColorScheme metallic = new ColorScheme(){
            private final Color mainUltraLightColor = new Color(125, 126, 128);
            private final Color mainExtraLightColor = new Color(120, 122, 125);
            private final Color mainLightColor = new Color(100, 105, 110);
            private final Color mainMidColor = new Color(90, 92, 95);
            private final Color mainDarkColor = new Color(40, 42, 45);
            private final Color mainUltraDarkColor = new Color(16, 19, 21);
            private final Color foregroundColor = Color.white;

            public Color getForegroundColor() {
                return this.foregroundColor;
            }

            public Color getUltraLightColor() {
                return this.mainUltraLightColor;
            }

            public Color getExtraLightColor() {
                return this.mainExtraLightColor;
            }

            public Color getLightColor() {
                return this.mainLightColor;
            }

            public Color getMidColor() {
                return this.mainMidColor;
            }

            public Color getDarkColor() {
                return this.mainDarkColor;
            }

            public Color getUltraDarkColor() {
                return this.mainUltraDarkColor;
            }
        };
        ColorScheme gray = new ColorScheme(){
            private final Color mainUltraLightColor = new Color(125, 125, 125);
            private final Color mainExtraLightColor = new Color(120, 120, 120);
            private final Color mainLightColor = new Color(112, 112, 112);
            private final Color mainMidColor = new Color(105, 105, 105);
            private final Color mainDarkColor = new Color(90, 90, 90);
            private final Color mainUltraDarkColor = new Color(50, 50, 50);
            private final Color foregroundColor = Color.white;

            public Color getForegroundColor() {
                return this.foregroundColor;
            }

            public Color getUltraLightColor() {
                return this.mainUltraLightColor;
            }

            public Color getExtraLightColor() {
                return this.mainExtraLightColor;
            }

            public Color getLightColor() {
                return this.mainLightColor;
            }

            public Color getMidColor() {
                return this.mainMidColor;
            }

            public Color getDarkColor() {
                return this.mainDarkColor;
            }

            public Color getUltraDarkColor() {
                return this.mainUltraDarkColor;
            }
        };
        return new SubstanceComplexTheme("Ebony High Contrast", SubstanceTheme.ThemeKind.DARK, new SubstanceEbonyTheme(), new SubstanceTheme(metallic, "Contrast Metallic", SubstanceTheme.ThemeKind.DARK), new SubstanceTheme(gray, "Contrast Gray", SubstanceTheme.ThemeKind.DARK), new SubstanceEbonyTheme());
    }

    public static List<SubstanceTheme> getAllComplexThemes() {
        LinkedList<SubstanceTheme> result = new LinkedList<SubstanceTheme>();
        result.add(ComplexThemeFactory.getFindingNemoTheme());
        result.add(ComplexThemeFactory.getGreenMagicTheme());
        result.add(ComplexThemeFactory.getGreenTestTheme());
        result.add(ComplexThemeFactory.getMagmaTheme());
        result.add(ComplexThemeFactory.getMangoTheme());
        result.add(ComplexThemeFactory.getOffice2007Theme());
        result.add(ComplexThemeFactory.getStreetlightsTheme());
        result.add(ComplexThemeFactory.getFieldOfWheatTheme());
        result.add(ComplexThemeFactory.getEbonyHighContrastTheme());
        return result;
    }
}

