/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import org.jvnet.substance.color.BlendBiColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;

public class SubstanceBlendBiTheme
extends SubstanceTheme {
    private SubstanceTheme originalFirstTheme;
    private SubstanceTheme originalSecondTheme;
    private double firstThemeLikeness;

    public SubstanceBlendBiTheme(SubstanceTheme originalFirstTheme, SubstanceTheme originalSecondTheme, double firstThemeLikeness) {
        super(new BlendBiColorScheme(originalFirstTheme.getColorScheme(), originalSecondTheme.getColorScheme(), firstThemeLikeness), "Blended " + originalFirstTheme.getDisplayName() + " & " + originalSecondTheme.getDisplayName() + " " + firstThemeLikeness, firstThemeLikeness >= 0.5 ? originalFirstTheme.getKind() : originalSecondTheme.getKind());
        this.originalFirstTheme = originalFirstTheme;
        this.originalSecondTheme = originalSecondTheme;
        this.firstThemeLikeness = firstThemeLikeness;
    }

    public SubstanceTheme tint(double tintFactor) {
        return new SubstanceBlendBiTheme(this.originalFirstTheme.tint(tintFactor), this.originalSecondTheme.tint(tintFactor), this.firstThemeLikeness);
    }

    public SubstanceTheme tone(double toneFactor) {
        return new SubstanceBlendBiTheme(this.originalFirstTheme.tone(toneFactor), this.originalSecondTheme.tone(toneFactor), this.firstThemeLikeness);
    }

    public SubstanceTheme shade(double shadeFactor) {
        return new SubstanceBlendBiTheme(this.originalFirstTheme.shade(shadeFactor), this.originalSecondTheme.shade(shadeFactor), this.firstThemeLikeness);
    }

    public SubstanceTheme saturate(double saturateFactor) {
        return new SubstanceBlendBiTheme(this.originalFirstTheme.saturate(saturateFactor), this.originalSecondTheme.saturate(saturateFactor), this.firstThemeLikeness);
    }

    public SubstanceTheme invert() {
        return new SubstanceBlendBiTheme(this.originalFirstTheme.invert(), this.originalSecondTheme.invert(), this.firstThemeLikeness);
    }

    public SubstanceTheme getOriginalFirstTheme() {
        return this.originalFirstTheme;
    }

    public SubstanceTheme getOriginalSecondTheme() {
        return this.originalSecondTheme;
    }
}

