/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import java.awt.Color;
import org.jvnet.substance.color.InvertedColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.SubstanceWrapperTheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceInvertedTheme
extends SubstanceWrapperTheme {
    public SubstanceInvertedTheme(SubstanceTheme substanceTheme) {
        super(substanceTheme, new InvertedColorScheme(substanceTheme.getColorScheme()), "Inverted " + substanceTheme.getDisplayName(), SubstanceTheme.ThemeKind.INVERTED);
        this.originalTheme = substanceTheme;
    }

    public SubstanceTheme invert() {
        return this.originalTheme;
    }

    public Color getWatermarkStampColor() {
        return SubstanceCoreUtilities.isThemeDark(this) ? this.getUltraDarkColor(60) : this.getUltraLightColor(25);
    }

    public SubstanceTheme saturate(double saturateFactor) {
        return new SubstanceInvertedTheme(this.originalTheme.saturate(saturateFactor));
    }

    public SubstanceTheme tint(double tintFactor) {
        return new SubstanceInvertedTheme(this.originalTheme.tint(tintFactor));
    }

    public SubstanceTheme tone(double toneFactor) {
        return new SubstanceInvertedTheme(this.originalTheme.tone(toneFactor));
    }

    public SubstanceTheme shade(double shadeFactor) {
        return new SubstanceInvertedTheme(this.originalTheme.shade(shadeFactor));
    }
}

