/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.title;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import org.jvnet.substance.SubstanceInternalFrameTitlePane;
import org.jvnet.substance.SubstanceInternalFrameUI;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceRootPaneUI;
import org.jvnet.substance.SubstanceTitlePane;
import org.jvnet.substance.theme.ThemeChangeListener;
import org.jvnet.substance.title.TitleButtonInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TitleButtonManager {
    private Map<JRootPane, List<AbstractButton>> customTitlePaneButtons = new HashMap<JRootPane, List<AbstractButton>>();
    private Map<JRootPane, List<TitleButton>> customTitlePaneButtonsExtra = new HashMap<JRootPane, List<TitleButton>>();
    private Map<JRootPane, ThemeChangeListener> themeChangeListeners = new HashMap<JRootPane, ThemeChangeListener>();
    private static TitleButtonManager instance;

    private TitleButtonManager() {
    }

    public static synchronized TitleButtonManager getManager() {
        if (instance == null) {
            instance = new TitleButtonManager();
        }
        return instance;
    }

    public synchronized void setRootPaneCustomTitleButtons(final JRootPane rootPane, List<TitleButtonInfo> infoList) {
        JComponent titlePane;
        ThemeChangeListener currThemeChangeListener = this.themeChangeListeners.get(rootPane);
        if (currThemeChangeListener != null) {
            SubstanceLookAndFeel.unregisterThemeChangeListener(currThemeChangeListener);
        }
        LinkedList<TitleButton> newButtonsExtra = new LinkedList<TitleButton>();
        LinkedList<AbstractButton> newButtons = new LinkedList<AbstractButton>();
        for (TitleButtonInfo tButtonInfo : infoList) {
            JButton tButton = new JButton();
            tButton.setToolTipText(tButtonInfo.getTooltipText());
            tButton.addActionListener(tButtonInfo.getActionListener());
            tButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            tButton.setFocusable(false);
            tButton.setFocusPainted(false);
            newButtonsExtra.add(new TitleButton(tButton, tButtonInfo));
            newButtons.add(0, tButton);
        }
        this.customTitlePaneButtons.put(rootPane, newButtons);
        this.customTitlePaneButtonsExtra.put(rootPane, newButtonsExtra);
        this.updateButtonIcons(rootPane);
        ThemeChangeListener newThemeChangeListener = new ThemeChangeListener(){

            public void themeChanged() {
                TitleButtonManager.this.updateButtonIcons(rootPane);
            }
        };
        this.themeChangeListeners.put(rootPane, newThemeChangeListener);
        SubstanceLookAndFeel.registerThemeChangeListener(newThemeChangeListener);
        if (rootPane.getParent() instanceof JInternalFrame) {
            SubstanceInternalFrameUI ifUi = (SubstanceInternalFrameUI)((JInternalFrame)rootPane.getParent()).getUI();
            titlePane = ifUi.getTitlePane();
            if (titlePane != null) {
                ((SubstanceInternalFrameTitlePane)titlePane).setCustomTitleButtons(newButtons);
                titlePane.doLayout();
                titlePane.repaint();
            }
        } else {
            SubstanceRootPaneUI rootPaneUi = (SubstanceRootPaneUI)rootPane.getUI();
            titlePane = (SubstanceTitlePane)rootPaneUi.getTitlePane();
            if (titlePane != null) {
                ((SubstanceTitlePane)titlePane).setCustomTitleButtons(newButtons);
                titlePane.doLayout();
                titlePane.repaint();
            }
        }
    }

    public synchronized void removeRootPaneCustomTitleButtons(JRootPane rootPane) {
        this.customTitlePaneButtons.remove(rootPane);
        this.customTitlePaneButtonsExtra.remove(rootPane);
        ThemeChangeListener currThemeChangeListener = this.themeChangeListeners.remove(rootPane);
        if (currThemeChangeListener != null) {
            SubstanceLookAndFeel.unregisterThemeChangeListener(currThemeChangeListener);
        }
        if (rootPane.getParent() instanceof JInternalFrame) {
            SubstanceInternalFrameUI ifUi = (SubstanceInternalFrameUI)((JInternalFrame)rootPane.getParent()).getUI();
            SubstanceInternalFrameTitlePane titlePane = ifUi.getTitlePane();
            if (titlePane != null) {
                titlePane.setCustomTitleButtons(null);
                titlePane.doLayout();
                titlePane.repaint();
            }
        } else {
            SubstanceRootPaneUI rootPaneUi = (SubstanceRootPaneUI)rootPane.getUI();
            SubstanceTitlePane titlePane = (SubstanceTitlePane)rootPaneUi.getTitlePane();
            if (titlePane != null) {
                titlePane.setCustomTitleButtons(null);
                titlePane.doLayout();
                titlePane.repaint();
            }
        }
    }

    private void updateButtonIcons(JRootPane rootPane) {
        List<TitleButton> tButtons = this.customTitlePaneButtonsExtra.get(rootPane);
        if (tButtons == null) {
            return;
        }
        for (TitleButton tButton : tButtons) {
            Icon tIcon = tButton.tButtonInfo.getButtonCallback().getTitleButtonIcon(SubstanceLookAndFeel.getTheme(), 16, 16);
            if (tIcon.getIconWidth() > 16 || tIcon.getIconHeight() > 16) {
                throw new IllegalArgumentException("Title button callback returned image icon of illegal size");
            }
            tButton.tButton.setIcon(tIcon);
        }
    }

    public List<AbstractButton> getCustomButtons(JRootPane rootPane) {
        return this.customTitlePaneButtons.get(rootPane);
    }

    private static class TitleButton {
        public AbstractButton tButton;
        public TitleButtonInfo tButtonInfo;

        public TitleButton(AbstractButton button, TitleButtonInfo buttonInfo) {
            this.tButton = button;
            this.tButtonInfo = buttonInfo;
        }
    }
}

