/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceTabbedPaneUI;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class TabPulseTracker
implements ActionListener {
    private static WeakHashMap<JTabbedPane, Map<Component, TabPulseTracker>> trackers = new WeakHashMap();
    private static WeakHashMap<JTabbedPane, Map<Component, Long>> cycles = new WeakHashMap();
    private WeakReference<JTabbedPane> tabbedPane;
    private WeakReference<Component> tabComponent;
    private Timer timer;

    private TabPulseTracker(JTabbedPane tabbedPane, Component tabComponent) {
        this.tabbedPane = new WeakReference<JTabbedPane>(tabbedPane);
        this.tabComponent = new WeakReference<Component>(tabComponent);
        this.timer = new Timer(50, this);
        this.timer.setCoalesce(true);
    }

    private static boolean hasGlassPane(Component component) {
        if (component == null) {
            return false;
        }
        Component glassPane = null;
        if (component instanceof JDialog) {
            glassPane = ((JDialog)component).getGlassPane();
        }
        if (component instanceof JFrame) {
            glassPane = ((JFrame)component).getGlassPane();
        }
        return glassPane != null && glassPane.isVisible();
    }

    public void actionPerformed(ActionEvent event) {
        JTabbedPane jtp = (JTabbedPane)this.tabbedPane.get();
        if (jtp == null) {
            return;
        }
        Component comp = (Component)this.tabComponent.get();
        if (comp == null) {
            return;
        }
        if (TabPulseTracker.hasGlassPane(jtp.getTopLevelAncestor())) {
            return;
        }
        if (!SubstanceCoreUtilities.isTabModified(comp) || comp.getParent() == null) {
            TabPulseTracker tracker = TabPulseTracker.getTracker(jtp, comp);
            tracker.stopTimer();
            tracker.tabbedPane.clear();
            tracker.tabComponent.clear();
            TabPulseTracker.removeTracker(jtp, comp);
            TabPulseTracker.removeCycleCount(jtp, comp);
        } else {
            long oldCycle = TabPulseTracker.getRealCycles(jtp, comp);
            if (oldCycle == 20L) {
                oldCycle = -80L;
            }
            TabPulseTracker.saveCycleCount(jtp, comp, oldCycle + 1L);
        }
        if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {
            int index = jtp.indexOfComponent(comp);
            if (index < 0) {
                this.stopTimer();
                return;
            }
            SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)jtp.getUI();
            FadeTracker.FadeTrackerCallback callback = ui.getCallback(index);
            callback.fadePerformed(FadeTracker.FadeKind.MARKED_MODIFIED);
        }
    }

    private void startTimer() {
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    private void stopTimer() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    private boolean isRunning() {
        return this.timer.isRunning();
    }

    public static synchronized void update(JTabbedPane tabbedPane, Component tabComponent) {
        boolean isModified = SubstanceCoreUtilities.isTabModified(tabComponent);
        TabPulseTracker tracker = TabPulseTracker.getTracker(tabbedPane, tabComponent);
        long cycleCount = TabPulseTracker.getRealCycles(tabbedPane, tabComponent);
        if (!isModified) {
            if (tracker == null) {
                return;
            }
            if (cycleCount == 0L) {
                return;
            }
            TabPulseTracker.saveCycleCount(tabbedPane, tabComponent, 0L);
        } else {
            if (tracker != null) {
                tracker.startTimer();
                return;
            }
            tracker = new TabPulseTracker(tabbedPane, tabComponent);
            tracker.startTimer();
            TabPulseTracker.saveTracker(tabbedPane, tabComponent, tracker);
            long initialCycle = -80L;
            TabPulseTracker.saveCycleCount(tabbedPane, tabComponent, initialCycle);
        }
    }

    protected static long getRealCycles(JTabbedPane tabbedPane, Component tabComponent) {
        Map<Component, Long> map = cycles.get(tabbedPane);
        if (map == null) {
            return 0L;
        }
        Long cycleCount = map.get(tabComponent);
        if (cycleCount == null) {
            return 0L;
        }
        long result = cycleCount;
        return result;
    }

    public static long getCycles(JTabbedPane tabbedPane, Component tabComponent) {
        long result = TabPulseTracker.getRealCycles(tabbedPane, tabComponent);
        if (result < 0L) {
            result = 0L;
        }
        return result;
    }

    public static boolean isAnimating(JTabbedPane tabbedPane, Component tabComponent) {
        Map<Component, TabPulseTracker> map = trackers.get(tabbedPane);
        if (map == null) {
            return false;
        }
        TabPulseTracker tracker = map.get(tabComponent);
        if (tracker == null) {
            return false;
        }
        return tracker.isRunning();
    }

    private static TabPulseTracker getTracker(JTabbedPane tabbedPane, Component tabComponent) {
        Map<Component, TabPulseTracker> map = trackers.get(tabbedPane);
        if (map == null) {
            return null;
        }
        return map.get(tabComponent);
    }

    private static void saveTracker(JTabbedPane tabbedPane, Component tabComponent, TabPulseTracker tracker) {
        if (!trackers.containsKey(tabbedPane)) {
            trackers.put(tabbedPane, new HashMap());
        }
        trackers.get(tabbedPane).put(tabComponent, tracker);
    }

    private static void saveCycleCount(JTabbedPane tabbedPane, Component tabComponent, long cycleCount) {
        if (!cycles.containsKey(tabbedPane)) {
            cycles.put(tabbedPane, new HashMap());
        }
        cycles.get(tabbedPane).put(tabComponent, cycleCount);
    }

    private static void removeTracker(JTabbedPane tabbedPane, Component tabComponent) {
        if (!trackers.containsKey(tabbedPane)) {
            return;
        }
        trackers.get(tabbedPane).remove(tabComponent);
        if (trackers.get(tabbedPane).size() == 0) {
            trackers.remove(tabbedPane);
        }
    }

    private static void removeCycleCount(JTabbedPane tabbedPane, Component tabComponent) {
        if (!cycles.containsKey(tabbedPane)) {
            return;
        }
        cycles.get(tabbedPane).remove(tabComponent);
        if (cycles.get(tabbedPane).size() == 0) {
            cycles.remove(tabbedPane);
        }
    }

    public static void stopAllTimers() {
        for (Map<Component, TabPulseTracker> map : trackers.values()) {
            for (TabPulseTracker tracker : map.values()) {
                tracker.stopTimer();
            }
            map.clear();
        }
        trackers.clear();
    }
}

