/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.icons.ImageHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class BaseIcons {
    private static Icon checkBoxIcon = null;
    private static Icon radioButtonIcon = null;
    private static Icon optionPaneErrorIcon = null;
    private static Icon optionPaneWarningIcon = null;
    private static Icon optionPaneInformationIcon = null;
    private static Icon optionPaneQuestionIcon = null;
    private static Icon fileChooserDetailViewIcon = null;
    private static Icon fileChooserHomeFolderIcon = null;
    private static Icon fileChooserListViewIcon = null;
    private static Icon fileChooserNewFolderIcon = null;
    private static Icon fileChooserUpFolderIcon = null;
    private static Icon treeComputerIcon = null;
    private static Icon treeFloppyDriveIcon = null;
    private static Icon treeHardDriveIcon = null;
    private static Icon treeFolderIcon = null;
    private static Icon treeLeafIcon = null;
    private static Icon treeOpenIcon = null;
    private static Icon treeClosedIcon = null;
    private static Icon paletteCloseIcon = null;
    private static Icon menuIcon = null;
    private static Icon iconIcon = null;
    private static Icon maxIcon = null;
    private static Icon minIcon = null;
    private static Icon closeIcon = null;
    private static Icon upArrowIcon = null;
    private static Icon downArrowIcon = null;
    private static Icon leftArrowIcon = null;
    private static Icon rightArrowIcon = null;
    private static Icon splitterUpArrowIcon = null;
    private static Icon splitterDownArrowIcon = null;
    private static Icon splitterLeftArrowIcon = null;
    private static Icon splitterRightArrowIcon = null;
    private static Icon splitterHorBumpIcon = null;
    private static Icon splitterVerBumpIcon = null;
    private static Icon thumbHorIcon = null;
    private static Icon thumbVerIcon = null;
    private static Icon thumbHorIconRollover = null;
    private static Icon thumbVerIconRollover = null;

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getOptionPaneErrorIcon() {
        if (optionPaneErrorIcon == null) {
            optionPaneErrorIcon = ImageHelper.loadImage("Error.gif");
        }
        return optionPaneErrorIcon;
    }

    public static Icon getOptionPaneWarningIcon() {
        if (optionPaneWarningIcon == null) {
            optionPaneWarningIcon = ImageHelper.loadImage("Warning.gif");
        }
        return optionPaneWarningIcon;
    }

    public static Icon getOptionPaneInformationIcon() {
        if (optionPaneInformationIcon == null) {
            optionPaneInformationIcon = ImageHelper.loadImage("Inform.gif");
        }
        return optionPaneInformationIcon;
    }

    public static Icon getOptionPaneQuestionIcon() {
        if (optionPaneQuestionIcon == null) {
            optionPaneQuestionIcon = ImageHelper.loadImage("Question.gif");
        }
        return optionPaneQuestionIcon;
    }

    public static Icon getFileChooserDetailViewIcon() {
        if (fileChooserDetailViewIcon == null) {
            fileChooserDetailViewIcon = ImageHelper.loadImage("DetailsView.gif");
        }
        return fileChooserDetailViewIcon;
    }

    public static Icon getFileChooserHomeFolderIcon() {
        if (fileChooserHomeFolderIcon == null) {
            fileChooserHomeFolderIcon = ImageHelper.loadImage("Home.gif");
        }
        return fileChooserHomeFolderIcon;
    }

    public static Icon getFileChooserListViewIcon() {
        if (fileChooserListViewIcon == null) {
            fileChooserListViewIcon = ImageHelper.loadImage("ListView.gif");
        }
        return fileChooserListViewIcon;
    }

    public static Icon getFileChooserNewFolderIcon() {
        if (fileChooserNewFolderIcon == null) {
            fileChooserNewFolderIcon = ImageHelper.loadImage("NewFolder.gif");
        }
        return fileChooserNewFolderIcon;
    }

    public static Icon getFileChooserUpFolderIcon() {
        if (fileChooserUpFolderIcon == null) {
            fileChooserUpFolderIcon = ImageHelper.loadImage("UpFolder.gif");
        }
        return fileChooserUpFolderIcon;
    }

    public static Icon getTreeComputerIcon() {
        if (treeComputerIcon == null) {
            treeComputerIcon = ImageHelper.loadImage("Computer.gif");
        }
        return treeComputerIcon;
    }

    public static Icon getTreeFloppyDriveIcon() {
        if (treeFloppyDriveIcon == null) {
            treeFloppyDriveIcon = ImageHelper.loadImage("FloppyDrive.gif");
        }
        return treeFloppyDriveIcon;
    }

    public static Icon getTreeHardDriveIcon() {
        if (treeHardDriveIcon == null) {
            treeHardDriveIcon = ImageHelper.loadImage("HardDrive.gif");
        }
        return treeHardDriveIcon;
    }

    public static Icon getTreeFolderIcon() {
        if (treeFolderIcon == null) {
            treeFolderIcon = ImageHelper.loadImage("TreeClosed.gif");
        }
        return treeFolderIcon;
    }

    public static Icon getTreeLeafIcon() {
        if (treeLeafIcon == null) {
            treeLeafIcon = ImageHelper.loadImage("TreeLeaf.gif");
        }
        return treeLeafIcon;
    }

    public static Icon getTreeControlIcon(boolean bl) {
        if (bl) {
            if (treeClosedIcon == null) {
                treeClosedIcon = ImageHelper.loadImage("TreeClosedButton.gif");
            }
            return treeClosedIcon;
        }
        if (treeOpenIcon == null) {
            treeOpenIcon = ImageHelper.loadImage("TreeOpenButton.gif");
        }
        return treeOpenIcon;
    }

    public static Icon getMenuIcon() {
        if (menuIcon == null) {
            menuIcon = ImageHelper.loadImage("JavaCup.gif");
        }
        return menuIcon;
    }

    public static Icon getIconIcon() {
        if (iconIcon == null) {
            iconIcon = new IconSymbol(Color.black, null, Color.red);
        }
        return iconIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            maxIcon = new MaxSymbol(Color.black, null, Color.red);
        }
        return maxIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            minIcon = new MinSymbol(Color.black, null, Color.red);
        }
        return minIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = new CloseSymbol(Color.black, null, Color.red);
        }
        return closeIcon;
    }

    public static Icon getPaletteCloseIcon() {
        if (paletteCloseIcon == null) {
            paletteCloseIcon = new CloseSymbol(Color.black, null, Color.red);
        }
        return paletteCloseIcon;
    }

    public static Icon getMenuArrowIcon() {
        return BaseIcons.getRightArrowIcon();
    }

    public static Icon getMenuCheckBoxIcon() {
        return BaseIcons.getCheckBoxIcon();
    }

    public static Icon getMenuRadioButtonIcon() {
        return BaseIcons.getRadioButtonIcon();
    }

    public static Icon getUpArrowIcon() {
        if (upArrowIcon == null) {
            upArrowIcon = ImageHelper.loadImage("UpArrow.gif");
        }
        return upArrowIcon;
    }

    public static Icon getDownArrowIcon() {
        if (downArrowIcon == null) {
            downArrowIcon = ImageHelper.loadImage("DownArrow.gif");
        }
        return downArrowIcon;
    }

    public static Icon getLeftArrowIcon() {
        if (leftArrowIcon == null) {
            leftArrowIcon = ImageHelper.loadImage("LeftArrow.gif");
        }
        return leftArrowIcon;
    }

    public static Icon getRightArrowIcon() {
        if (rightArrowIcon == null) {
            rightArrowIcon = ImageHelper.loadImage("RightArrow.gif");
        }
        return rightArrowIcon;
    }

    public static Icon getSplitterUpArrowIcon() {
        if (splitterUpArrowIcon == null) {
            splitterUpArrowIcon = ImageHelper.loadImage("SplitterUpArrow.gif");
        }
        return splitterUpArrowIcon;
    }

    public static Icon getSplitterDownArrowIcon() {
        if (splitterDownArrowIcon == null) {
            splitterDownArrowIcon = ImageHelper.loadImage("SplitterDownArrow.gif");
        }
        return splitterDownArrowIcon;
    }

    public static Icon getSplitterLeftArrowIcon() {
        if (splitterLeftArrowIcon == null) {
            splitterLeftArrowIcon = ImageHelper.loadImage("SplitterLeftArrow.gif");
        }
        return splitterLeftArrowIcon;
    }

    public static Icon getSplitterRightArrowIcon() {
        if (splitterRightArrowIcon == null) {
            splitterRightArrowIcon = ImageHelper.loadImage("SplitterRightArrow.gif");
        }
        return splitterRightArrowIcon;
    }

    public static Icon getSplitterHorBumpIcon() {
        if (splitterHorBumpIcon == null) {
            splitterHorBumpIcon = ImageHelper.loadImage("SplitterHorBumps.gif");
        }
        return splitterHorBumpIcon;
    }

    public static Icon getSplitterVerBumpIcon() {
        if (splitterVerBumpIcon == null) {
            splitterVerBumpIcon = ImageHelper.loadImage("SplitterVerBumps.gif");
        }
        return splitterVerBumpIcon;
    }

    public static Icon getComboBoxIcon() {
        return BaseIcons.getDownArrowIcon();
    }

    public static Icon getThumbHorIcon() {
        if (thumbHorIcon == null) {
            thumbHorIcon = ImageHelper.loadImage("thumb_hor.gif");
        }
        return thumbHorIcon;
    }

    public static Icon getThumbVerIcon() {
        if (thumbVerIcon == null) {
            thumbVerIcon = ImageHelper.loadImage("thumb_ver.gif");
        }
        return thumbVerIcon;
    }

    public static Icon getThumbHorIconRollover() {
        if (thumbHorIconRollover == null) {
            thumbHorIconRollover = ImageHelper.loadImage("thumb_hor_rollover.gif");
        }
        return thumbHorIconRollover;
    }

    public static Icon getThumbVerIconRollover() {
        if (thumbVerIconRollover == null) {
            thumbVerIconRollover = ImageHelper.loadImage("thumb_ver_rollover.gif");
        }
        return thumbVerIconRollover;
    }

    public static class CloseSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color rolloverColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public CloseSymbol(Color color, Color color2, Color color3) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
        }

        public CloseSymbol(Color color, Color color2, Color color3, Insets insets) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.insets = insets;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.translate(this.insets.left, this.insets.top);
            int n4 = component.getWidth() - this.insets.left - this.insets.right;
            int n5 = component.getHeight() - this.insets.top - this.insets.bottom;
            Color color = this.foregroundColor;
            if (component instanceof AbstractButton && ((AbstractButton)component).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            int n6 = n4 / 12 + 1;
            int n7 = n3 = n4 / 5 + 2;
            Stroke stroke = graphics2D.getStroke();
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(new BasicStroke(n6, 1, 2));
            if (this.shadowColor != null) {
                graphics2D.setColor(this.shadowColor);
                graphics2D.drawLine(n3 + 1, n7, n4 - n3 + 1, n5 - n7);
                graphics2D.drawLine(n4 - n3 + 1, n7, n3 + 1, n5 - n7);
            }
            graphics2D.setColor(color);
            graphics2D.drawLine(n3, n7, n4 - n3, n5 - n7);
            graphics2D.drawLine(n4 - n3, n7, n3, n5 - n7);
            graphics2D.setStroke(stroke);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            graphics.translate(-this.insets.left, -this.insets.top);
        }
    }

    public static class MinSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color rolloverColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public MinSymbol(Color color, Color color2, Color color3) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
        }

        public MinSymbol(Color color, Color color2, Color color3, Insets insets) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.insets = insets;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.translate(this.insets.left, this.insets.top);
            int n3 = component.getWidth() - this.insets.left - this.insets.right;
            int n4 = component.getHeight() - this.insets.top - this.insets.bottom;
            int n5 = Math.min(n3, n4);
            int n6 = 10;
            int n7 = 1;
            n6 = n5 < 14 ? 7 : (n5 < 18 ? 9 : (n5 < 22 ? 11 : (n5 < 26 ? 13 : 15)));
            n3 = Math.min(n3, n4);
            n4 = Math.min(n3, n4);
            n3 -= n6;
            n4 -= n6;
            n += n6 / 4 + 1;
            n2 += n6 / 4 + 1;
            Color color = this.foregroundColor;
            if (component instanceof AbstractButton && ((AbstractButton)component).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(n7, 0, 0));
            Shape shape = graphics.getClip();
            Area area = new Area(shape);
            int n8 = n + n6 / 2 - 2;
            int n9 = n + Math.max(n6 / 2 - 2, 2 * n7 + 1);
            area.subtract(new Area(new Rectangle2D.Double(n8, n9, n3, n4)));
            graphics2D.setClip(area);
            if (this.shadowColor != null) {
                graphics2D.setColor(this.shadowColor);
                graphics2D.drawRect(n + 1, n2 + 1, n3, n4);
                graphics2D.drawLine(n + 1, n2 + n7 + 1, n + n3 + 1, n2 + n7 + 1);
            }
            graphics2D.setColor(color);
            graphics2D.drawRect(n, n2, n3, n4);
            graphics2D.drawLine(n, n2 + n7, n + n3, n2 + n7);
            graphics2D.setClip(shape);
            n += n6 / 2 - 2;
            n2 += Math.max(n6 / 2 - 2, 2 * n7 + 1);
            if (this.shadowColor != null) {
                graphics2D.setColor(this.shadowColor);
                graphics2D.drawRect(n + 1, n2 + 1, n3, n4);
                graphics2D.drawLine(n + 1, n2 + n7 + 1, n + n3 + 1, n2 + n7 + 1);
            }
            graphics2D.setColor(color);
            graphics2D.drawRect(n, n2, n3, n4);
            graphics2D.drawLine(n, n2 + n7, n + n3, n2 + n7);
            graphics2D.setStroke(stroke);
            graphics.translate(-this.insets.left, -this.insets.top);
        }
    }

    public static class MaxSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color rolloverColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public MaxSymbol(Color color, Color color2, Color color3) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
        }

        public MaxSymbol(Color color, Color color2, Color color3, Insets insets) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.insets = insets;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.translate(this.insets.left, this.insets.top);
            int n4 = component.getWidth() - this.insets.left - this.insets.right;
            int n5 = component.getHeight() - this.insets.top - this.insets.bottom;
            Color color = this.foregroundColor;
            if (component instanceof AbstractButton && ((AbstractButton)component).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            int n6 = n4 / 12;
            int n7 = n3 = n4 / 5 + 2;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(n6, 0, 0));
            if (this.shadowColor != null) {
                graphics2D.setColor(this.shadowColor);
                graphics2D.drawRect(n3 + 1, n7 + 1, n4 - 2 * n3, n5 - 2 * n7);
                graphics2D.drawLine(n3 + 1, n7 + n6 + 1, n4 - n3, n7 + n6 + 1);
            }
            graphics2D.setColor(color);
            graphics2D.drawRect(n3, n7, n4 - 2 * n3, n5 - 2 * n7);
            graphics2D.drawLine(n3, n7 + n6, n4 - n3 - 1, n7 + n6);
            graphics2D.setStroke(stroke);
            graphics.translate(-this.insets.left, -this.insets.top);
        }
    }

    public static class IconSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color rolloverColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public IconSymbol(Color color, Color color2, Color color3) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
        }

        public IconSymbol(Color color, Color color2, Color color3, Insets insets) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.insets = insets;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.translate(this.insets.left, this.insets.top);
            int n4 = component.getWidth() - this.insets.left - this.insets.right;
            int n5 = component.getHeight() - this.insets.top - this.insets.bottom;
            Color color = this.foregroundColor;
            if (component instanceof AbstractButton && ((AbstractButton)component).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            int n6 = n4 / 12 + 1;
            int n7 = n3 = n4 / 5 + 2;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(n6, 0, 0));
            if (this.shadowColor != null) {
                graphics2D.setColor(this.shadowColor);
                graphics2D.drawLine(n3 + 1, n5 - n7, n4 - n3 + 1, n5 - n7);
            }
            graphics2D.setColor(color);
            graphics2D.drawLine(n3, n5 - n7 - 1, n4 - n3, n5 - n7 - 1);
            graphics2D.setStroke(stroke);
            graphics.translate(-this.insets.left, -this.insets.top);
        }
    }

    private static class RadioButtonIcon
    implements Icon {
        private static final int WIDTH = 12;
        private static final int HEIGHT = 12;

        private RadioButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Object object;
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 3;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isRollover() && abstractButton.isEnabled()) {
                object = graphics.getClip();
                Area area = new Area((Shape)object);
                Area area2 = new Area(new Ellipse2D.Double(n, n2, 13.0, 13.0));
                area2.intersect(area);
                graphics2D.setClip(area2);
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getRolloverColors(), n, n2, 12, 12);
                graphics2D.setClip((Shape)object);
            } else {
                graphics2D.setColor(Color.white);
                graphics2D.fillOval(n, n2, 13, 13);
            }
            if (abstractButton.isEnabled()) {
                graphics.setColor(AbstractLookAndFeel.getFrameColor());
            } else {
                graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 40.0));
            }
            object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawOval(n, n2, 12, 12);
            if (buttonModel.isSelected()) {
                graphics2D.setColor(Color.black);
                graphics2D.fillOval(n + 3, n2 + 3, 7, 7);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 12;
        }
    }

    private static class CheckBoxIcon
    implements Icon {
        private static Icon checkIcon = ImageHelper.loadImage("CheckSymbol.gif");
        private ImageIcon checkPressedIcon = ImageHelper.loadImage("CheckPressedSymbol.gif");
        private static final int WIDTH = 13;
        private static final int HEIGHT = 13;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 3;
            }
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isRolloverEnabled() && buttonModel.isRollover() && !buttonModel.isArmed() && abstractButton.isEnabled()) {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getRolloverColors(), n, n2, 13, 13);
            } else {
                if (buttonModel.isArmed() && buttonModel.isPressed()) {
                    graphics.setColor(AbstractLookAndFeel.getBackgroundColor());
                } else {
                    graphics.setColor(Color.white);
                }
                graphics.fillRect(n, n2, 13, 13);
            }
            if (abstractButton.isEnabled()) {
                graphics.setColor(AbstractLookAndFeel.getFrameColor());
            } else {
                graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 40.0));
            }
            graphics.drawRect(n, n2, 13, 13);
            int n3 = n + (13 - checkIcon.getIconWidth()) / 2 + 1;
            int n4 = n2 + (13 - checkIcon.getIconHeight()) / 2 + 1;
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                this.checkPressedIcon.paintIcon(component, graphics, n3, n4);
            } else if (buttonModel.isSelected()) {
                checkIcon.paintIcon(component, graphics, n3, n4);
            }
        }

        public int getIconWidth() {
            return 17;
        }

        public int getIconHeight() {
            return 13;
        }
    }
}

