/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aero;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import com.jtattoo.plaf.aero.AeroLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JRootPane;
import javax.swing.plaf.ColorUIResource;

public class AeroTitlePane
extends BaseTitlePane {
    protected static final Icon iconIcon = new BaseIcons.IconSymbol(Color.black, Color.white, null, new Insets(2, 2, 2, 2));
    protected static final Icon minIcon = new BaseIcons.MinSymbol(Color.black, Color.white, null, new Insets(2, 2, 2, 2));
    protected static final Icon maxIcon = new BaseIcons.MaxSymbol(Color.black, Color.white, null, new Insets(2, 2, 2, 2));
    protected static final Icon closeIcon = new BaseIcons.CloseSymbol(Color.black, Color.white, null, new Insets(2, 2, 2, 2));

    public AeroTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    protected int getHorSpacing() {
        return 0;
    }

    protected int getVerSpacing() {
        return 0;
    }

    public void createButtons() {
        this.closeButton = new TitleButton(this.closeAction, "Close", closeIcon);
        this.iconifyButton = new TitleButton(this.iconifyAction, "Iconify", this.iconifyIcon);
        this.maxButton = new TitleButton(this.restoreAction, "Maximize", this.maximizeIcon);
    }

    protected void setButtonIcons() {
        this.iconifyButton.setIcon(iconIcon);
        if ((this.state & 6) == 0) {
            this.maxButton.setIcon(maxIcon);
        } else {
            this.maxButton.setIcon(minIcon);
        }
        this.closeButton.setIcon(closeIcon);
    }

    protected void updateMaxButton(Action action, Icon icon) {
        this.maxButton.setAction(action);
        if ((this.state & 6) == 0) {
            this.maxButton.setIcon(minIcon);
        } else {
            this.maxButton.setIcon(maxIcon);
        }
    }

    protected void setActive(boolean bl) {
        super.setActive(bl);
        this.setButtonIcons();
    }

    public void paintBackground(Graphics graphics) {
        Color color = null;
        if (this.isActive()) {
            JTattooUtilities.fillHorGradient(graphics, AeroLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, this.getWidth(), this.getHeight());
            color = ColorHelper.brighter(AeroLookAndFeel.getWindowTitleColorDark(), 50.0);
        } else {
            JTattooUtilities.fillHorGradient(graphics, AeroLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, this.getWidth(), this.getHeight());
            color = ColorHelper.darker(AeroLookAndFeel.getWindowInactiveTitleColorDark(), 10.0);
        }
        graphics.setColor(color);
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintBorder(Graphics graphics) {
    }

    public void paintText(Graphics graphics, int n, int n2, String string) {
        if (this.isActive()) {
            ColorUIResource colorUIResource = AbstractLookAndFeel.getWindowTitleForegroundColor();
            if (ColorHelper.getGrayValue(colorUIResource) > 164) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.white);
            }
            JTattooUtilities.drawString(this.rootPane, graphics, string, n + 1, n2 + 1);
            graphics.setColor(colorUIResource);
            JTattooUtilities.drawString(this.rootPane, graphics, string, n, n2);
        } else {
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.rootPane, graphics, string, n, n2);
        }
    }

    private class TitleButton
    extends NoFocusButton {
        public TitleButton(Action action, String string, Icon icon) {
            this.setAction(action);
            this.setText(null);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.putClientProperty("paintActive", Boolean.TRUE);
            this.getAccessibleContext().setAccessibleName(string);
            this.setIcon(icon);
        }

        public void paint(Graphics graphics) {
            boolean bl = this.getModel().isPressed();
            boolean bl2 = this.getModel().isArmed();
            boolean bl3 = this.getModel().isRollover();
            int n = this.getWidth();
            int n2 = this.getHeight();
            Color[] colorArray = AeroLookAndFeel.getTheme().getButtonColors();
            if (bl3 && !bl2) {
                colorArray = AeroLookAndFeel.getTheme().getRolloverColors();
            }
            if (bl) {
                colorArray = AeroLookAndFeel.getTheme().getPressedColors();
            }
            JTattooUtilities.fillHorGradient(graphics, colorArray, 0, 0, n, n2);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(0, 0, 0, n2);
            graphics.drawLine(0, n2 - 1, n, n2 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(1, 0, 1, n2);
            this.getIcon().paintIcon(this, graphics, 1, 0);
        }
    }
}

