/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class HiFiButtonUI
extends BaseButtonUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new HiFiButtonUI();
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = buttonModel.getMnemonic();
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            n = abstractButton.getDisplayedMnemonicIndex();
        }
        int n2 = 0;
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            n2 = 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
        graphics2D.setComposite(alphaComposite);
        Color color = abstractButton.getForeground();
        if (!JTattooUtilities.isFrameActive(abstractButton)) {
            color = Color.white;
        }
        if (buttonModel.isPressed() && buttonModel.isArmed()) {
            color = AbstractLookAndFeel.getTheme().getSelectionForegroundColor();
        }
        if (!buttonModel.isEnabled()) {
            color = AbstractLookAndFeel.getTheme().getDisabledForegroundColor();
        }
        if (ColorHelper.getGrayValue(color) > 128) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(Color.white);
        }
        JTattooUtilities.drawStringUnderlineCharAt(abstractButton, graphics, abstractButton.getText(), n, rectangle.x + n2 + 1, rectangle.y + n2 + fontMetrics.getAscent() + 1);
        graphics2D.setComposite(composite);
        graphics2D.setColor(color);
        JTattooUtilities.drawStringUnderlineCharAt(abstractButton, graphics, abstractButton.getText(), n, rectangle.x + n2, rectangle.y + n2 + fontMetrics.getAscent());
    }
}

