/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.luna;

import com.jtattoo.plaf.BaseTheme;
import com.jtattoo.plaf.ColorHelper;
import java.awt.Color;
import javax.swing.plaf.ColorUIResource;

public class LunaDefaultTheme
extends BaseTheme {
    public LunaDefaultTheme() {
        LunaDefaultTheme.setUp();
        this.loadProperties();
        LunaDefaultTheme.setupColorArrs();
    }

    public static void setUp() {
        BaseTheme.setUp();
        backgroundColor = new ColorUIResource(240, 238, 225);
        selectionForegroundColor = black;
        selectionBackgroundColor = new ColorUIResource(200, 210, 240);
        frameColor = new ColorUIResource(0, 60, 116);
        focusCellColor = new ColorUIResource(0, 60, 116);
        buttonBackgroundColor = new ColorUIResource(236, 233, 216);
        buttonColorLight = white;
        buttonColorDark = new ColorUIResource(214, 208, 197);
        controlForegroundColor = black;
        controlBackgroundColor = new ColorUIResource(236, 233, 216);
        controlColorLight = white;
        controlColorDark = new ColorUIResource(214, 208, 197);
        windowTitleForegroundColor = white;
        windowTitleColorLight = windowTitleBackgroundColor = new ColorUIResource(139, 185, 254);
        windowTitleColorDark = new ColorUIResource(2, 80, 196);
        windowBorderColor = new ColorUIResource(2, 80, 196);
        windowInactiveTitleForegroundColor = white;
        windowInactiveTitleColorLight = windowInactiveTitleBackgroundColor = new ColorUIResource(141, 186, 253);
        windowInactiveTitleColorDark = new ColorUIResource(39, 106, 204);
        windowInactiveBorderColor = new ColorUIResource(39, 106, 204);
        menuBackgroundColor = backgroundColor;
        menuSelectionForegroundColor = white;
        menuSelectionBackgroundColor = new ColorUIResource(49, 106, 197);
        menuColorLight = new ColorUIResource(248, 247, 241);
        menuColorDark = backgroundColor;
        toolbarBackgroundColor = backgroundColor;
        toolbarColorLight = menuColorLight;
        toolbarColorDark = backgroundColor;
        desktopColor = backgroundColor;
    }

    public static void setupColorArrs() {
        int n;
        BaseTheme.setupColorArrs();
        DEFAULT_COLORS = ColorHelper.createColorArr(controlColorLight, controlColorDark, 20);
        HIDEFAULT_COLORS = ColorHelper.createColorArr(ColorHelper.brighter(controlColorLight, 90.0), ColorHelper.brighter(controlColorDark, 30.0), 20);
        ACTIVE_COLORS = DEFAULT_COLORS;
        INACTIVE_COLORS = ColorHelper.createColorArr(new Color(248, 247, 241), backgroundColor, 20);
        ROLLOVER_COLORS = ColorHelper.createColorArr(ColorHelper.brighter(controlColorLight, 30.0), ColorHelper.brighter(controlColorDark, 20.0), 30);
        SELECTED_COLORS = DEFAULT_COLORS;
        PRESSED_COLORS = ColorHelper.createColorArr(controlColorDark, controlColorLight, 20);
        DISABLED_COLORS = ColorHelper.createColorArr(Color.white, Color.lightGray, 20);
        ColorUIResource colorUIResource = windowTitleColorLight;
        Color color = ColorHelper.darker(windowTitleColorLight, 10.0);
        Color color2 = ColorHelper.brighter(windowTitleColorDark, 15.0);
        ColorUIResource colorUIResource2 = windowTitleColorDark;
        WINDOW_TITLE_COLORS = new Color[20];
        Color[] colorArray = ColorHelper.createColorArr(colorUIResource, color, 8);
        for (int i = 0; i < 8; ++i) {
            LunaDefaultTheme.WINDOW_TITLE_COLORS[i] = colorArray[i];
        }
        Color[] colorArray2 = ColorHelper.createColorArr(color2, colorUIResource2, 12);
        for (n = 0; n < 12; ++n) {
            LunaDefaultTheme.WINDOW_TITLE_COLORS[n + 8] = colorArray2[n];
        }
        WINDOW_INACTIVE_TITLE_COLORS = new Color[WINDOW_TITLE_COLORS.length];
        for (n = 0; n < WINDOW_INACTIVE_TITLE_COLORS.length; ++n) {
            LunaDefaultTheme.WINDOW_INACTIVE_TITLE_COLORS[n] = ColorHelper.brighter(WINDOW_TITLE_COLORS[n], 20.0);
        }
        MENUBAR_COLORS = ColorHelper.createColorArr(menuColorLight, menuColorDark, 20);
        TOOLBAR_COLORS = ColorHelper.createColorArr(toolbarColorLight, toolbarColorDark, 20);
        BUTTON_COLORS = new Color[]{new Color(255, 255, 255), new Color(254, 254, 254), new Color(252, 252, 251), new Color(251, 251, 249), new Color(250, 250, 248), new Color(249, 249, 246), new Color(248, 248, 244), new Color(247, 247, 243), new Color(246, 246, 242), new Color(245, 245, 240), new Color(244, 244, 239), new Color(243, 243, 238), new Color(242, 242, 236), new Color(241, 241, 235), new Color(240, 240, 234), new Color(236, 235, 230), new Color(226, 223, 214), new Color(214, 208, 197)};
        TAB_COLORS = ColorHelper.createColorArr(Color.white, new Color(236, 235, 230), 20);
        COL_HEADER_COLORS = TAB_COLORS;
        TRACK_COLORS = ColorHelper.createColorArr(new Color(243, 241, 236), new Color(254, 254, 251), 20);
        THUMB_COLORS = ColorHelper.createColorArr(new Color(218, 230, 254), new Color(180, 197, 240), 20);
        SLIDER_COLORS = THUMB_COLORS;
        PROGRESSBAR_COLORS = THUMB_COLORS;
    }

    public String getName() {
        return LunaDefaultTheme.getInternalName();
    }

    public static String getInternalName() {
        return "LunaTheme";
    }
}

