/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.jvnet.substance.ComponentState;
import org.jvnet.substance.PulseTracker;
import org.jvnet.substance.SubstanceButtonUI;
import org.jvnet.substance.SubstanceComboBoxButton;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceScrollButton;
import org.jvnet.substance.SubstanceSpinnerButton;
import org.jvnet.substance.Utilities;
import org.jvnet.substance.color.ColorSchemeEnum;
import org.jvnet.substance.comp.JButtonStrip;

public class SubstanceBackgroundDelegate {
    private static Map<String, BufferedImage> roundBackgrounds = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> regularBackgrounds = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> scrollBarBackgrounds = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> stripBackgrounds = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> ribbonBackgrounds = new HashMap<String, BufferedImage>();
    private static SubstanceFillBackgroundDelegate fillDelegate = new SubstanceFillBackgroundDelegate();
    private static WeakHashMap<AbstractButton, SubstanceButtonUI.ButtonTitleKind> titleButtons = new WeakHashMap();

    static synchronized void reset() {
        regularBackgrounds.clear();
        stripBackgrounds.clear();
        scrollBarBackgrounds.clear();
        roundBackgrounds.clear();
    }

    public static synchronized void trackTitleButton(AbstractButton button, SubstanceButtonUI.ButtonTitleKind kind) {
        titleButtons.put(button, kind);
    }

    public static synchronized SubstanceButtonUI.ButtonTitleKind getKind(AbstractButton button) {
        SubstanceButtonUI.ButtonTitleKind result = titleButtons.get(button);
        if (result == null) {
            result = SubstanceButtonUI.ButtonTitleKind.NONE;
        }
        return result;
    }

    private static synchronized BufferedImage getBackground(AbstractButton button, int width, int height, boolean isRoundCorners) {
        Map<String, BufferedImage> backgrounds;
        JButton jb;
        ComponentState state = ComponentState.getState(button.getModel(), button);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        int cyclePos = state.getCycleCount();
        if (button instanceof JButton && (jb = (JButton)button).isDefaultButton() && state != ComponentState.PRESSED_SELECTED && state != ComponentState.PRESSED_UNSELECTED && (cyclePos = (int)(PulseTracker.getCycles(jb) % 20L)) > 10) {
            cyclePos = 19 - cyclePos;
        }
        ColorSchemeEnum colorSchemeEnum = null;
        switch (kind) {
            case CURRENT: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
                break;
            }
            case REGULAR: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getMetallic();
                break;
            }
            case DISABLED: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getGray();
            }
        }
        String key = width + ":" + height + ":" + kind.name() + ":" + cyclePos + ":" + colorSchemeEnum.name() + ":" + button.getClass().getName();
        Map<String, BufferedImage> map = backgrounds = isRoundCorners ? roundBackgrounds : regularBackgrounds;
        if (!backgrounds.containsKey(key)) {
            int radius = 2;
            if (isRoundCorners) {
                radius = width > height ? height / 2 : width / 2;
            }
            SubstanceImageCreator.Side side = null;
            if (button instanceof SubstanceComboBoxButton) {
                side = SubstanceImageCreator.Side.LEFT;
            }
            BufferedImage newBackground = SubstanceImageCreator.getRoundedBackground(width, height, radius, colorSchemeEnum, cyclePos, side);
            backgrounds.put(key, newBackground);
        }
        return backgrounds.get(key);
    }

    private static synchronized BufferedImage getStripBackground(AbstractButton button, JButtonStrip.StripOrientation stripOrientation, int width, int height, boolean isFirst, boolean isLast, int totalStripDimension, int relativeOffset) {
        ComponentState state = ComponentState.getState(button.getModel(), button);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        int cyclePos = state.getCycleCount();
        ColorSchemeEnum colorSchemeEnum = null;
        switch (kind) {
            case CURRENT: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
                break;
            }
            case REGULAR: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getMetallic();
                break;
            }
            case DISABLED: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getGray();
            }
        }
        String key = stripOrientation.name() + ":" + width + ":" + height + ":" + kind.name() + ":" + cyclePos + ":" + isFirst + ":" + isLast + ":" + totalStripDimension + ":" + button.getClass().getName();
        if (!stripBackgrounds.containsKey(key)) {
            if (stripOrientation == JButtonStrip.StripOrientation.HORIZONTAL) {
                if (isFirst) {
                    BufferedImage bigImage = SubstanceImageCreator.getRoundedBackground(totalStripDimension, height, 3, colorSchemeEnum, cyclePos, SubstanceImageCreator.Side.RIGHT);
                    BufferedImage finalImage = SubstanceImageCreator.getBlankImage(width, height);
                    Graphics g = finalImage.getGraphics();
                    g.drawImage(bigImage, 0, 0, width, height, 0, 0, width, height, null);
                    stripBackgrounds.put(key, finalImage);
                } else if (isLast) {
                    BufferedImage bigImage = SubstanceImageCreator.getRoundedBackground(totalStripDimension, height, 3, colorSchemeEnum, cyclePos, SubstanceImageCreator.Side.LEFT);
                    BufferedImage finalImage = SubstanceImageCreator.getBlankImage(width, height);
                    Graphics g = finalImage.getGraphics();
                    g.drawImage(bigImage, 0, 0, width, height, relativeOffset, 0, relativeOffset + width, height, null);
                    stripBackgrounds.put(key, finalImage);
                } else {
                    BufferedImage bigImage = SubstanceImageCreator.getRoundedBackground(totalStripDimension, height, 3, colorSchemeEnum, cyclePos, null);
                    BufferedImage finalImage = SubstanceImageCreator.getBlankImage(width, height);
                    Graphics g = finalImage.getGraphics();
                    g.drawImage(bigImage, 0, 0, width, height, relativeOffset, 0, relativeOffset + width, height, null);
                    stripBackgrounds.put(key, finalImage);
                }
            } else if (isFirst) {
                BufferedImage bigImage = SubstanceImageCreator.getRoundedBackground(totalStripDimension, width, 3, colorSchemeEnum, cyclePos, SubstanceImageCreator.Side.LEFT);
                bigImage = SubstanceImageCreator.getRotated(bigImage, 3);
                BufferedImage finalImage = SubstanceImageCreator.getBlankImage(width, height);
                Graphics g = finalImage.getGraphics();
                g.drawImage(bigImage, 0, 0, width, height, 0, 0, width, height, null);
                stripBackgrounds.put(key, finalImage);
            } else if (isLast) {
                BufferedImage bigImage = SubstanceImageCreator.getRoundedBackground(totalStripDimension, width, 3, colorSchemeEnum, cyclePos, SubstanceImageCreator.Side.RIGHT);
                bigImage = SubstanceImageCreator.getRotated(bigImage, 3);
                BufferedImage finalImage = SubstanceImageCreator.getBlankImage(width, height);
                Graphics g = finalImage.getGraphics();
                g.drawImage(bigImage, 0, 0, width, height, 0, relativeOffset, width, relativeOffset + height, null);
                stripBackgrounds.put(key, finalImage);
            } else {
                BufferedImage bigImage = SubstanceImageCreator.getRoundedBackground(totalStripDimension, width, 3, colorSchemeEnum, cyclePos, null);
                bigImage = SubstanceImageCreator.getRotated(bigImage, 3);
                BufferedImage finalImage = SubstanceImageCreator.getBlankImage(width, height);
                Graphics g = finalImage.getGraphics();
                g.drawImage(bigImage, 0, 0, width, height, 0, relativeOffset, width, relativeOffset + height, null);
                stripBackgrounds.put(key, finalImage);
            }
        }
        return stripBackgrounds.get(key);
    }

    private static synchronized BufferedImage getRibbonBackground(AbstractButton button, int width, int height) {
        boolean hasActiveBackground;
        ComponentState state = ComponentState.getState(button.getModel(), button);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        int cyclePos = state.getCycleCount();
        boolean bl = hasActiveBackground = kind == ComponentState.ColorSchemeKind.CURRENT;
        if (!hasActiveBackground) {
            return null;
        }
        String key = width + ":" + height + ":" + kind.name() + ":" + cyclePos + ":" + button.getClass().getName();
        if (!ribbonBackgrounds.containsKey(key)) {
            BufferedImage newBackground = SubstanceImageCreator.getRoundedBackground(width, height, height / 3, SubstanceLookAndFeel.getColorScheme(), SubstanceLookAndFeel.getColorScheme(), cyclePos, SubstanceImageCreator.Side.BOTTOM, true, true);
            ribbonBackgrounds.put(key, newBackground);
        }
        return ribbonBackgrounds.get(key);
    }

    private static synchronized BufferedImage getPairwiseBackground(AbstractButton button, int width, int height, SubstanceImageCreator.Side side) {
        ComponentState state = ComponentState.getState(button.getModel(), button);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        int cyclePos = state.getCycleCount();
        ColorSchemeEnum colorSchemeEnum = null;
        switch (kind) {
            case CURRENT: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
                break;
            }
            case REGULAR: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getMetallic();
                break;
            }
            case DISABLED: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getGray();
            }
        }
        String key = width + ":" + height + ":" + side.toString() + ":" + cyclePos + ":" + colorSchemeEnum.name() + ":" + button.getClass().getName();
        if (!scrollBarBackgrounds.containsKey(key)) {
            BufferedImage newBackground = null;
            int radius = 0;
            switch (side) {
                case TOP: 
                case BOTTOM: {
                    newBackground = SubstanceImageCreator.getFlipRoundedButton(width, height, radius, colorSchemeEnum, cyclePos, side, true);
                    break;
                }
                case RIGHT: 
                case LEFT: {
                    newBackground = SubstanceImageCreator.getRoundedBackground(width, height, radius, colorSchemeEnum, cyclePos, side, true);
                }
            }
            scrollBarBackgrounds.put(key, newBackground);
        }
        return scrollBarBackgrounds.get(key);
    }

    public void updateBackground(Graphics g, AbstractButton button, long cycleCount) {
        button.setOpaque(false);
        Graphics2D graphics = (Graphics2D)g;
        int width = button.getWidth();
        int height = button.getHeight();
        boolean isRoundCorners = SubstanceBackgroundDelegate.isRoundButton(button);
        if (Utilities.isScrollButton(button)) {
            SubstanceScrollButton ssbButton = (SubstanceScrollButton)button;
            graphics.drawImage((Image)SubstanceBackgroundDelegate.getPairwiseBackground(button, width, height, ssbButton.getSide()), 0, 0, null);
            return;
        }
        if (Utilities.isSpinnerButton(button)) {
            SubstanceSpinnerButton ssbButton = (SubstanceSpinnerButton)button;
            graphics.drawImage((Image)SubstanceBackgroundDelegate.getPairwiseBackground(button, width, height, ssbButton.getSide()), 0, 0, null);
            return;
        }
        if (Utilities.isRibbonButton(button)) {
            BufferedImage ribbonBackground = SubstanceBackgroundDelegate.getRibbonBackground(button, width, height);
            if (ribbonBackground == null) {
                fillDelegate.update(g, button);
            } else {
                graphics.drawImage((Image)ribbonBackground, 0, 0, null);
            }
            return;
        }
        SubstanceButtonUI.ButtonTitleKind buttonKind = SubstanceBackgroundDelegate.getKind(button);
        if (buttonKind == SubstanceButtonUI.ButtonTitleKind.CLOSE_DI || buttonKind == SubstanceButtonUI.ButtonTitleKind.REGULAR_DI) {
            graphics.setComposite(AlphaComposite.getInstance(3, 0.8f));
        }
        graphics.drawImage((Image)SubstanceBackgroundDelegate.getBackground(button, width, height, isRoundCorners), 0, 0, null);
    }

    public void updateBackgroundInStrip(Graphics g, AbstractButton button, JButtonStrip.StripOrientation stripOrientation, boolean isFirst, boolean isLast, int totalStripDimension, int relativeOffset) {
        button.setOpaque(false);
        Graphics2D graphics = (Graphics2D)g;
        int width = button.getWidth();
        int height = button.getHeight();
        graphics.drawImage((Image)SubstanceBackgroundDelegate.getStripBackground(button, stripOrientation, width, height, isFirst, isLast, totalStripDimension, relativeOffset), 0, 0, null);
    }

    public static boolean isRoundButton(AbstractButton button) {
        return !Utilities.isComboBoxButton(button) && !Utilities.isScrollButton(button) && Utilities.hasText(button);
    }

    public static boolean contains(AbstractButton button, int x, int y) {
        int width = button.getWidth();
        int height = button.getHeight();
        if (x < 0 || y < 0 || x > width || y > height) {
            return false;
        }
        boolean isRoundCorners = SubstanceBackgroundDelegate.isRoundButton(button);
        int radius = 2;
        if (Utilities.isScrollButton(button) || Utilities.isSpinnerButton(button)) {
            radius = 0;
        }
        if (isRoundCorners) {
            radius = width > height ? height / 2 : width / 2;
        }
        if (x >= width / 2) {
            x = width - x;
        }
        if (y >= height / 2) {
            y = height - y;
        }
        if (x < radius && y < radius) {
            int dx = radius - x;
            int dy = radius - y;
            int diff = dx * dx + dy * dy - radius * radius;
            return diff <= 0;
        }
        return true;
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceBackgroundDelegate: \n");
        sb.append("\t" + regularBackgrounds.size() + " regular, " + ribbonBackgrounds.size() + " ribbon, " + roundBackgrounds.size() + " round, " + scrollBarBackgrounds.size() + " scroll bar, " + stripBackgrounds.size() + " toggle");
        return sb.toString();
    }
}

