/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jvnet.substance.ComponentState;
import org.jvnet.substance.RolloverControlListener;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceSliderUI;
import org.jvnet.substance.Trackable;
import org.jvnet.substance.color.ColorSchemeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceIconFactory {
    private static Map<Integer, Icon> checkBoxMenuItemIcons = new HashMap<Integer, Icon>();
    private static Map<Integer, Icon> radioButtonMenuItemIcons = new HashMap<Integer, Icon>();
    private static Map<String, Icon> sliderHorizontalIcons = new HashMap<String, Icon>();
    private static Map<String, Icon> sliderVerticalIcons = new HashMap<String, Icon>();
    private static final Map<IconKind, Map<ColorSchemeEnum, Icon>> icons = SubstanceIconFactory.createIcons();

    static void reset() {
        checkBoxMenuItemIcons.clear();
        radioButtonMenuItemIcons.clear();
        sliderHorizontalIcons.clear();
        sliderVerticalIcons.clear();
    }

    public static synchronized Icon getCheckBoxMenuItemIcon(int size) {
        if (checkBoxMenuItemIcons.get(size) == null) {
            CheckBoxMenuItemIcon icon = new CheckBoxMenuItemIcon(size);
            checkBoxMenuItemIcons.put(size, icon);
        }
        return checkBoxMenuItemIcons.get(size);
    }

    public static Icon getRadioButtonMenuItemIcon(int size) {
        if (radioButtonMenuItemIcons.get(size) == null) {
            RadioButtonMenuItemIcon icon = new RadioButtonMenuItemIcon(size);
            radioButtonMenuItemIcons.put(size, icon);
        }
        return radioButtonMenuItemIcons.get(size);
    }

    public static Icon getSliderHorizontalIcon(int size, boolean isMirrorred) {
        String key = size + ":" + isMirrorred;
        if (sliderHorizontalIcons.get(key) == null) {
            SliderHorizontalIcon icon = new SliderHorizontalIcon(size, isMirrorred);
            sliderHorizontalIcons.put(key, icon);
        }
        return sliderHorizontalIcons.get(key);
    }

    public static Icon getSliderVerticalIcon(int size, boolean isMirrorred) {
        String key = size + ":" + isMirrorred;
        if (sliderVerticalIcons.get(key) == null) {
            SliderVerticalIcon icon = new SliderVerticalIcon(size, isMirrorred);
            sliderVerticalIcons.put(key, icon);
        }
        return sliderVerticalIcons.get(key);
    }

    private static Map<IconKind, Map<ColorSchemeEnum, Icon>> createIcons() {
        HashMap<IconKind, Map<ColorSchemeEnum, Icon>> result = new HashMap<IconKind, Map<ColorSchemeEnum, Icon>>();
        result.put(IconKind.CLOSE, new HashMap());
        result.put(IconKind.MINIMIZE, new HashMap());
        result.put(IconKind.MAXIMIZE, new HashMap());
        result.put(IconKind.RESTORE, new HashMap());
        for (ColorSchemeEnum colorSchemeEnum : ColorSchemeEnum.values()) {
            ColorSchemeEnum toTake = colorSchemeEnum.isDark() ? colorSchemeEnum : colorSchemeEnum.getMetallic();
            ((Map)result.get((Object)IconKind.CLOSE)).put(colorSchemeEnum, SubstanceImageCreator.getCloseIcon(toTake));
            ((Map)result.get((Object)IconKind.MINIMIZE)).put(colorSchemeEnum, SubstanceImageCreator.getMinimizeIcon(toTake));
            ((Map)result.get((Object)IconKind.MAXIMIZE)).put(colorSchemeEnum, SubstanceImageCreator.getMaximizeIcon(toTake));
            ((Map)result.get((Object)IconKind.RESTORE)).put(colorSchemeEnum, SubstanceImageCreator.getRestoreIcon(toTake));
        }
        return result;
    }

    public static void updateIcons() {
        ColorSchemeEnum toTake = ColorSchemeEnum.USER_DEFINED.isDark() ? ColorSchemeEnum.USER_DEFINED : ColorSchemeEnum.USER_DEFINED.getMetallic();
        icons.get((Object)IconKind.CLOSE).put(ColorSchemeEnum.USER_DEFINED, SubstanceImageCreator.getCloseIcon(toTake));
        icons.get((Object)IconKind.MINIMIZE).put(ColorSchemeEnum.USER_DEFINED, SubstanceImageCreator.getMinimizeIcon(toTake));
        icons.get((Object)IconKind.MAXIMIZE).put(ColorSchemeEnum.USER_DEFINED, SubstanceImageCreator.getMaximizeIcon(toTake));
        icons.get((Object)IconKind.RESTORE).put(ColorSchemeEnum.USER_DEFINED, SubstanceImageCreator.getRestoreIcon(toTake));
    }

    public static Icon getTitlePaneIcon(IconKind iconKind, ColorSchemeEnum colorSchemeEnum) {
        return icons.get((Object)iconKind).get((Object)colorSchemeEnum);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IconKind {
        CLOSE,
        MINIMIZE,
        MAXIMIZE,
        RESTORE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SliderVerticalIcon
    implements Icon,
    UIResource {
        private Map<ColorSchemeEnum, Map<ComponentState, Icon>> icons;
        private int size;
        private boolean isMirrorred;
        private WeakHashMap<JSlider, ButtonModel> models = new WeakHashMap();

        public SliderVerticalIcon(int size, boolean isMirrorred) {
            this.icons = new HashMap<ColorSchemeEnum, Map<ComponentState, Icon>>();
            this.size = size;
            this.isMirrorred = isMirrorred;
        }

        private synchronized Map<ComponentState, Icon> getCurrentThemeIcons() {
            ColorSchemeEnum currColorScheme = SubstanceLookAndFeel.getColorScheme();
            Map<ComponentState, Icon> currSchemeIcons = this.icons.get((Object)currColorScheme);
            if (currSchemeIcons == null) {
                currSchemeIcons = new HashMap<ComponentState, Icon>();
                for (ComponentState state : ComponentState.values()) {
                    BufferedImage stateImage = SubstanceImageCreator.getRoundedTriangleBackground(this.size - 1, this.size, 2, state, currColorScheme);
                    stateImage = this.isMirrorred ? SubstanceImageCreator.getRotated(stateImage, 1) : SubstanceImageCreator.getRotated(stateImage, 3);
                    currSchemeIcons.put(state, new ImageIcon(stateImage));
                }
                this.icons.put(currColorScheme, currSchemeIcons);
            }
            return currSchemeIcons;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            SliderUI sliderUI = slider.getUI();
            ComponentState state = ComponentState.ACTIVE;
            if (sliderUI instanceof SubstanceSliderUI) {
                state = ComponentState.getState(((SubstanceSliderUI)sliderUI).getButtonModel(), null);
            } else {
                ButtonModel buttonModel = this.models.get(slider);
                if (buttonModel == null) {
                    buttonModel = new DefaultButtonModel();
                    RolloverControlListener listener = new RolloverControlListener(new TrackableSlider(slider), buttonModel);
                    slider.addMouseListener(listener);
                    slider.addMouseMotionListener(listener);
                    this.models.put(slider, buttonModel);
                }
                state = ComponentState.getState(buttonModel, null);
            }
            Icon iconToDraw = this.getCurrentThemeIcons().get((Object)state);
            iconToDraw.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.size - 1;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SliderHorizontalIcon
    implements Icon,
    UIResource {
        private Map<ColorSchemeEnum, Map<ComponentState, Icon>> icons;
        private int size;
        private boolean isMirrorred;
        private WeakHashMap<JSlider, ButtonModel> models = new WeakHashMap();

        public SliderHorizontalIcon(int size, boolean isMirrorred) {
            this.icons = new HashMap<ColorSchemeEnum, Map<ComponentState, Icon>>();
            this.size = size;
            this.isMirrorred = isMirrorred;
        }

        private synchronized Map<ComponentState, Icon> getCurrentThemeIcons() {
            ColorSchemeEnum currColorScheme = SubstanceLookAndFeel.getColorScheme();
            Map<ComponentState, Icon> currSchemeIcons = this.icons.get((Object)currColorScheme);
            if (currSchemeIcons == null) {
                currSchemeIcons = new HashMap<ComponentState, Icon>();
                for (ComponentState state : ComponentState.values()) {
                    BufferedImage stateImage = SubstanceImageCreator.getRoundedTriangleBackground(this.size, this.size - 1, 2, state, currColorScheme);
                    if (this.isMirrorred) {
                        stateImage = SubstanceImageCreator.getRotated(stateImage, 2);
                    }
                    currSchemeIcons.put(state, new ImageIcon(stateImage));
                }
                this.icons.put(currColorScheme, currSchemeIcons);
            }
            return currSchemeIcons;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            SliderUI sliderUI = slider.getUI();
            ComponentState state = ComponentState.ACTIVE;
            if (sliderUI instanceof SubstanceSliderUI) {
                state = ComponentState.getState(((SubstanceSliderUI)sliderUI).getButtonModel(), null);
            } else {
                ButtonModel buttonModel = this.models.get(slider);
                if (buttonModel == null) {
                    buttonModel = new DefaultButtonModel();
                    RolloverControlListener listener = new RolloverControlListener(new TrackableSlider(slider), buttonModel);
                    slider.addMouseListener(listener);
                    slider.addMouseMotionListener(listener);
                    this.models.put(slider, buttonModel);
                }
                state = ComponentState.getState(buttonModel, null);
            }
            Icon iconToDraw = this.getCurrentThemeIcons().get((Object)state);
            iconToDraw.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size - 1;
        }
    }

    private static class TrackableSlider
    implements Trackable {
        private JSlider slider;
        private Field thumbRectField;

        public TrackableSlider(JSlider slider) {
            this.slider = slider;
            SliderUI sliderUI = slider.getUI();
            if (sliderUI instanceof BasicSliderUI) {
                try {
                    this.thumbRectField = BasicSliderUI.class.getDeclaredField("thumbRect");
                    this.thumbRectField.setAccessible(true);
                }
                catch (Exception exc) {
                    this.thumbRectField = null;
                }
            }
        }

        public boolean isInside(MouseEvent me) {
            try {
                Rectangle thumbB = (Rectangle)this.thumbRectField.get(this.slider.getUI());
                if (thumbB == null) {
                    return false;
                }
                return thumbB.contains(me.getX(), me.getY());
            }
            catch (Exception exc) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource {
        private Map<ColorSchemeEnum, Map<ComponentState, Icon>> icons = new HashMap<ColorSchemeEnum, Map<ComponentState, Icon>>();
        private int size;

        public RadioButtonMenuItemIcon(int size) {
            this.size = size;
        }

        private synchronized Map<ComponentState, Icon> getCurrentThemeIcons() {
            ColorSchemeEnum currColorScheme = SubstanceLookAndFeel.getColorScheme();
            Map<ComponentState, Icon> currSchemeIcons = this.icons.get((Object)currColorScheme);
            if (currSchemeIcons == null) {
                currSchemeIcons = new HashMap<ComponentState, Icon>();
                for (ComponentState state : ComponentState.values()) {
                    currSchemeIcons.put(state, new ImageIcon(SubstanceImageCreator.getRadioButton(this.size, state, 2, currColorScheme)));
                }
                this.icons.put(currColorScheme, currSchemeIcons);
            }
            return currSchemeIcons;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            Icon iconToDraw = this.getCurrentThemeIcons().get((Object)ComponentState.getState(b.getModel(), b));
            g.translate(x, y);
            iconToDraw.paintIcon(c, g, 0, 0);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.size + 2;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource {
        private Map<ColorSchemeEnum, Map<ComponentState, Icon>> icons = new HashMap<ColorSchemeEnum, Map<ComponentState, Icon>>();
        private int size;

        public CheckBoxMenuItemIcon(int size) {
            this.size = size;
        }

        private synchronized Map<ComponentState, Icon> getCurrentThemeIcons() {
            ColorSchemeEnum currColorScheme = SubstanceLookAndFeel.getColorScheme();
            Map<ComponentState, Icon> currSchemeIcons = this.icons.get((Object)currColorScheme);
            if (currSchemeIcons == null) {
                currSchemeIcons = new HashMap<ComponentState, Icon>();
                for (ComponentState state : ComponentState.values()) {
                    currSchemeIcons.put(state, new ImageIcon(SubstanceImageCreator.getCheckBox(this.size + 2, state, currColorScheme)));
                }
                this.icons.put(currColorScheme, currSchemeIcons);
            }
            return currSchemeIcons;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            Icon iconToDraw = this.getCurrentThemeIcons().get((Object)ComponentState.getState(b.getModel(), b));
            g.translate(x, y);
            iconToDraw.paintIcon(c, g, 0, 0);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.size + 2;
        }

        @Override
        public int getIconHeight() {
            return this.size + 2;
        }
    }
}

