/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceScrollButton;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceTabbedPaneUI
extends MetalTabbedPaneUI {
    private static Map<String, BufferedImage> backgroundMap = new HashMap<String, BufferedImage>();

    static synchronized void reset() {
        backgroundMap.clear();
    }

    public static ComponentUI createUI(JComponent tabPane) {
        return new SubstanceTabbedPaneUI();
    }

    private static synchronized BufferedImage getTabBackground(int width, int height, int cyclePos, SubstanceImageCreator.Side side, ColorSchemeEnum colorSchemeEnum) {
        String key = width + ":" + height + ":" + cyclePos + ":" + side.toString() + ":" + colorSchemeEnum.toString();
        BufferedImage result = backgroundMap.get(key);
        if (result == null) {
            result = SubstanceImageCreator.getRoundedBackground(width, height, height / 3, colorSchemeEnum, colorSchemeEnum, cyclePos, side, true, true);
            backgroundMap.put(key, result);
        }
        return result;
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        BufferedImage backgroundImage = null;
        ColorSchemeEnum colorScheme = isSelected ? SubstanceLookAndFeel.getColorScheme() : SubstanceLookAndFeel.getColorScheme().getMetallic();
        int cyclePos = 0;
        switch (tabPlacement) {
            case 2: {
                if (!isSelected) {
                    // empty if block
                }
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(w, h, cyclePos, SubstanceImageCreator.Side.RIGHT, colorScheme);
                ++y;
                break;
            }
            case 4: {
                if (!isSelected) {
                    // empty if block
                }
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(w, h, cyclePos, SubstanceImageCreator.Side.LEFT, colorScheme);
                break;
            }
            case 3: {
                if (!isSelected) {
                    // empty if block
                }
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(w, h, cyclePos, SubstanceImageCreator.Side.BOTTOM, colorScheme);
                backgroundImage = SubstanceImageCreator.getRotated(backgroundImage, 2);
                break;
            }
            default: {
                if (!isSelected) {
                    // empty if block
                }
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(w, h, cyclePos, SubstanceImageCreator.Side.BOTTOM, colorScheme);
            }
        }
        if (backgroundImage != null) {
            g.drawImage(backgroundImage, x, y, null);
        }
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    protected void paintHighlightBelowTab() {
    }

    protected void paintLeftTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
    }

    protected void paintRightTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
    }

    protected void paintTopTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
    }

    protected void paintBottomTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    protected JButton createScrollButton(int direction) {
        Icon icon = SubstanceImageCreator.getArrowIcon(9, 5, direction, SubstanceLookAndFeel.getColorScheme());
        return new SubstanceScrollButton(icon, direction);
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceTabbedPaneUI: \n");
        sb.append("\t" + backgroundMap.size() + " backgrounds");
        return sb.toString();
    }

    protected class TabSelectionHandler
    implements ChangeListener {
        protected TabSelectionHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            tabbedPane.revalidate();
            tabbedPane.repaint();
        }
    }
}

