/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Container;
import java.awt.FontMetrics;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import org.jvnet.substance.SubstanceInternalFrameTitlePane;
import org.jvnet.substance.SubstanceTitlePane;
import org.jvnet.substance.comp.JButtonStrip;
import org.jvnet.substance.comp.JRibbon;

public class Utilities {
    private Utilities() {
    }

    public static String clipString(FontMetrics metrics, int availableWidth, String fullText) {
        if (metrics.stringWidth(fullText) <= availableWidth) {
            return fullText;
        }
        String ellipses = "...";
        int ellipsesWidth = metrics.stringWidth(ellipses);
        if (ellipsesWidth > availableWidth) {
            return "";
        }
        String starter = "";
        String ender = "";
        int w = fullText.length();
        int w2 = w / 2 + w % 2;
        for (int i = 0; i < w2; ++i) {
            String newTitle;
            String newStarter = starter + fullText.charAt(i);
            String newEnder = ender;
            if (w - i > w2) {
                newEnder = fullText.charAt(w - i - 1) + newEnder;
            }
            if (metrics.stringWidth(newTitle = newStarter + ellipses + newEnder) > availableWidth) {
                return newTitle;
            }
            starter = newStarter;
            ender = newEnder;
        }
        return fullText;
    }

    public static boolean hasIcon(AbstractButton button) {
        return button.getIcon() != null;
    }

    public static boolean hasText(AbstractButton button) {
        String text = button.getText();
        return text != null && text.length() > 0;
    }

    public static boolean isComboBoxButton(AbstractButton b) {
        Container parent = b.getParent();
        return parent != null && (parent instanceof JComboBox || parent.getParent() instanceof JComboBox);
    }

    public static boolean isScrollBarButton(AbstractButton b) {
        Container parent = b.getParent();
        return parent != null && (parent instanceof JScrollBar || parent.getParent() instanceof JScrollBar);
    }

    public static boolean isTitleBarButton(AbstractButton b) {
        Container parent = b.getParent();
        boolean isInRootTitle = parent != null && (parent instanceof SubstanceTitlePane || parent.getParent() instanceof SubstanceTitlePane);
        boolean isInInternalTitle = parent != null && (parent instanceof SubstanceInternalFrameTitlePane || parent.getParent() instanceof SubstanceInternalFrameTitlePane);
        return isInRootTitle || isInInternalTitle;
    }

    public static boolean isSpinnerButton(AbstractButton b) {
        Container parent = b.getParent();
        return parent != null && (parent instanceof JSpinner || parent.getParent() instanceof JSpinner);
    }

    public static boolean isToolBarButton(AbstractButton b) {
        Container parent = b.getParent();
        return parent != null && (parent instanceof JToolBar || parent.getParent() instanceof JToolBar);
    }

    public static boolean isTabbedPaneButton(AbstractButton b) {
        Container parent = b.getParent();
        return parent != null && parent instanceof JTabbedPane;
    }

    public static boolean isScrollButton(AbstractButton b) {
        return Utilities.isTabbedPaneButton(b) || Utilities.isScrollBarButton(b);
    }

    public static boolean isButtonStripButton(AbstractButton b) {
        Container parent = b.getParent();
        return parent != null && (parent instanceof JButtonStrip || parent.getParent() instanceof JButtonStrip);
    }

    public static boolean isRibbonButton(AbstractButton b) {
        Container parent = b.getParent();
        return parent != null && parent instanceof JRibbon;
    }
}

