/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermark;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceKatakanaWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage() {
        ClassLoader cl = SubstanceKatakanaWatermark.class.getClassLoader();
        InputStream is = cl.getResourceAsStream("resource/katakana.ttf");
        if (is != null) {
            try {
                Font kf = Font.createFont(0, is);
                int fontSize = 14;
                Font font = kf.deriveFont(1, fontSize);
                Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
                int screenWidth = screenDim.width;
                int screenHeight = screenDim.height;
                watermarkImage = SubstanceImageCreator.getBlankImage(screenWidth, screenHeight);
                Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
                Color stampColor = SubstanceLookAndFeel.getColorScheme().isDark() ? new Color(255, 255, 255, 25) : new Color(0, 0, 0, 15);
                graphics.setColor(stampColor);
                graphics.setFont(font);
                int fontWidth = fontSize;
                int fontHeight = fontSize - 2;
                int rows = screenHeight / fontHeight;
                int columns = screenWidth / fontWidth;
                for (int col = 0; col <= columns; ++col) {
                    for (int row = 0; row <= rows; ++row) {
                        int letterIndex = (int)(33.0 + Math.random() * 95.0);
                        char c = (char)letterIndex;
                        graphics.drawString("" + c, col * fontWidth, fontHeight * (row + 1));
                    }
                }
                graphics.dispose();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String getDisplayName() {
        return SubstanceKatakanaWatermark.getName();
    }

    public static String getName() {
        return "Katakana";
    }

    public boolean isDependingOnTheme() {
        return true;
    }
}

