/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class TinyButtonUI
extends MetalButtonUI {
    public static final int BG_CHANGE_AMOUNT = 10;
    private static final TinyButtonUI buttonUI = new TinyButtonUI();
    private static final BasicStroke focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
    private boolean graphicsTranslated;
    private boolean isToolBarButton;
    private boolean isDefault;

    public void installUI(JComponent c) {
        super.installUI(c);
        if (!Theme.buttonEnter[Theme.style]) {
            return;
        }
        if (!c.isFocusable()) {
            return;
        }
        InputMap km = (InputMap)UIManager.get(String.valueOf(this.getPropertyPrefix()) + "focusInputMap");
        if (km != null) {
            km.put(KeyStroke.getKeyStroke(10, 0, false), "pressed");
            km.put(KeyStroke.getKeyStroke(10, 0, true), "released");
        }
    }

    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        button.setRolloverEnabled(true);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (this.isToolBarButton && !Theme.toolFocus[Theme.style] || !Theme.buttonFocus[Theme.style]) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Rectangle focusRect = b.getBounds();
        g.setColor(Color.black);
        g2d.setStroke(focusStroke);
        int x1 = 2;
        int y1 = 2;
        int x2 = x1 + focusRect.width - 5;
        int y2 = y1 + focusRect.height - 5;
        if (!this.isToolBarButton) {
            ++x1;
            ++y1;
            --x2;
            --y2;
        }
        if (this.graphicsTranslated) {
            g.translate(-1, -1);
        }
        g2d.drawLine(x1, y1, x2, y1);
        g2d.drawLine(x1, y1, x1, y2);
        g2d.drawLine(x1, y2, x2, y2);
        g2d.drawLine(x2, y1, x2, y2);
    }

    public static ComponentUI createUI(JComponent c) {
        return buttonUI;
    }

    protected void paintButtonPressed(Graphics g, AbstractButton button) {
        if (this.isToolBarButton) {
            return;
        }
        Color col = null;
        col = !button.getBackground().equals(Theme.buttonNormalColor[Theme.style].getColor()) ? ColorRoutines.darken(button.getBackground(), 10) : Theme.buttonPressedColor[Theme.style].getColor();
        g.setColor(col);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyButton(g, button, col);
                break;
            }
            case 1: {
                this.drawWinButton(g, button, col);
                break;
            }
            case 2: {
                this.drawXpButton(g, button, col, false);
            }
        }
        if (!(button instanceof JToggleButton) && Theme.shiftButtonText[Theme.style] && button.getText() != null && !"".equals(button.getText())) {
            g.translate(1, 1);
            this.graphicsTranslated = true;
        }
    }

    public void paintToolBarButton(Graphics g, AbstractButton b) {
        ColorUIResource col = null;
        col = b.getModel().isPressed() ? (b.getModel().isRollover() ? Theme.toolButtPressedColor[Theme.style].getColor() : (b.isSelected() ? Theme.toolButtSelectedColor[Theme.style].getColor() : Theme.toolButtColor[Theme.style].getColor())) : (b.getModel().isRollover() && Theme.derivedStyle[Theme.style] == 2 ? (b.isSelected() ? Theme.toolButtSelectedColor[Theme.style].getColor() : Theme.toolButtRolloverColor[Theme.style].getColor()) : (b.isSelected() ? Theme.toolButtSelectedColor[Theme.style].getColor() : Theme.toolButtColor[Theme.style].getColor()));
        g.setColor(col);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyToolBarButton(g, b, col, false);
                break;
            }
            case 1: {
                this.drawWinToolBarButton(g, b, col, false);
                break;
            }
            case 2: {
                this.drawXpToolBarButton(g, b, col, false);
            }
        }
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        if (this.isToolBarButton) {
            this.paintToolBarButton(g, button);
            super.paint(g, c);
            return;
        }
        if (button instanceof JToggleButton && button.isSelected()) {
            this.paintButtonPressed(g, button);
            super.paint(g, c);
            return;
        }
        this.isDefault = c instanceof JButton && ((JButton)c).isDefaultButton();
        boolean isRollover = button.getModel().isRollover() && Theme.buttonRollover[Theme.derivedStyle[Theme.style]];
        boolean isDefinedBackground = c.getBackground().equals(Theme.buttonNormalColor[Theme.style].getColor());
        Color col = null;
        col = !button.isEnabled() ? Theme.buttonDisabledColor[Theme.style].getColor() : (button.getModel().isPressed() ? (isRollover ? (isDefinedBackground ? Theme.buttonPressedColor[Theme.style].getColor() : ColorRoutines.darken(c.getBackground(), 10)) : c.getBackground()) : (isRollover ? (isDefinedBackground ? Theme.buttonRolloverBgColor[Theme.style].getColor() : ColorRoutines.lighten(c.getBackground(), 10)) : c.getBackground()));
        g.setColor(col);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyButton(g, button, col);
                break;
            }
            case 1: {
                this.drawWinButton(g, button, col);
                break;
            }
            case 2: {
                this.drawXpButton(g, button, col, isRollover);
            }
        }
        super.paint(g, c);
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        if (c instanceof JToggleButton) {
            this.paintToggleButtonIcon(g, c, iconRect);
        } else {
            super.paintIcon(g, c, iconRect);
        }
    }

    protected void paintToggleButtonIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Icon icon = null;
        if (!model.isEnabled()) {
            icon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
        } else if (model.isPressed() && model.isArmed()) {
            icon = b.getPressedIcon();
            if (icon == null) {
                icon = b.getSelectedIcon();
            }
        } else if (model.isSelected()) {
            if (b.isRolloverEnabled() && model.isRollover()) {
                icon = b.getRolloverSelectedIcon();
                if (icon == null) {
                    icon = b.getSelectedIcon();
                }
            } else {
                icon = b.getSelectedIcon();
            }
        } else if (model.isRollover() && Theme.derivedStyle[Theme.style] == 2) {
            icon = b.getRolloverIcon();
        }
        if (icon == null) {
            icon = b.getIcon();
        }
        icon.paintIcon(b, g, iconRect.x, iconRect.y);
    }

    public void update(Graphics g, JComponent c) {
        this.isToolBarButton = c.getClientProperty("JToolBar.isToolbarButton") == Boolean.TRUE;
        this.paint(g, c);
        this.graphicsTranslated = false;
    }

    private void drawTinyButton(Graphics g, AbstractButton b, Color c) {
    }

    private void drawWinButton(Graphics g, AbstractButton b, Color c) {
        int w = b.getWidth();
        int h = b.getHeight();
        if (b.isContentAreaFilled() && b.isOpaque()) {
            g.fillRect(1, 1, w - 2, h - 2);
        }
    }

    private void drawXpButton(Graphics g, AbstractButton b, Color c, boolean isRollover) {
        if (!b.isContentAreaFilled()) {
            return;
        }
        if (!b.isOpaque()) {
            return;
        }
        int w = b.getWidth();
        int h = b.getHeight();
        Color bg = b.getParent().getBackground();
        g.setColor(bg);
        g.drawRect(0, 0, w - 1, h - 1);
        int spread1 = Theme.buttonSpreadLight[Theme.style];
        int spread2 = Theme.buttonSpreadDark[Theme.style];
        if (!b.isEnabled()) {
            spread1 = Theme.buttonSpreadLightDisabled[Theme.style];
            spread2 = Theme.buttonSpreadDarkDisabled[Theme.style];
        }
        float spreadStep1 = 10.0f * (float)spread1 / (float)(h - 3);
        float spreadStep2 = 10.0f * (float)spread2 / (float)(h - 3);
        int halfY = h / 2;
        int y = 1;
        while (y < h - 1) {
            int yd;
            if (y < halfY) {
                yd = halfY - y;
                g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
            } else if (y == halfY) {
                g.setColor(c);
            } else {
                yd = y - halfY;
                g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
            }
            g.drawLine(2, y, w - 3, y);
            if (y == 1) {
                g.drawLine(1, 1, 1, h - 2);
                if (isRollover || this.isDefault) {
                    g.drawLine(w - 2, 1, w - 2, h - 2);
                }
            } else if (y == h - 2 && !isRollover && !this.isDefault) {
                g.drawLine(w - 2, 1, w - 2, h - 2);
            }
            ++y;
        }
        if (isRollover) {
            g.setColor(Theme.buttonRolloverColor[Theme.style].getColor());
            g.drawLine(1, h - 2, 1, h - 2);
            g.drawLine(w - 2, h - 2, w - 2, h - 2);
        } else if (this.isDefault) {
            g.setColor(Theme.buttonDefaultColor[Theme.style].getColor());
            g.drawLine(1, h - 2, 1, h - 2);
            g.drawLine(w - 2, h - 2, w - 2, h - 2);
        }
    }

    private void drawTinyToolBarButton(Graphics g, AbstractButton b, Color c, boolean isPressed) {
    }

    private void drawWinToolBarButton(Graphics g, AbstractButton b, Color c, boolean isPressed) {
        int w = b.getWidth();
        int h = b.getHeight();
        if (b.isContentAreaFilled()) {
            g.fillRect(1, 1, w - 2, h - 2);
        }
    }

    private void drawXpToolBarButton(Graphics g, AbstractButton b, Color c, boolean isPressed) {
        int w = b.getWidth();
        int h = b.getHeight();
        if (b.isContentAreaFilled()) {
            g.fillRect(1, 1, w - 2, h - 2);
        }
        Color bg = b.getParent().getBackground();
        g.setColor(bg);
        g.drawRect(0, 0, w - 1, h - 1);
    }
}

