/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.ScrollBarUI;
import com.digitprop.tonic.TonicScrollPaneLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneConstants;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class ScrollPaneUI
extends javax.swing.plaf.ScrollPaneUI
implements ScrollPaneConstants {
    protected JScrollPane scrollpane;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;
    private MouseWheelListener mouseScrollListener;
    private PropertyChangeListener vsbPropertyChangeListener;
    private PropertyChangeListener hsbPropertyChangeListener;
    private PropertyChangeListener sbPropertyChangeListener;
    private boolean setValueCalled = false;

    public static ComponentUI createUI(JComponent component) {
        return new ScrollPaneUI();
    }

    public void paint(Graphics g, JComponent c) {
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void installDefaults(JScrollPane scrollpane) {
        LookAndFeel.installBorder(scrollpane, "ScrollPane.border");
        LookAndFeel.installColorsAndFont(scrollpane, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        Border vpBorder = scrollpane.getViewportBorder();
        if (vpBorder == null || vpBorder instanceof UIResource) {
            vpBorder = UIManager.getBorder("ScrollPane.viewportBorder");
            scrollpane.setViewportBorder(vpBorder);
        }
        scrollpane.setLayout(new TonicScrollPaneLayout());
        scrollpane.setCorner("UPPER_RIGHT_CORNER", new UpperRightCorner());
    }

    protected void installListeners(JScrollPane c) {
        this.vsbChangeListener = this.createVSBChangeListener();
        this.vsbPropertyChangeListener = this.createVSBPropertyChangeListener();
        this.hsbChangeListener = this.createHSBChangeListener();
        this.hsbPropertyChangeListener = this.createHSBPropertyChangeListener();
        this.viewportChangeListener = this.createViewportChangeListener();
        this.spPropertyChangeListener = this.createPropertyChangeListener();
        JViewport viewport = this.scrollpane.getViewport();
        JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
        JScrollBar hsb = this.scrollpane.getHorizontalScrollBar();
        if (viewport != null) {
            viewport.addChangeListener(this.viewportChangeListener);
        }
        if (vsb != null) {
            vsb.getModel().addChangeListener(this.vsbChangeListener);
            vsb.addPropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (hsb != null) {
            hsb.getModel().addChangeListener(this.hsbChangeListener);
            hsb.addPropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.addPropertyChangeListener(this.spPropertyChangeListener);
        this.mouseScrollListener = this.createMouseWheelListener();
        this.scrollpane.addMouseWheelListener(this.mouseScrollListener);
    }

    protected void installKeyboardActions(JScrollPane c) {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(c, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(c, actionMap);
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            InputMap rtlKeyMap;
            InputMap keyMap = (InputMap)UIManager.get("ScrollPane.ancestorInputMap");
            if (this.scrollpane.getComponentOrientation().isLeftToRight() || (rtlKeyMap = (InputMap)UIManager.get("ScrollPane.ancestorInputMap.RightToLeft")) == null) {
                return keyMap;
            }
            rtlKeyMap.setParent(keyMap);
            return rtlKeyMap;
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIManager.get("ScrollPane.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("ScrollPane.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("scrollUp", new ScrollAction("scrollUp", 1, -1, true));
        map.put("scrollDown", new ScrollAction("scrollDown", 1, 1, true));
        map.put("scrollHome", new ScrollHomeAction("ScrollHome"));
        map.put("scrollEnd", new ScrollEndAction("ScrollEnd"));
        map.put("unitScrollUp", new ScrollAction("UnitScrollUp", 1, -1, false));
        map.put("unitScrollDown", new ScrollAction("UnitScrollDown", 1, 1, false));
        if (this.scrollpane.getComponentOrientation().isLeftToRight()) {
            map.put("scrollLeft", new ScrollAction("scrollLeft", 0, -1, true));
            map.put("scrollRight", new ScrollAction("ScrollRight", 0, 1, true));
            map.put("unitScrollRight", new ScrollAction("UnitScrollRight", 0, 1, false));
            map.put("unitScrollLeft", new ScrollAction("UnitScrollLeft", 0, -1, false));
        } else {
            map.put("scrollLeft", new ScrollAction("scrollLeft", 0, 1, true));
            map.put("scrollRight", new ScrollAction("ScrollRight", 0, -1, true));
            map.put("unitScrollRight", new ScrollAction("UnitScrollRight", 0, -1, false));
            map.put("unitScrollLeft", new ScrollAction("UnitScrollLeft", 0, 1, false));
        }
        return map;
    }

    public void installUI(JComponent component) {
        this.scrollpane = (JScrollPane)component;
        this.installDefaults(this.scrollpane);
        this.installListeners(this.scrollpane);
        this.installKeyboardActions(this.scrollpane);
    }

    protected void uninstallDefaults(JScrollPane c) {
        LookAndFeel.uninstallBorder(this.scrollpane);
        if (this.scrollpane.getViewportBorder() instanceof UIResource) {
            this.scrollpane.setViewportBorder(null);
        }
    }

    protected void uninstallListeners(JComponent c) {
        JViewport viewport = this.scrollpane.getViewport();
        JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
        JScrollBar hsb = this.scrollpane.getHorizontalScrollBar();
        if (viewport != null) {
            viewport.removeChangeListener(this.viewportChangeListener);
        }
        if (vsb != null) {
            vsb.getModel().removeChangeListener(this.vsbChangeListener);
            vsb.removePropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (hsb != null) {
            hsb.getModel().removeChangeListener(this.hsbChangeListener);
            hsb.removePropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.removePropertyChangeListener(this.spPropertyChangeListener);
        if (this.mouseScrollListener != null) {
            this.scrollpane.removeMouseWheelListener(this.mouseScrollListener);
        }
        this.vsbChangeListener = null;
        this.hsbChangeListener = null;
        this.viewportChangeListener = null;
        this.spPropertyChangeListener = null;
        this.mouseScrollListener = null;
    }

    protected void uninstallKeyboardActions(JScrollPane c) {
        SwingUtilities.replaceUIActionMap(c, null);
        SwingUtilities.replaceUIInputMap(c, 1, null);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults(this.scrollpane);
        this.uninstallListeners(this.scrollpane);
        this.uninstallKeyboardActions(this.scrollpane);
        this.scrollpane = null;
    }

    protected void syncScrollPaneWithViewport() {
        JViewport viewport = this.scrollpane.getViewport();
        JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
        JScrollBar hsb = this.scrollpane.getHorizontalScrollBar();
        JViewport rowHead = this.scrollpane.getRowHeader();
        JViewport colHead = this.scrollpane.getColumnHeader();
        boolean ltr = this.scrollpane.getComponentOrientation().isLeftToRight();
        if (viewport != null) {
            int value;
            int max;
            int extent;
            Dimension extentSize = viewport.getExtentSize();
            Dimension viewSize = viewport.getViewSize();
            Point viewPosition = viewport.getViewPosition();
            if (vsb != null) {
                extent = extentSize.height;
                max = viewSize.height;
                value = Math.max(0, Math.min(viewPosition.y, max - extent));
                vsb.setValues(value, extent, 0, max);
            }
            if (hsb != null) {
                extent = extentSize.width;
                max = viewSize.width;
                if (ltr) {
                    value = Math.max(0, Math.min(viewPosition.x, max - extent));
                } else {
                    int currentValue = hsb.getValue();
                    if (this.setValueCalled && max - currentValue == viewPosition.x) {
                        value = Math.max(0, Math.min(max - extent, currentValue));
                        if (extent != 0) {
                            this.setValueCalled = false;
                        }
                    } else if (extent > max) {
                        viewPosition.x = max - extent;
                        viewport.setViewPosition(viewPosition);
                        value = 0;
                    } else {
                        value = Math.max(0, Math.min(max - extent, max - extent - viewPosition.x));
                    }
                }
                hsb.setValues(value, extent, 0, max);
            }
            if (rowHead != null) {
                Point p = rowHead.getViewPosition();
                p.y = viewport.getViewPosition().y;
                p.x = 0;
                rowHead.setViewPosition(p);
            }
            if (colHead != null) {
                Point p = colHead.getViewPosition();
                p.x = ltr ? viewport.getViewPosition().x : Math.max(0, viewport.getViewPosition().x);
                p.y = 0;
                colHead.setViewPosition(p);
            }
        }
    }

    protected ChangeListener createViewportChangeListener() {
        return new ViewportChangeHandler();
    }

    private PropertyChangeListener createHSBPropertyChangeListener() {
        return this.getSBPropertyChangeListener();
    }

    private PropertyChangeListener getSBPropertyChangeListener() {
        if (this.sbPropertyChangeListener == null) {
            this.sbPropertyChangeListener = new ScrollBarPropertyChangeHandler();
        }
        return this.sbPropertyChangeListener;
    }

    protected ChangeListener createHSBChangeListener() {
        return new HSBChangeListener();
    }

    private PropertyChangeListener createVSBPropertyChangeListener() {
        return this.getSBPropertyChangeListener();
    }

    protected ChangeListener createVSBChangeListener() {
        return new VSBChangeListener();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent e) {
        this.scrollpane.revalidate();
        this.scrollpane.repaint();
    }

    protected void updateViewport(PropertyChangeEvent e) {
        JViewport oldViewport = (JViewport)e.getOldValue();
        JViewport newViewport = (JViewport)e.getNewValue();
        if (oldViewport != null) {
            oldViewport.removeChangeListener(this.viewportChangeListener);
        }
        if (newViewport != null) {
            int max;
            int extent;
            Point p = newViewport.getViewPosition();
            p.x = this.scrollpane.getComponentOrientation().isLeftToRight() ? Math.max(p.x, 0) : ((extent = newViewport.getExtentSize().width) > (max = newViewport.getViewSize().width) ? max - extent : Math.max(0, Math.min(max - extent, p.x)));
            p.y = Math.max(p.y, 0);
            newViewport.setViewPosition(p);
            newViewport.addChangeListener(this.viewportChangeListener);
        }
    }

    protected void updateRowHeader(PropertyChangeEvent e) {
        JViewport newRowHead = (JViewport)e.getNewValue();
        if (newRowHead != null) {
            JViewport viewport = this.scrollpane.getViewport();
            Point p = newRowHead.getViewPosition();
            p.y = viewport != null ? viewport.getViewPosition().y : 0;
            newRowHead.setViewPosition(p);
        }
    }

    protected void updateColumnHeader(PropertyChangeEvent e) {
        JViewport newColHead = (JViewport)e.getNewValue();
        if (newColHead != null) {
            JViewport viewport = this.scrollpane.getViewport();
            Point p = newColHead.getViewPosition();
            p.x = viewport == null ? 0 : (this.scrollpane.getComponentOrientation().isLeftToRight() ? viewport.getViewPosition().x : Math.max(0, viewport.getViewPosition().x));
            newColHead.setViewPosition(p);
            this.scrollpane.add((Component)newColHead, "COLUMN_HEADER");
        }
    }

    private void updateHorizontalScrollBar(PropertyChangeEvent pce) {
        this.updateScrollBar(pce, this.hsbChangeListener, this.hsbPropertyChangeListener);
    }

    private void updateVerticalScrollBar(PropertyChangeEvent pce) {
        this.updateScrollBar(pce, this.vsbChangeListener, this.vsbPropertyChangeListener);
    }

    private void updateScrollBar(PropertyChangeEvent pce, ChangeListener cl, PropertyChangeListener pcl) {
        JScrollBar sb = (JScrollBar)pce.getOldValue();
        if (sb != null) {
            if (cl != null) {
                sb.getModel().removeChangeListener(cl);
            }
            if (pcl != null) {
                sb.removePropertyChangeListener(pcl);
            }
        }
        if ((sb = (JScrollBar)pce.getNewValue()) != null) {
            if (cl != null) {
                sb.getModel().addChangeListener(cl);
            }
            if (pcl != null) {
                sb.addPropertyChangeListener(pcl);
            }
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public class ViewportChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            ScrollPaneUI.this.syncScrollPaneWithViewport();
        }
    }

    public class HSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            JViewport viewport = ScrollPaneUI.this.scrollpane.getViewport();
            if (viewport != null) {
                BoundedRangeModel model = (BoundedRangeModel)e.getSource();
                Point p = viewport.getViewPosition();
                int value = model.getValue();
                if (ScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight()) {
                    p.x = value;
                } else {
                    int max = viewport.getViewSize().width;
                    int extent = viewport.getExtentSize().width;
                    int oldX = p.x;
                    p.x = max - extent - value;
                    if (extent == 0 && value != 0 && oldX == max) {
                        ScrollPaneUI.this.setValueCalled = true;
                    } else if (extent != 0 && oldX < 0 && p.x == 0) {
                        p.x += value;
                    }
                }
                viewport.setViewPosition(p);
            }
        }
    }

    public class VSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            JViewport viewport = ScrollPaneUI.this.scrollpane.getViewport();
            if (viewport != null) {
                BoundedRangeModel model = (BoundedRangeModel)e.getSource();
                Point p = viewport.getViewPosition();
                p.y = model.getValue();
                viewport.setViewPosition(p);
            }
        }
    }

    private class ScrollBarPropertyChangeHandler
    implements PropertyChangeListener {
        ScrollBarPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            Object source = e.getSource();
            if ("model".equals(propertyName)) {
                JScrollBar sb = ScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                BoundedRangeModel oldModel = (BoundedRangeModel)e.getOldValue();
                ChangeListener cl = null;
                if (source == sb) {
                    cl = ScrollPaneUI.this.vsbChangeListener;
                } else if (source == ScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                    sb = ScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    cl = ScrollPaneUI.this.hsbChangeListener;
                }
                if (cl != null) {
                    if (oldModel != null) {
                        oldModel.removeChangeListener(cl);
                    }
                    if (sb.getModel() != null) {
                        sb.getModel().addChangeListener(cl);
                    }
                }
            } else if ("componentOrientation".equals(propertyName) && source == ScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                JScrollBar hsb = ScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                JViewport viewport = ScrollPaneUI.this.scrollpane.getViewport();
                Point p = viewport.getViewPosition();
                p.x = ScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight() ? hsb.getValue() : viewport.getViewSize().width - viewport.getExtentSize().width - hsb.getValue();
                viewport.setViewPosition(p);
            }
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        protected MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (ScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && e.getScrollAmount() != 0) {
                JScrollBar toScroll = ScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int direction = 0;
                if (!(toScroll != null && toScroll.isVisible() || (toScroll = ScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) != null && toScroll.isVisible())) {
                    return;
                }
                int n = direction = e.getWheelRotation() < 0 ? -1 : 1;
                if (e.getScrollType() == 0) {
                    ScrollBarUI.scrollTonicByUnits(toScroll, direction, e.getScrollAmount());
                } else if (e.getScrollType() == 1) {
                    ScrollBarUI.scrollTonicByBlock(toScroll, direction);
                }
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("verticalScrollBarDisplayPolicy")) {
                ScrollPaneUI.this.updateScrollBarDisplayPolicy(e);
            } else if (propertyName.equals("horizontalScrollBarDisplayPolicy")) {
                ScrollPaneUI.this.updateScrollBarDisplayPolicy(e);
            } else if (propertyName.equals("viewport")) {
                ScrollPaneUI.this.updateViewport(e);
            } else if (propertyName.equals("rowHeader")) {
                ScrollPaneUI.this.updateRowHeader(e);
            } else if (propertyName.equals("columnHeader")) {
                ScrollPaneUI.this.updateColumnHeader(e);
            } else if (propertyName.equals("verticalScrollBar")) {
                ScrollPaneUI.this.updateVerticalScrollBar(e);
            } else if (propertyName.equals("horizontalScrollBar")) {
                ScrollPaneUI.this.updateHorizontalScrollBar(e);
            } else if (propertyName.equals("componentOrientation")) {
                ScrollPaneUI.this.scrollpane.revalidate();
                ScrollPaneUI.this.scrollpane.repaint();
                InputMap inputMap = ScrollPaneUI.this.getInputMap(1);
                SwingUtilities.replaceUIInputMap(ScrollPaneUI.this.scrollpane, 1, inputMap);
                UIManager.getLookAndFeelDefaults().put("ScrollPane.actionMap", (Object)null);
                ActionMap actionMap = ScrollPaneUI.this.getActionMap();
                SwingUtilities.replaceUIActionMap(ScrollPaneUI.this.scrollpane, actionMap);
            }
        }
    }

    private static class ScrollAction
    extends AbstractAction {
        protected int orientation;
        protected int direction;
        private boolean block;

        protected ScrollAction(String name, int orientation, int direction, boolean block) {
            super(name);
            this.orientation = orientation;
            this.direction = direction;
            this.block = block;
        }

        public void actionPerformed(ActionEvent e) {
            Component view;
            JScrollPane scrollpane = (JScrollPane)e.getSource();
            JViewport vp = scrollpane.getViewport();
            if (vp != null && (view = vp.getView()) != null) {
                Rectangle visRect = vp.getViewRect();
                Dimension vSize = view.getSize();
                int amount = view instanceof Scrollable ? (this.block ? ((Scrollable)((Object)view)).getScrollableBlockIncrement(visRect, this.orientation, this.direction) : ((Scrollable)((Object)view)).getScrollableUnitIncrement(visRect, this.orientation, this.direction)) : (this.block ? (this.orientation == 1 ? visRect.height : visRect.width) : 10);
                if (this.orientation == 1) {
                    visRect.y += amount * this.direction;
                    if (visRect.y + visRect.height > vSize.height) {
                        visRect.y = Math.max(0, vSize.height - visRect.height);
                    } else if (visRect.y < 0) {
                        visRect.y = 0;
                    }
                } else if (scrollpane.getComponentOrientation().isLeftToRight()) {
                    visRect.x += amount * this.direction;
                    if (visRect.x + visRect.width > vSize.width) {
                        visRect.x = Math.max(0, vSize.width - visRect.width);
                    } else if (visRect.x < 0) {
                        visRect.x = 0;
                    }
                } else {
                    visRect.x -= amount * this.direction;
                    visRect.x = visRect.width > vSize.width ? vSize.width - visRect.width : Math.max(0, Math.min(vSize.width - visRect.width, visRect.x));
                }
                vp.setViewPosition(visRect.getLocation());
            }
        }
    }

    private static class ScrollHomeAction
    extends AbstractAction {
        protected ScrollHomeAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            Component view;
            JScrollPane scrollpane = (JScrollPane)e.getSource();
            JViewport vp = scrollpane.getViewport();
            if (vp != null && (view = vp.getView()) != null) {
                if (scrollpane.getComponentOrientation().isLeftToRight()) {
                    vp.setViewPosition(new Point(0, 0));
                } else {
                    Rectangle visRect = vp.getViewRect();
                    Rectangle bounds = view.getBounds();
                    vp.setViewPosition(new Point(bounds.width - visRect.width, 0));
                }
            }
        }
    }

    private static class ScrollEndAction
    extends AbstractAction {
        protected ScrollEndAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            Component view;
            JScrollPane scrollpane = (JScrollPane)e.getSource();
            JViewport vp = scrollpane.getViewport();
            if (vp != null && (view = vp.getView()) != null) {
                Rectangle visRect = vp.getViewRect();
                Rectangle bounds = view.getBounds();
                if (scrollpane.getComponentOrientation().isLeftToRight()) {
                    vp.setViewPosition(new Point(bounds.width - visRect.width, bounds.height - visRect.height));
                } else {
                    vp.setViewPosition(new Point(0, bounds.height - visRect.height));
                }
            }
        }
    }

    class UpperRightCorner
    extends JComponent {
        UpperRightCorner() {
        }

        public void paint(Graphics g) {
            g.setColor(UIManager.getColor("Button.borderColor"));
            g.drawLine(0, 0, 0, this.getHeight());
        }
    }
}

