/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.wordrider.area.RiderArea;
import net.wordrider.utilities.Swinger;

final class AreaBorder
extends EmptyBorder
implements PropertyChangeListener {
    public static final int SHADOW_BAR_WIDTH = 25;
    private static Color LINE_BORDER_COLOR;
    private static Color DOTTED_LINE_BORDER_COLOR;
    private RiderArea component;
    private static final Stroke DOTTED_STROKE_BORDER;

    public AreaBorder(int n, int n2, int n3, int n4, RiderArea riderArea) {
        super(n, n2, n3, n4);
        this.component = riderArea;
        AreaBorder.updateColors();
        UIManager.addPropertyChangeListener(this);
    }

    private final int getRightInset() {
        if (this.component.limitRightBorder()) {
            int n = this.component.getWidth();
            return n <= 0 ? 0 : n - this.component.getMaxTextWidth() - this.left;
        }
        return this.right;
    }

    public final Insets getBorderInsets(Component component, Insets insets) {
        insets.left = this.left;
        insets.top = this.top;
        insets.right = this.getRightInset();
        insets.bottom = this.bottom;
        return insets;
    }

    public final Insets getBorderInsets() {
        return new Insets(this.top, this.left, this.bottom, this.getRightInset());
    }

    public final void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        super.paintBorder(component, graphics, n, n2, n3, n4);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.setPaintMode();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, n4 - this.bottom, n3 + 1, n4);
        graphics.setXORMode(Color.WHITE);
        graphics.setColor(LINE_BORDER_COLOR);
        graphics.fillRect(0, n2, 25, n4);
        if (this.component.showRightBorder()) {
            int n5 = this.component.getInsets().left + this.component.getMaxTextWidth() + 1;
            graphics.setColor(LINE_BORDER_COLOR);
            graphics2D.drawLine(n5, n2, n5, n4);
        }
        graphics2D.setPaintMode();
        graphics2D.setColor(DOTTED_LINE_BORDER_COLOR);
        graphics2D.setStroke(DOTTED_STROKE_BORDER);
        graphics2D.drawLine(24, n2, 24, n4);
    }

    private static void updateColors() {
        LINE_BORDER_COLOR = Swinger.brighter(UIManager.getDefaults().getColor("control"));
        DOTTED_LINE_BORDER_COLOR = LINE_BORDER_COLOR.darker();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
            AreaBorder.updateColors();
            this.component.validate();
            this.component.repaint();
        }
    }

    static {
        DOTTED_STROKE_BORDER = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{1.5f}, 1.8f);
    }
}

