/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import javax.swing.InputMap;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import javax.swing.undo.UndoManager;
import net.wordrider.area.AreaBorder;
import net.wordrider.area.AreaUndoManager;
import net.wordrider.area.ContextMenu;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.RiderEditorKit;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.StyledContent;
import net.wordrider.area.StyledContentSelection;
import net.wordrider.area.actions.AligmentLeftAction;
import net.wordrider.area.actions.CtrlDeleteAction;
import net.wordrider.area.actions.GetNextTabAction;
import net.wordrider.area.actions.GetPrevTabAction;
import net.wordrider.area.actions.RedoAction;
import net.wordrider.area.actions.RotateAligmentStyleAction;
import net.wordrider.area.actions.RotateMarginStyleAction;
import net.wordrider.area.actions.UndoAction;
import net.wordrider.utilities.Utils;

public final class RiderArea
extends JTextPane
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private static final int LEFT_BORDER_WIDTH = 30;
    private boolean isModified = false;
    private static boolean isOvertypeMode;
    private static InputMap defaultInputMap;
    private final Caret defaultCaret = this.getCaret();
    private static final Caret overtypeCaret;
    private static final ClipboardOwner defaultClipboardOwner;
    private AreaUndoManager undoManager = null;
    private static final DataFlavor df;
    private final DragSource dragSource = new DragSource();
    private int lastSelStart = 0;
    private int lastSelEnd = 0;
    private int dndEventLocation = 0;
    private boolean dragStartedHere = false;
    private static int maxTI89FontWidth;
    private static int maxTI92FontWidth;
    public static final int FULLVIEWBORDER = 0;
    public static final int TI89VIEWBORDER = 1;
    public static final int TI92VIEWBORDER = 2;
    private int borderType = 0;
    private int maxRightWidth = -1;
    private boolean noModifyChange = false;

    public RiderArea() {
        this.init();
    }

    public final RiderDocument getDoc() {
        return (RiderDocument)this.getDocument();
    }

    public final RiderEditorKit getKit() {
        return (RiderEditorKit)this.getEditorKit();
    }

    private final void init() {
        int n;
        new DropTarget(this, this);
        if (maxTI89FontWidth == 0) {
            maxTI89FontWidth = this.getFontMetrics(RiderStyles.getAreaFont()).stringWidth("01234567890123456789012345") + 1;
        }
        if (maxTI92FontWidth == 0) {
            maxTI92FontWidth = this.getFontMetrics(RiderStyles.getAreaFont()).stringWidth("012345678901234567890123456789012345") + 1;
        }
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.setBorder(new AreaBorder(2, 30, 0, 4, this));
        this.createUndoManager();
        if (defaultInputMap == null) {
            Utils.addKeyActions(this);
            defaultInputMap = RiderArea.initActions(this.getInputMap());
        }
        this.setInputMap(0, defaultInputMap);
        this.setFont(RiderStyles.getAreaFont());
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        for (n = 0; n < mouseListenerArray.length; ++n) {
            this.removeMouseListener(mouseListenerArray[n]);
        }
        this.addMouseMotionListener(new MouseMoveAdapter());
        this.addMouseListener(new MouseClickAdapter());
        for (n = 0; n < mouseListenerArray.length; ++n) {
            this.addMouseListener(mouseListenerArray[n]);
        }
        this.addKeyListener(new AlfaBetaKeyListener());
        overtypeCaret.setBlinkRate(this.defaultCaret.getBlinkRate());
        this.setOvertypeMode(false);
    }

    boolean showRightBorder() {
        return this.borderType != 0;
    }

    boolean limitRightBorder() {
        return this.borderType != 0;
    }

    public final UndoManager getUndoManager() {
        return this.undoManager;
    }

    public final int getViewBorder() {
        return this.borderType;
    }

    public final void setViewBorder(int n) {
        switch (n) {
            case 0: {
                this.maxRightWidth = -1;
                break;
            }
            case 1: {
                this.maxRightWidth = maxTI89FontWidth;
                break;
            }
            case 2: {
                this.maxRightWidth = maxTI92FontWidth;
                break;
            }
            default: {
                return;
            }
        }
        this.borderType = n;
        final RiderArea riderArea = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                riderArea.validate();
                riderArea.repaint();
            }
        });
    }

    public void setOvertypeMode(boolean bl) {
        isOvertypeMode = bl;
        int n = this.getCaretPosition();
        this.putClientProperty("overtype", bl);
        this.firePropertyChange("overtype", bl, bl);
        if (bl) {
            this.setCaret(overtypeCaret);
        } else {
            this.setCaret(this.defaultCaret);
            this.getDoc().refresh(n, 1);
        }
        this.setCaretPosition(n);
    }

    int getMaxTextWidth() {
        return this.maxRightWidth;
    }

    public final void setDocument(Document document) {
        super.setDocument(document);
        this.setModified(false);
        this.createUndoManager();
    }

    private void createUndoManager() {
        this.undoManager = new AreaUndoManager(this);
    }

    public final void setModified(boolean bl) {
        if (this.isModified != bl) {
            if (this.noModifyChange) {
                return;
            }
            this.isModified = bl;
            this.putClientProperty("modified", bl);
        }
    }

    public final boolean isModified() {
        return this.isModified;
    }

    private final void replaceSelection(StyledContent styledContent) {
        Caret caret = this.getCaret();
        try {
            int n = Math.min(caret.getDot(), caret.getMark());
            int n2 = Math.max(caret.getDot(), caret.getMark());
            if (n != n2) {
                this.getDocument().remove(n, n2 - n);
            }
            if (styledContent != null) {
                styledContent.insert(this, n);
            }
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
    }

    public final void noModifyUpdate(boolean bl) {
        this.noModifyChange = bl;
    }

    public void replaceSelection(String string) {
        if (RiderArea.isOvertypeMode()) {
            int n = this.getCaretPosition();
            if (this.getSelectedText() == null && n < this.getDocument().getLength()) {
                this.moveCaretPosition(n + 1);
            }
        }
        super.replaceSelection(string);
    }

    private static boolean isOvertypeMode() {
        return isOvertypeMode;
    }

    protected final EditorKit createDefaultEditorKit() {
        return new RiderEditorKit();
    }

    public final void cut() {
        if (this.isEditable() && this.isEnabled()) {
            this.copy();
            this.replaceSelection("");
        }
    }

    public final void copy() {
        try {
            StyledContent styledContent = new StyledContent(this);
            StyledContentSelection styledContentSelection = new StyledContentSelection(styledContent);
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            clipboard.setContents(styledContentSelection, defaultClipboardOwner);
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
    }

    public final void paste() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                if (transferable.isDataFlavorSupported(df)) {
                    this.replaceSelection((StyledContent)transferable.getTransferData(df));
                } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String string = transferable.getTransferData(DataFlavor.stringFlavor).toString();
                    this.replaceSelection(string);
                }
            }
            catch (Exception exception) {
                Utils.processException(exception);
            }
        }
    }

    public final Color getCaretColor() {
        if (this.hasFocus()) {
            int n = this.getCaretPosition();
            try {
                if (RiderStyles.isInvert(this.getInputAttributes()) && Utilities.getRowEnd(this, n) != n) {
                    return Color.WHITE;
                }
            }
            catch (BadLocationException badLocationException) {
                Utils.processException(badLocationException);
            }
        }
        return super.getCaretColor();
    }

    private static InputMap initActions(InputMap inputMap) {
        inputMap.put(KeyStroke.getKeyStroke(89, 2), RedoAction.getInstance());
        inputMap.put(KeyStroke.getKeyStroke(8, 3), RedoAction.getInstance());
        inputMap.put(KeyStroke.getKeyStroke(8, 8), UndoAction.getInstance());
        inputMap.put(KeyStroke.getKeyStroke(127, 2), new CtrlDeleteAction());
        inputMap.put(KeyStroke.getKeyStroke(48, 8), AligmentLeftAction.getInstance());
        inputMap.put(KeyStroke.getKeyStroke("F4"), RotateAligmentStyleAction.getInstance());
        inputMap.put(KeyStroke.getKeyStroke("F5"), RotateMarginStyleAction.getInstance());
        inputMap.put(GetNextTabAction.getInstance().getKeyStroke(), GetNextTabAction.getInstance());
        inputMap.put(GetPrevTabAction.getInstance().getKeyStroke(), GetPrevTabAction.getInstance());
        return inputMap;
    }

    private static boolean isInLeftBorder(MouseEvent mouseEvent) {
        return mouseEvent.getX() < 25;
    }

    private Element getBookmarkElement(MouseEvent mouseEvent, int n) {
        if (n != -1) {
            Rectangle rectangle;
            Element element = this.getStyledDocument().getParagraphElement(n);
            if (RiderStyles.isReadonlySection(element) || RiderStyles.isMath(element)) {
                return null;
            }
            try {
                rectangle = this.modelToView(element.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                Utils.processException(badLocationException);
                return null;
            }
            if (mouseEvent.getY() >= rectangle.y + 2 && mouseEvent.getY() <= rectangle.height + rectangle.y - 2) {
                return element;
            }
        }
        return null;
    }

    public final void changedUpdate(DocumentEvent documentEvent) {
    }

    public final void insertUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    public final void removeUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    private void areaMouseMoved(MouseEvent mouseEvent) {
        if (RiderArea.isInLeftBorder(mouseEvent)) {
            int n = ((JTextComponent)mouseEvent.getSource()).viewToModel(mouseEvent.getPoint());
            if (this.getBookmarkElement(mouseEvent, n) != null) {
                if (this.getCursor().getType() != 12) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }
            } else if (this.getCursor().getType() != 0) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        } else if (this.getCursor().getType() != 2) {
            this.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        int n = this.getSelectionStart();
        try {
            if (this.lastSelEnd > this.lastSelStart && n >= this.lastSelStart && n < this.lastSelEnd) {
                this.dragStartedHere = true;
                this.select(this.lastSelStart, this.lastSelEnd);
                StyledContent styledContent = new StyledContent(this);
                StyledContentSelection styledContentSelection = new StyledContentSelection(styledContent);
                this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, styledContentSelection, this);
            }
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.dragStartedHere = false;
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.dndEventLocation = this.viewToModel(dropTargetDragEvent.getLocation());
        try {
            this.setCaretPosition(this.dndEventLocation);
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.dndEventLocation = this.viewToModel(dropTargetDropEvent.getLocation());
        if (this.dndEventLocation >= this.lastSelStart && this.dndEventLocation <= this.lastSelEnd) {
            dropTargetDropEvent.rejectDrop();
            this.select(this.lastSelStart, this.lastSelEnd);
        } else {
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(df)) {
                    StyledContent styledContent = (StyledContent)transferable.getTransferData(df);
                    this.doDrop(dropTargetDropEvent, styledContent);
                } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    this.doDrop(dropTargetDropEvent, string);
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (Exception exception) {
                Utils.processException(exception);
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDrop(DropTargetDropEvent dropTargetDropEvent, Object object) {
        try {
            this.firePropertyChange("undoredo", false, true);
            int n = 0;
            int n2 = 0;
            dropTargetDropEvent.acceptDrop(2);
            this.addElement(object);
            if (this.dndEventLocation < this.lastSelStart) {
                n = object.toString().length();
            } else {
                n2 = object.toString().length();
            }
            int n3 = this.dndEventLocation + (this.lastSelEnd - this.lastSelStart) - n2;
            int n4 = this.dndEventLocation - n2;
            if (this.dragStartedHere) {
                this.lastSelStart += n;
                this.lastSelEnd += n;
                this.removeElement();
            }
            this.lastSelEnd = n3;
            this.lastSelStart = n4;
            this.select(this.lastSelStart, this.lastSelEnd);
            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
        }
        finally {
            this.firePropertyChange("undoredo", true, false);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void addElement(Object object) {
        try {
            this.setCaretPosition(this.dndEventLocation);
            if (object instanceof StyledContent) {
                this.replaceSelection((StyledContent)object);
            } else if (object instanceof String) {
                this.replaceSelection((String)object);
            }
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
    }

    public void removeElement() {
        this.select(this.lastSelStart, this.lastSelEnd);
        this.replaceSelection("");
    }

    public void finalize() {
        this.undoManager.discardAllEdits();
        this.undoManager = null;
        defaultInputMap = null;
    }

    static {
        defaultInputMap = null;
        overtypeCaret = new OvertypeCaret();
        defaultClipboardOwner = new ClipboardObserver();
        df = new DataFlavor(StyledContent.class, "StyledContent");
        maxTI89FontWidth = 0;
        maxTI92FontWidth = 0;
    }

    private final class AlfaBetaKeyListener
    implements KeyListener {
        private static final char ALFA = '\u20ac';
        private static final char GAMA = '\u0192';
        private static final char GAMA_U = '\u201a';
        private static final char BETA = '\u0081';
        private static final char DELTA = '\u2026';
        private static final char DELTA_U = '\u201e';
        private static final char EPSILON = '\u2020';
        private static final char FI = '\u2018';
        private static final char LAMBDA = '\u2030';
        private static final char MY = '\u00b1';
        private static final char PI = '\u0152';
        private static final char PI_U = '\u2039';
        private static final char RO = '\u008d';
        private static final char SIGMA = '\u008f';
        private static final char SIGMA_U = '\u017d';
        private static final char TAU = '\u0090';
        private static final char OMEGA = '\u201d';
        private static final char OMEGA_U = '\u201c';
        private static final char XI = '\u0160';
        private static final char PSI = '\u2019';
        private static final char ZETA = '\u2021';
        private static final char INTEGRAL = '\u00b7';
        private static final char COMPLEX_NUMBER = '\u00c6';
        private static final char EXPONENT = '\u2014';
        private static final char THETA = '\u02c6';
        private static final char DERIVE = '\u00b6';
        private static final char CALC_MINUS = '\u00aa';

        private AlfaBetaKeyListener() {
        }

        private void insertChar(KeyEvent keyEvent, char c, char c2) {
            JTextPane jTextPane = (JTextPane)keyEvent.getSource();
            try {
                jTextPane.getDocument().insertString(jTextPane.getCaretPosition(), String.valueOf(keyEvent.isShiftDown() ? c2 : c), jTextPane.getInputAttributes());
            }
            catch (BadLocationException badLocationException) {
                Utils.processException(badLocationException);
            }
            keyEvent.consume();
        }

        public final void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isAltDown()) {
                int n = keyEvent.getKeyCode();
                if (Character.isLetter(keyEvent.getKeyChar()) || n == 222 || n == 152 || n == 45) {
                    char c = '\u0000';
                    char c2 = '\u0000';
                    switch (n) {
                        case 65: {
                            c2 = '\u20ac';
                            c = '\u20ac';
                            break;
                        }
                        case 66: {
                            c2 = '\u0081';
                            c = '\u0081';
                            break;
                        }
                        case 68: {
                            c = '\u2026';
                            c2 = '\u201e';
                            break;
                        }
                        case 69: {
                            c = '\u2020';
                            c2 = '\u2014';
                            break;
                        }
                        case 70: {
                            c2 = '\u2018';
                            c = '\u2018';
                            break;
                        }
                        case 71: {
                            c = '\u0192';
                            c2 = '\u201a';
                            break;
                        }
                        case 73: {
                            c = '\u00c6';
                            c2 = '\u00b7';
                            break;
                        }
                        case 76: {
                            c2 = '\u2030';
                            c = '\u2030';
                            break;
                        }
                        case 77: {
                            c2 = '\u00b1';
                            c = '\u00b1';
                            break;
                        }
                        case 80: {
                            c = '\u0152';
                            c2 = '\u2039';
                            break;
                        }
                        case 82: {
                            c2 = '\u008d';
                            c = '\u008d';
                            break;
                        }
                        case 83: {
                            c = '\u008f';
                            c2 = '\u017d';
                            break;
                        }
                        case 84: {
                            c = '\u0090';
                            c2 = '\u02c6';
                            break;
                        }
                        case 79: 
                        case 87: {
                            c = '\u201d';
                            c2 = '\u201c';
                            break;
                        }
                        case 88: {
                            c2 = '\u0160';
                            c = '\u0160';
                            break;
                        }
                        case 89: {
                            c2 = '\u2019';
                            c = '\u2019';
                            break;
                        }
                        case 90: {
                            c2 = '\u2021';
                            c = '\u2021';
                            break;
                        }
                        case 152: 
                        case 222: {
                            c2 = '\u00b6';
                            c = '\u00b6';
                            break;
                        }
                        case 45: {
                            c2 = '\u00aa';
                            c = '\u00aa';
                        }
                    }
                    if (c != '\u0000') {
                        this.insertChar(keyEvent, c, c2);
                    }
                }
            } else if (!(keyEvent.isAltDown() || keyEvent.isShiftDown() || keyEvent.isControlDown() || keyEvent.getKeyCode() != 155)) {
                RiderArea.this.setOvertypeMode(!RiderArea.isOvertypeMode());
            }
        }

        public final void keyReleased(KeyEvent keyEvent) {
        }

        public final void keyTyped(KeyEvent keyEvent) {
        }
    }

    private static final class ClipboardObserver
    implements ClipboardOwner {
        private ClipboardObserver() {
        }

        public final void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    private final class MouseMoveAdapter
    extends MouseMotionAdapter {
        private MouseMoveAdapter() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            RiderArea.this.areaMouseMoved(mouseEvent);
        }
    }

    private static class OvertypeCaret
    extends DefaultCaret {
        private OvertypeCaret() {
        }

        public void paint(Graphics graphics) {
            if (this.isVisible()) {
                try {
                    JTextComponent jTextComponent = this.getComponent();
                    TextUI textUI = jTextComponent.getUI();
                    Rectangle rectangle = textUI.modelToView(jTextComponent, this.getDot());
                    Color color = jTextComponent.getCaretColor();
                    graphics.setColor(color);
                    int n = graphics.getFontMetrics().charWidth('w');
                    int n2 = rectangle.y + rectangle.height - 2;
                    graphics.drawLine(rectangle.x, n2, rectangle.x + n - 2, n2);
                }
                catch (BadLocationException badLocationException) {
                    Utils.processException(badLocationException);
                }
            }
        }

        protected synchronized void damage(Rectangle rectangle) {
            if (rectangle != null) {
                JTextComponent jTextComponent = this.getComponent();
                this.x = rectangle.x;
                this.y = rectangle.y;
                this.width = jTextComponent.getFontMetrics(jTextComponent.getFont()).charWidth('w');
                this.height = rectangle.height;
                this.repaint();
            }
        }
    }

    private final class MouseClickAdapter
    extends MouseAdapter {
        private MouseClickAdapter() {
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            RiderArea.this.lastSelStart = RiderArea.this.getSelectionStart();
            RiderArea.this.lastSelEnd = RiderArea.this.getSelectionEnd();
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
            RiderArea riderArea = (RiderArea)mouseEvent.getSource();
            if (RiderArea.isInLeftBorder(mouseEvent)) {
                int n = riderArea.getCaretPosition();
                Element element = riderArea.getBookmarkElement(mouseEvent, riderArea.viewToModel(mouseEvent.getPoint()));
                if (element != null) {
                    riderArea.getDoc().toggleBookmark(element.getStartOffset());
                    riderArea.setCaretPosition(n);
                }
                mouseEvent.consume();
            } else if (mouseEvent.getButton() != 1) {
                ContextMenu.getInstance().show(riderArea, mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
            } else if (mouseEvent.getClickCount() > 1) {
                RiderArea.this.lastSelStart = RiderArea.this.getSelectionStart();
                RiderArea.this.lastSelEnd = RiderArea.this.getSelectionEnd();
            }
        }
    }
}

