/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.Font;
import java.awt.Image;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.SeparatorLine;

public final class RiderDocument
extends DefaultStyledDocument {
    private static final int CHARACTERS_PER_TAB = 2;
    private static final char[] EOL_ARRAY = new char[]{'\n'};
    private Collection batch = null;
    private static final Element[] ELEMENT = new Element[0];

    public RiderDocument() {
        RiderStyles.createDefaultStyles((StyleContext)this.getAttributeContext());
        this.batch = new LinkedList();
        this.putProperty("tabSize", new Integer(2));
    }

    public void appendBatchString(char[] cArray, AttributeSet attributeSet) {
        this.batch.add(new DefaultStyledDocument.ElementSpec(attributeSet.copyAttributes(), 3, cArray, 0, cArray.length));
    }

    public void appendBatchString(String string, AttributeSet attributeSet) {
        this.batch.add(new DefaultStyledDocument.ElementSpec(attributeSet.copyAttributes(), 3, string.toCharArray(), 0, string.length()));
    }

    public void appendBatchLineFeed(AttributeSet attributeSet) {
        this.batch.add(new DefaultStyledDocument.ElementSpec(attributeSet, 3, EOL_ARRAY, 0, 1));
        this.batch.add(new DefaultStyledDocument.ElementSpec(null, 2));
        this.batch.add(new DefaultStyledDocument.ElementSpec(this.getParagraphElement(0).getAttributes(), 1));
    }

    public void processBatchUpdates(int n) throws BadLocationException {
        DefaultStyledDocument.ElementSpec[] elementSpecArray = new DefaultStyledDocument.ElementSpec[this.batch.size()];
        this.batch.toArray(elementSpecArray);
        this.batch = new LinkedList();
        super.insert(n, elementSpecArray);
    }

    public final Font getFont(AttributeSet attributeSet) {
        Integer n;
        int n2;
        int n3 = 0;
        if (StyleConstants.isBold(attributeSet)) {
            n3 |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n3 |= 2;
        }
        int n4 = n2 = (n = (Integer)attributeSet.getAttribute(StyleConstants.FontSize)) != null ? n : 13;
        if (StyleConstants.isSuperscript(attributeSet) || StyleConstants.isSubscript(attributeSet)) {
            --n2;
        }
        return ((StyleContext)this.getAttributeContext()).getFont("Ti92Pluspc", n3, n2);
    }

    public final void toggleBookmark(int n) {
        this.toggleBookmark(this.getParagraphElement(n));
    }

    public final void putBookmark(int n) {
        this.setParagraphAttributes(n, 0, RiderStyles.updateBookmark(this.getParagraphElement(n)), false);
    }

    public void removeBookmark(Element element) {
        AttributeSet attributeSet = this.getAttributeContext().removeAttributes(element.getAttributes(), RiderStyles.bookmarkStyle.getAttributeNames());
        this.setParagraphAttributes(element.getStartOffset(), 0, attributeSet, true);
    }

    public final void toggleBookmark(Element element) {
        if (RiderStyles.isMath(element) || RiderStyles.isReadonlySection(element)) {
            return;
        }
        int n = element.getEndOffset() - element.getStartOffset();
        if (RiderStyles.isBookmark(element)) {
            this.removeBookmark(element);
        } else {
            this.setParagraphAttributes(element.getStartOffset(), n, RiderStyles.updateBookmark(element), false);
        }
        this.refresh(element.getStartOffset(), n);
    }

    public void activatePrettyPrint(int n) {
        Element element = this.getParagraphElement(n);
        int n2 = element.getEndOffset() - element.getStartOffset();
        this.removeBookmark(element);
        this.setCharacterAttributes(element.getStartOffset(), n2, new SimpleAttributeSet(), true);
        this.setParagraphAttributes(element.getStartOffset(), n2, RiderStyles.mathStyle, true);
    }

    public void setPrettyPrint(Element element) {
        int n = element.getEndOffset() - element.getStartOffset();
        if (RiderStyles.isMath(element)) {
            AttributeSet attributeSet = this.getAttributeContext().removeAttributes(element.getAttributes(), RiderStyles.mathStyle.getAttributeNames());
            this.setParagraphAttributes(element.getStartOffset(), n, attributeSet, true);
        } else {
            this.removeBookmark(element);
            this.setCharacterAttributes(element.getStartOffset(), n, new SimpleAttributeSet(), true);
            this.setParagraphAttributes(element.getStartOffset(), n, RiderStyles.mathStyle, true);
        }
        this.refresh(element.getStartOffset(), n);
    }

    public final void refresh(int n, int n2) {
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n, n2, DocumentEvent.EventType.CHANGE);
        Element element = this.getDefaultRootElement();
        Element[] elementArray = ELEMENT;
        Element[] elementArray2 = ELEMENT;
        defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(element, 0, elementArray, elementArray2));
        defaultDocumentEvent.end();
        this.fireChangedUpdate(defaultDocumentEvent);
    }

    public final void insertPicture(int n, Image image) throws BadLocationException {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setIcon(simpleAttributeSet, new ImageIcon(image));
        this.insertString(n, " ", simpleAttributeSet);
    }

    public final void insertSeparateLine(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        this.setParagraphAttributes(n, 0, RiderStyles.aligmentLeftStyle, true);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setComponent(simpleAttributeSet, new SeparatorLine(jTextComponent, n2));
        this.insertString(n, " ", simpleAttributeSet);
    }
}

