/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.ViewFactory;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.views.RiderViewFactory;
import net.wordrider.ti89.InvalidDataTypeException;
import net.wordrider.ti89.NotSupportedFileException;
import net.wordrider.ti89.TIImageDecoder;
import net.wordrider.utilities.Utils;

public final class RiderEditorKit
extends StyledEditorKit {
    private static final Action[] defaultActions = new Action[]{new DefaultEditorKit.DefaultKeyTypedAction(), new InsertTabAction()};
    public static final char[] TI92PC_UNICODE_FONT = new char[]{'\u20ac', '\u0081', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\u008d', '\u017d', '\u008f', '\u0090', '\u2018', '\u2019', '\u201c', '\u201d', '\u2013', '\u2014', '\u00c6', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\u009d', '\u017e', '\u0178', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '|', '\u00a7', '\u00a7', '\u00a8', '\u00aa', '\u00d7', '\u00a9', '\u00aa', '\u00a8', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b6', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00de', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00e6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cd', '\u00cc', '\u00cd', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', 'x', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00fe', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    public static final HashMap TI2UNICODE = new HashMap(6);
    public static final BitSet WORD_SEPARATORS;

    public final ViewFactory getViewFactory() {
        return new RiderViewFactory();
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    private final void initDefaultStyles() {
        this.getInputAttributes().addAttributes(RiderStyles.normalStyle);
    }

    private static final char getUnicodeFromTIChar(char c) {
        if (c >= '\u0080' && c <= '\u00ff') {
            return TI92PC_UNICODE_FONT[c - 128];
        }
        if (c < ' ') {
            Character c2 = (Character)TI2UNICODE.get(new Character(c));
            return c2 != null ? c2.charValue() : c;
        }
        return c;
    }

    public void setTextRiderText(JTextComponent jTextComponent, String string, String string2) throws BadLocationException {
        RiderDocument riderDocument = (RiderDocument)this.createDefaultDocument();
        this.initDefaultStyles();
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        int n2 = string.length();
        char[] cArray = string.toCharArray();
        block31: for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            switch (c) {
                case ' ': {
                    if (bl) {
                        bl2 = false;
                        continue block31;
                    }
                    stringBuffer.append(' ');
                    continue block31;
                }
                case '\r': {
                    stringBuffer.append('\n');
                    bl2 = true;
                    bl = true;
                    continue block31;
                }
                case '#': {
                    MutableAttributeSet mutableAttributeSet;
                    if (i + 1 != n2) {
                        switch (cArray[++i]) {
                            case '1': {
                                mutableAttributeSet = RiderStyles.miniStyle;
                                break;
                            }
                            case '2': {
                                mutableAttributeSet = RiderStyles.normalStyle;
                                break;
                            }
                            case '3': {
                                mutableAttributeSet = RiderStyles.maxiStyle;
                                break;
                            }
                            case 'U': {
                                mutableAttributeSet = RiderStyles.updateUnderlineAttributes(this.getInputAttributes());
                                break;
                            }
                            case 'V': {
                                mutableAttributeSet = RiderStyles.updateVectorAttributes(this.getInputAttributes());
                                break;
                            }
                            case 'I': {
                                mutableAttributeSet = RiderStyles.updateInvertAttributes(this.getInputAttributes());
                                break;
                            }
                            case 'N': {
                                mutableAttributeSet = RiderStyles.updateUnderlineDottedAttributes(this.getInputAttributes());
                                break;
                            }
                            case 'S': {
                                mutableAttributeSet = RiderStyles.updateStrikedAttributes(this.getInputAttributes());
                                break;
                            }
                            case 'E': {
                                mutableAttributeSet = RiderStyles.updateExposantAttributes(this.getInputAttributes());
                                break;
                            }
                            case 'W': {
                                mutableAttributeSet = RiderStyles.updateWordWrapAttributes(this.getInputAttributes());
                                break;
                            }
                            default: {
                                --i;
                                mutableAttributeSet = null;
                                stringBuffer.append('#');
                            }
                        }
                        if (mutableAttributeSet == null) continue block31;
                        if (stringBuffer.length() != 0) {
                            riderDocument.insertString(n, stringBuffer.toString(), this.getInputAttributes());
                            n += stringBuffer.length();
                            stringBuffer = new StringBuffer();
                        }
                        this.getInputAttributes().addAttributes(mutableAttributeSet);
                        continue block31;
                    }
                    stringBuffer.append('#');
                    continue block31;
                }
                case '&': {
                    MutableAttributeSet mutableAttributeSet;
                    if (bl && !bl2 && i + 1 != n2) {
                        boolean bl3 = true;
                        int n3 = -1;
                        Image image = null;
                        mutableAttributeSet = null;
                        switch (string.charAt(++i)) {
                            case '-': {
                                n3 = 0;
                                break;
                            }
                            case '=': {
                                n3 = 1;
                                break;
                            }
                            case 'L': 
                            case '\\': {
                                mutableAttributeSet = RiderStyles.aligmentLeftStyle;
                                break;
                            }
                            case 'R': {
                                mutableAttributeSet = RiderStyles.aligmentRightStyle;
                                break;
                            }
                            case 'C': {
                                mutableAttributeSet = RiderStyles.aligmentCenteredStyle;
                                break;
                            }
                            case ',': {
                                mutableAttributeSet = RiderStyles.margin10Style;
                                break;
                            }
                            case ';': {
                                mutableAttributeSet = RiderStyles.margin20Style;
                                break;
                            }
                            case '.': {
                                mutableAttributeSet = RiderStyles.margin30Style;
                                break;
                            }
                            case 'E': {
                                linkedList2.add(new Integer(riderDocument.getLength() + stringBuffer.length()));
                                break;
                            }
                            case 'P': {
                                String string3 = RiderEditorKit.getPictureFileName(cArray, i + 1);
                                if (string3 != null) {
                                    i += string3.length();
                                    File file = RiderEditorKit.getPictureFile(string2, string3);
                                    if (file == null) break;
                                    image = RiderEditorKit.loadPicture(file, string2, string3);
                                    break;
                                }
                                Utils.log(2, "Picture filename couldn't be extracted");
                                break;
                            }
                            default: {
                                --i;
                                bl3 = false;
                            }
                        }
                        if (bl3) {
                            if (stringBuffer.length() != 0) {
                                riderDocument.insertString(n, stringBuffer.toString(), this.getInputAttributes());
                                n += stringBuffer.length();
                                stringBuffer = new StringBuffer();
                            }
                            if (mutableAttributeSet != null) {
                                riderDocument.setParagraphAttributes(n, 0, mutableAttributeSet, true);
                            } else if (n3 != -1) {
                                riderDocument.insertSeparateLine(jTextComponent, n, n3);
                                ++n;
                            } else if (image != null) {
                                riderDocument.insertPicture(n, image);
                                ++n;
                            }
                        }
                    } else {
                        stringBuffer.append('&');
                    }
                    bl = false;
                    continue block31;
                }
                case '\f': {
                    if (bl) {
                        linkedList.add(new Integer(riderDocument.getLength() + stringBuffer.length()));
                        bl2 = false;
                        continue block31;
                    }
                }
                default: {
                    stringBuffer.append(RiderEditorKit.getUnicodeFromTIChar(c));
                    bl = false;
                }
            }
        }
        if (stringBuffer.length() > 0) {
            riderDocument.insertString(n, stringBuffer.toString(), this.getInputAttributes());
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            riderDocument.putBookmark((Integer)iterator.next());
        }
        iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            riderDocument.activatePrettyPrint((Integer)iterator.next());
        }
        jTextComponent.setDocument(riderDocument);
    }

    private static final String getPictureFileName(char[] cArray, int n) {
        int n2;
        int n3 = cArray.length;
        for (n2 = n; n2 < n3 && cArray[n2] != '\r'; ++n2) {
        }
        return n2 != n ? new String(cArray, n, n2 - n) : null;
    }

    private static final File getPictureFile(String string, String string2) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        File file = new File(string + (!string2.endsWith(".89i") ? string2 + ".89i" : string2));
        if (!(file.exists() && file.isFile() || (file = new File(string + string2)).exists() && file.isFile())) {
            int n = string2.lastIndexOf(File.separatorChar);
            if (n != -1) {
                string2 = string2.substring(n);
                file = new File(string + string2);
                if (!(file.exists() && file.isFile() || (file = new File(string + (!string2.endsWith(".89i") ? string2 + ".89i" : string2))).exists() && file.isFile())) {
                    Utils.log(2, "Automatic attempt for loading image file failed " + file.getAbsolutePath());
                    return null;
                }
            } else {
                Utils.log(2, "Automatic attempt for loading image file failed " + file.getAbsolutePath());
                return null;
            }
        }
        return file;
    }

    private static final Image loadPicture(File file, String string, String string2) {
        TIImageDecoder tIImageDecoder = new TIImageDecoder();
        try {
            if (!tIImageDecoder.openFromFile(file)) {
                Utils.log(2, "Image was loaded but the file might be corrupted (invalid checksum)");
            }
            tIImageDecoder.setOriginalFileName(string2);
            tIImageDecoder.setOriginalFileDir(string);
            tIImageDecoder.setImagePath(file.getParent());
            return Toolkit.getDefaultToolkit().createImage(tIImageDecoder);
        }
        catch (InvalidDataTypeException invalidDataTypeException) {
            Utils.log(2, invalidDataTypeException.getMessage());
            return null;
        }
        catch (NotSupportedFileException notSupportedFileException) {
            Utils.log(2, notSupportedFileException.getMessage());
            return null;
        }
        catch (IOException iOException) {
            Utils.log(2, "Cannot load image " + iOException.getMessage());
            return null;
        }
        catch (Exception exception) {
            Utils.log(3, "Fatal error exception " + exception.getMessage());
            return null;
        }
    }

    public final Document createDefaultDocument() {
        return new RiderDocument();
    }

    static {
        TI2UNICODE.put(new Character('\u0012'), new Character('\u00d0'));
        TI2UNICODE.put(new Character('\u0016'), new Character('\u00bb'));
        TI2UNICODE.put(new Character('\u001c'), new Character('\u00bc'));
        TI2UNICODE.put(new Character('\u001d'), new Character('\u00bd'));
        TI2UNICODE.put(new Character('\u001e'), new Character('\u00be'));
        TI2UNICODE.put(new Character('\u001f'), new Character('\u00bf'));
        WORD_SEPARATORS = new BitSet(256);
        WORD_SEPARATORS.set(32);
        WORD_SEPARATORS.set(10);
        WORD_SEPARATORS.set(13);
        WORD_SEPARATORS.set(12);
        WORD_SEPARATORS.set(46);
        WORD_SEPARATORS.set(44);
        WORD_SEPARATORS.set(58);
        WORD_SEPARATORS.set(40);
        WORD_SEPARATORS.set(41);
        WORD_SEPARATORS.set(91);
        WORD_SEPARATORS.set(93);
        WORD_SEPARATORS.set(123);
        WORD_SEPARATORS.set(125);
        WORD_SEPARATORS.set(60);
        WORD_SEPARATORS.set(62);
        WORD_SEPARATORS.set(92);
        WORD_SEPARATORS.set(64);
        WORD_SEPARATORS.set(63);
        WORD_SEPARATORS.set(33);
        WORD_SEPARATORS.set(59);
        WORD_SEPARATORS.set(42);
        WORD_SEPARATORS.set(43);
        WORD_SEPARATORS.set(45);
        WORD_SEPARATORS.set(34);
        WORD_SEPARATORS.set(39);
        WORD_SEPARATORS.set(36);
        WORD_SEPARATORS.set(61);
        WORD_SEPARATORS.set(38);
    }

    private static final class InsertTabAction
    extends DefaultEditorKit.InsertTabAction {
        private InsertTabAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                    return;
                }
                jTextComponent.replaceSelection("  ");
            }
        }
    }
}

