/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.Image;
import java.awt.Toolkit;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;
import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.RiderEditorKit;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.SeparatorLine;
import net.wordrider.ti89.TIImageDecoder;

public final class StyledContent {
    private final List clipContent = new Vector(10);

    public StyledContent(RiderArea riderArea) throws BadLocationException {
        Element element;
        Document document = riderArea.getDocument();
        int n = riderArea.getSelectionStart();
        int n2 = riderArea.getSelectionEnd();
        int n3 = Math.max(n, n2);
        SelectedElementsIterator selectedElementsIterator = new SelectedElementsIterator(document.getDefaultRootElement(), Math.min(n, n2), n3, 1);
        while ((element = selectedElementsIterator.next()) != null) {
            int n4 = element.getStartOffset();
            int n5 = element.getEndOffset();
            if (element.getName().equals("content")) {
                if (selectedElementsIterator.isFirstLeafElement()) {
                    this.clipContent.add(new StyledCopyContent(riderArea.getText(n, selectedElementsIterator.isLastLeafElement() ? n2 - n : n5 - n), element.getAttributes()));
                    continue;
                }
                this.clipContent.add(new StyledCopyContent(riderArea.getText(n4, selectedElementsIterator.isLastLeafElement() ? n2 - n4 : n5 - n4), element.getAttributes()));
                continue;
            }
            if (RiderStyles.isSupportedComponent(element)) {
                this.clipContent.add(new StyledCopyContent(((SeparatorLine)element.getAttributes().getAttribute(StyleConstants.ComponentAttribute)).getLineType()));
                continue;
            }
            ImageIcon imageIcon = RiderStyles.isImage(element);
            if (imageIcon == null) continue;
            this.clipContent.add(new StyledCopyContent(imageIcon));
        }
    }

    private static int findWordSeparator(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (!RiderEditorKit.WORD_SEPARATORS.get(cArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static final int findNextWord(RiderArea riderArea) throws BadLocationException {
        Element element;
        int n;
        Document document = riderArea.getDocument();
        int n2 = n = riderArea.getCaretPosition();
        int n3 = document.getLength() - 1;
        if (n == n3) {
            return n;
        }
        SelectedElementsIterator selectedElementsIterator = new SelectedElementsIterator(document.getDefaultRootElement(), n, document.getLength() - 1, 1);
        while ((element = selectedElementsIterator.next()) != null) {
            int n4 = element.getStartOffset();
            int n5 = element.getEndOffset();
            if (element.getName().equals("content")) {
                int n6;
                String string = selectedElementsIterator.isFirstLeafElement() ? riderArea.getText(n2, selectedElementsIterator.isLastLeafElement() ? n3 - n2 : n5 - n2) : riderArea.getText(n4, selectedElementsIterator.isLastLeafElement() ? n3 - n4 : n5 - n4);
                if (string.equals("")) continue;
                if (selectedElementsIterator.isFirstLeafElement() && string.length() > 2 && string.charAt(0) == ' ') {
                    string = string.substring(1);
                    ++n;
                }
                if ((n6 = StyledContent.findWordSeparator(string)) != -1) {
                    return n += n6;
                }
                n += string.length();
                continue;
            }
            if (!RiderStyles.isSupportedComponent(element)) continue;
            ++n;
            break;
        }
        return n + 1;
    }

    public final void insert(JTextPane jTextPane, int n) throws BadLocationException {
        RiderDocument riderDocument = (RiderDocument)jTextPane.getDocument();
        Iterator iterator = this.clipContent.iterator();
        block4: while (iterator.hasNext()) {
            StyledCopyContent styledCopyContent = (StyledCopyContent)iterator.next();
            switch (styledCopyContent.getContentType()) {
                case 0: {
                    String string = (String)styledCopyContent.getContent();
                    if (string.equals("")) continue block4;
                    if (RiderStyles.isReadonlySection(riderDocument.getParagraphElement(n))) {
                        riderDocument.insertString(n, "\n", null);
                        if (Utilities.getRowStart(jTextPane, n) != n) {
                            ++n;
                        }
                    }
                    riderDocument.insertString(n, string, styledCopyContent.getAttr());
                    n += string.length();
                    continue block4;
                }
                case 1: 
                case 2: {
                    if (RiderStyles.isReadonlySection(riderDocument.getParagraphElement(n))) {
                        riderDocument.insertString(n, "\n", null);
                        if (Utilities.getRowStart(jTextPane, n) != n) {
                            ++n;
                        }
                    } else if (n - 1 > 0 && !riderDocument.getText(n - 1, 1).equals("\n")) {
                        riderDocument.insertString(n++, "\n", null);
                    }
                    if (styledCopyContent.getContentType() == 1) {
                        riderDocument.insertSeparateLine(jTextPane, n++, (Integer)styledCopyContent.getContent());
                        continue block4;
                    }
                    riderDocument.insertPicture(n++, (Image)styledCopyContent.getContent());
                    continue block4;
                }
            }
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.clipContent.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
        }
        return stringBuffer.toString();
    }

    private static final class StyledCopyContent {
        public static final int CONTENT_TEXT = 0;
        public static final int CONTENT_SEPARATOR = 1;
        public static final int CONTENT_IMAGE = 2;
        private final Object content;
        private AttributeSet attr;
        private final int contentType;

        public final Object getContent() {
            return this.content;
        }

        public final AttributeSet getAttr() {
            return this.attr;
        }

        public final int getContentType() {
            return this.contentType;
        }

        public StyledCopyContent(String string, AttributeSet attributeSet) {
            this.content = string;
            this.attr = attributeSet;
            this.contentType = 0;
        }

        public StyledCopyContent(ImageIcon imageIcon) {
            this.content = Toolkit.getDefaultToolkit().createImage(imageIcon.getImage().getSource());
            this.contentType = 2;
        }

        public StyledCopyContent(int n) {
            this.content = new Integer(n);
            this.contentType = 1;
        }

        public final String toString() {
            switch (this.contentType) {
                case 0: {
                    return this.content.toString();
                }
                case 1: {
                    return SeparatorLine.getStringRepresentation((Integer)this.content);
                }
                case 2: {
                    TIImageDecoder tIImageDecoder = (TIImageDecoder)((Image)this.content).getSource();
                    return tIImageDecoder.getStringRepresentation();
                }
            }
            return this.content.toString();
        }
    }

    private static final class SelectedElementsIterator {
        public static final int REVERSE_DIRECTION = 0;
        public static final int FORWARD_DIRECTION = 1;
        private final Element root;
        private Element activeElement;
        private int activeParaIndex;
        private int activeLeafIndex;
        private int startParaIndex;
        private int startLeafIndex;
        private final int endParaIndex;
        private final int endLeafIndex;
        private int activeParaElementsCount;
        private boolean isFirst;

        public SelectedElementsIterator(Element element, int n, int n2, int n3) {
            this.root = element;
            if (n3 == 1) {
                this.startParaIndex = this.activeParaIndex = element.getElementIndex(n);
                this.activeElement = element.getElement(this.activeParaIndex);
                this.startLeafIndex = this.activeLeafIndex = this.activeElement.getElementIndex(n);
                this.activeParaElementsCount = this.activeElement.getElementCount();
                this.endParaIndex = element.getElementIndex(n2);
                this.endLeafIndex = element.getElement(this.endParaIndex).getElementIndex(n2);
            } else {
                this.activeParaIndex = element.getElementIndex(n2);
                this.activeElement = element.getElement(this.activeParaIndex);
                this.activeLeafIndex = this.activeElement.getElementIndex(n2);
                this.activeParaElementsCount = this.activeElement.getElementCount();
                this.endParaIndex = element.getElementIndex(n);
                this.endLeafIndex = element.getElement(this.endParaIndex).getElementIndex(n);
            }
            this.isFirst = true;
        }

        public final Element next() {
            if (this.activeParaIndex < this.endParaIndex) {
                if (this.activeLeafIndex < this.activeParaElementsCount) {
                    return this.activeElement.getElement(this.activeLeafIndex++);
                }
                this.activeElement = this.root.getElement(++this.activeParaIndex);
                this.activeParaElementsCount = this.activeElement.getElementCount();
                this.activeLeafIndex = 1;
                return this.activeElement.getElement(0);
            }
            return this.activeLeafIndex <= this.endLeafIndex && this.activeParaIndex == this.endParaIndex ? this.activeElement.getElement(this.activeLeafIndex++) : null;
        }

        public final boolean isLastLeafElement() {
            return this.activeParaIndex == this.endParaIndex && this.activeLeafIndex - 1 == this.endLeafIndex;
        }

        public final boolean isFirstLeafElement() {
            return this.activeParaIndex == this.startParaIndex && this.activeLeafIndex - 1 == this.startLeafIndex;
        }

        public final Element previous() {
            if (this.activeParaIndex > this.endParaIndex) {
                if (this.activeLeafIndex >= 0) {
                    return this.activeElement.getElement(this.activeLeafIndex--);
                }
                this.activeElement = this.root.getElement(--this.activeParaIndex);
                this.activeParaElementsCount = this.activeElement.getElementCount();
                this.activeLeafIndex = this.activeParaElementsCount - 2;
                return this.activeElement.getElement(this.activeParaElementsCount - 1);
            }
            return this.activeLeafIndex >= this.endLeafIndex && this.activeParaIndex == this.endParaIndex ? this.activeElement.getElement(this.activeLeafIndex--) : null;
        }

        public final Element nextElement() {
            if (this.activeParaIndex < this.endParaIndex) {
                if (this.isFirst) {
                    this.isFirst = false;
                    return this.activeElement;
                }
                if (this.activeLeafIndex < this.activeParaElementsCount) {
                    return this.activeElement.getElement(this.activeLeafIndex++);
                }
                this.activeElement = this.root.getElement(++this.activeParaIndex);
                this.activeParaElementsCount = this.activeElement.getElementCount();
                this.activeLeafIndex = 0;
                return this.activeElement;
            }
            return this.activeLeafIndex <= this.endLeafIndex && this.activeParaIndex == this.endParaIndex ? this.activeElement.getElement(this.activeLeafIndex++) : null;
        }
    }
}

