/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import net.wordrider.area.RiderArea;
import net.wordrider.area.actions.TextAreaAction;
import net.wordrider.area.actions.UndoAction;
import net.wordrider.utilities.Utils;

public final class RedoAction
extends TextAreaAction {
    private static final RedoAction instance = new RedoAction();
    private static final String CODE = "RedoAction";

    public static final RedoAction getInstance() {
        return instance;
    }

    public RedoAction() {
        super(CODE, KeyStroke.getKeyStroke(90, 3), "redo.gif");
        this.setEnabled(false);
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        RiderArea riderArea = (RiderArea)this.getTextComponent(actionEvent);
        if (riderArea != null) {
            try {
                riderArea.getUndoManager().redo();
            }
            catch (CannotRedoException cannotRedoException) {
                Utils.processException(cannotRedoException);
            }
            this.updateRedoState(riderArea);
            UndoAction.getInstance().updateUndoState(riderArea);
        }
    }

    public final void updateRedoState(JTextComponent jTextComponent) {
        RiderArea riderArea = (RiderArea)jTextComponent;
        if (riderArea != null) {
            UndoManager undoManager = riderArea.getUndoManager();
            if (undoManager != null) {
                this.setEnabled(undoManager.canRedo());
            }
        } else {
            this.setEnabled(false);
        }
    }
}

