/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.views;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.View;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.views.RiderViewFactory;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

final class RiderLabelView
extends LabelView {
    private boolean overline = false;
    private boolean dotted = false;
    private boolean _underline = false;
    private boolean wordWrap = false;
    private boolean math = false;
    private boolean inverse = false;
    private boolean nextElementVector = false;

    public RiderLabelView(Element element) {
        super(element);
    }

    public final Color getForeground() {
        return this.math ? RiderStyles.getMathStyleColor() : super.getForeground();
    }

    public final View breakView(int n, int n2, float f, float f2) {
        if (this.wordWrap) {
            return super.breakView(n, n2, f, f2);
        }
        if (n == 0) {
            int n3 = this.getGlyphPainter().getBoundedPosition(this, n2, f, f2);
            RiderLabelView riderLabelView = (RiderLabelView)this.createFragment(n2, n3);
            return riderLabelView;
        }
        return this;
    }

    public final Font getFont() {
        Font font = super.getFont();
        return !font.getFamily().equals("Ti92Pluspc") ? RiderStyles.getAreaFont() : font;
    }

    protected final void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet attributeSet = this.getAttributes();
        if (attributeSet != null) {
            this.wordWrap = RiderStyles.isWordWrap(attributeSet);
            this.math = RiderStyles.isMath(this.getElement());
            this.dotted = RiderStyles.isUnderLineDotted(attributeSet);
            this.overline = RiderStyles.isVector(attributeSet);
            this.inverse = RiderStyles.isInvert(attributeSet);
            if (this.overline) {
                this.nextElementVector = RiderLabelView.isNextElementVector(this.getElement(), this.getDocument());
            }
            this._underline = RiderStyles.isUnderLine(attributeSet);
        }
    }

    private static final boolean isNextElementVector(Element element, Document document) {
        Element element2 = element.getParentElement();
        int n = element2.getElementCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Element element3 = element2.getElement(i);
            if (bl) {
                if (RiderStyles.isVector(element3.getAttributes())) {
                    if (i + 1 == n) {
                        try {
                            return !document.getText(element3.getStartOffset(), element3.getEndOffset() - element3.getStartOffset()).equals("\n");
                        }
                        catch (BadLocationException badLocationException) {
                            Utils.processException(badLocationException);
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
            if (!element3.equals(element)) continue;
            bl = true;
        }
        return false;
    }

    private void fixDrawBug(Graphics graphics, int n, int n2, int n3) {
        graphics.setPaintMode();
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        if (RiderViewFactory.isInSelection(jTextComponent, this.getElement())) {
            graphics.setColor(jTextComponent.getSelectionColor());
        } else {
            graphics.setColor(jTextComponent.getBackground());
        }
        graphics.drawLine(n, n2 + 1, n, n3 + 1);
    }

    public final void paint(Graphics graphics, Shape shape) {
        if (Swinger.ANTIALIASING) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        super.paint(graphics, shape);
        if (this._underline || this.overline || this.dotted || this.inverse) {
            Graphics2D graphics2D;
            int n = this.getStartOffset();
            int n2 = this.getEndOffset();
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            graphics.setColor(this.getForeground());
            this.checkPainter();
            GlyphView.GlyphPainter glyphPainter = this.getGlyphPainter();
            int n3 = rectangle.x;
            int n4 = this.getStartOffset();
            if (n4 != n) {
                n3 += (int)glyphPainter.getSpan(this, n4, n, this.getTabExpander(), n3);
            }
            int n5 = n3 + (int)glyphPainter.getSpan(this, n, n2, this.getTabExpander(), n3);
            int n6 = (int)glyphPainter.getDescent(this);
            int n7 = rectangle.y + rectangle.height - n6;
            if (this.inverse && n3 == n5) {
                this.fixDrawBug(graphics, n3, n7 + 1, rectangle.y + rectangle.height - (int)glyphPainter.getAscent(this) - 4);
            }
            Stroke stroke = null;
            if (this.dotted) {
                graphics2D = (Graphics2D)graphics;
                stroke = graphics2D.getStroke();
                graphics2D.setStroke(RiderStyles.DOTTED_STROKE);
            }
            if (this.dotted) {
                graphics.drawLine(n3, ++n7, n5, n7);
            } else if (this._underline && n5 == n3) {
                this.fixDrawBug(graphics, n3, n7, n7);
            }
            if (stroke != null) {
                graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(stroke);
            }
            if (this.overline) {
                n7 = rectangle.y + rectangle.height - (int)glyphPainter.getAscent(this) - 1;
                if (n3 != n5) {
                    graphics.drawLine(n3, n7, n5, n7);
                }
                if (n5 != n3 && !this.nextElementVector) {
                    graphics.drawLine(n5 + 1, n7, n5 - 4, n7 - 2);
                    graphics.drawLine(n5 + 1, n7, n5 - 4, n7 + 2);
                }
            }
        }
    }
}

