/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.views;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.ImageIcon;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.ParagraphView;
import javax.swing.text.View;
import net.wordrider.area.RiderStyles;
import net.wordrider.utilities.Swinger;

final class RiderParagraphView
extends ParagraphView {
    int childCount = 0;
    int shift = 0;
    private static JTextComponent editor;
    private static int rowPosition;
    private static int newPosition;
    private View childView;
    private static Image breakPointImage;
    private static Image mathPointImage;

    public RiderParagraphView(Element element) {
        super(element);
        ImageIcon imageIcon;
        if (breakPointImage == null && (imageIcon = Swinger.getIcon("breakpoint.gif")) != null) {
            breakPointImage = imageIcon.getImage();
        }
        if (mathPointImage == null && (imageIcon = Swinger.getIcon("math.gif")) != null) {
            mathPointImage = imageIcon.getImage();
        }
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        if (RiderStyles.isImage(this.getElement().getElement(0)) != null) {
            this.setJustification(1);
        }
    }

    public final void paint(Graphics graphics, Shape shape) {
        this.childCount = this.getViewCount();
        super.paint(graphics, shape);
    }

    public final void paintChild(Graphics graphics, Rectangle rectangle, int n) {
        super.paintChild(graphics, rectangle, n);
        if (n == 0) {
            editor = (JTextComponent)this.getContainer();
            if (RiderStyles.isBookmark(this.getElement())) {
                if (breakPointImage != null) {
                    graphics.drawImage(breakPointImage, 7, rectangle.y + rectangle.height / 2 - 7, null);
                } else {
                    graphics.setColor(Color.RED);
                    graphics.fillOval(6, rectangle.y + rectangle.height / 2 - 5, 10, 10);
                }
            } else if (RiderStyles.isMath(this.getElement())) {
                if (mathPointImage != null) {
                    graphics.drawImage(mathPointImage, 4, rectangle.y + rectangle.height / 2 - 8, null);
                } else {
                    graphics.setColor(Color.BLUE);
                    graphics.fillOval(6, rectangle.y + rectangle.height / 2 - 5, 10, 10);
                }
            } else {
                graphics.setColor(Color.RED);
                graphics.fillOval(10, rectangle.y + rectangle.height / 2 - 2, 3, 3);
            }
        }
        if ((newPosition = this.shift + n + 1) != rowPosition) {
            int n2 = editor.getCaretPosition();
            this.childView = this.getView(n);
            if (this.childView.getStartOffset() <= n2 && n2 <= this.childView.getEndOffset()) {
                int n3 = rowPosition;
                rowPosition = newPosition;
                editor.firePropertyChange("linePosition", n3, rowPosition);
            }
            rowPosition = newPosition;
        }
    }

    static {
        rowPosition = -1;
        breakPointImage = null;
        mathPointImage = null;
    }
}

