/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core;

import net.wordrider.core.MainAppFrame;
import net.wordrider.utilities.Consts;
import net.wordrider.utilities.Utils;

public final class MainApp {
    private MainAppFrame mainAppFrame;
    private static final MainApp ourInstance = new MainApp();
    private static final String JAVA_VERSION = "java.version";

    public static final void makeProgress() {
        Utils.log(1, "Loading ... please wait");
    }

    public static MainApp getInstance() {
        return ourInstance;
    }

    private MainApp() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1) {
            String string = stringArray[0];
            if (string.endsWith("?") || string.endsWith("help")) {
                System.out.println("WordRider 0.55");
                System.out.println("created by VitySoft(c)2004 /http://wordrider.net/");
                System.out.println("usage: wordrider [-help|-debug] [file]");
                System.out.println("commands: -help  - to view this message");
                System.out.println("          -debug - enable debug log level");
                System.out.println("min. Java version required : 1.4");
                return;
            }
            if (string.endsWith("debug")) {
                Consts.LOG_SEVERITY = 0;
                string = stringArray.length > 1 ? stringArray[1] : null;
            }
            MainApp.getInstance().start(string);
        } else {
            MainApp.getInstance().start(null);
        }
    }

    private void start(String string) {
        String string2 = System.getProperty(JAVA_VERSION);
        if (string2 == null) {
            System.err.println("Java version was not specified. Fatal error. Cannot continue.");
            return;
        }
        float f = Float.parseFloat(string2.substring(0, 3));
        if (!((double)f > 1.39)) {
            System.err.println("Whooops. Application requires a 1.4 version or later of the Java platform.");
            System.err.println("You are running a " + string2 + "version of the Java platform.");
            System.err.println("Please upgrade to a newer version. Read a readme text file(if you find any ;-) for available URLs.");
            System.exit(-1);
        }
        this.getMainAppFrame().init(string);
    }

    public final MainAppFrame getMainAppFrame() {
        if (this.mainAppFrame == null) {
            this.mainAppFrame = new MainAppFrame();
            return this.mainAppFrame;
        }
        return this.mainAppFrame;
    }
}

