/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;

public class SplashWindow
extends Window {
    private Image splashImage;
    private boolean paintCalled = false;

    public SplashWindow(Frame frame, Image image) {
        super(frame);
        this.splashImage = image;
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        this.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
    }

    public void update(Graphics graphics) {
        graphics.setColor(this.getForeground());
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        graphics.drawImage(this.splashImage, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame splash(Image image) {
        Frame frame = new Frame();
        SplashWindow splashWindow = new SplashWindow(frame, image);
        splashWindow.toFront();
        splashWindow.show();
        if (!EventQueue.isDispatchThread()) {
            SplashWindow splashWindow2 = splashWindow;
            synchronized (splashWindow2) {
                while (!splashWindow.paintCalled) {
                    try {
                        splashWindow.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return frame;
    }
}

