/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.KeyStroke;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.core.actions.SaveFileAction;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.dialogs.CloseDialog;

public final class CloseAllAction
extends CoreAction {
    private static final CloseAllAction instance = new CloseAllAction();
    private static final String CODE = "CloseAllAction";

    private CloseAllAction() {
        super(CODE, KeyStroke.getKeyStroke(67, 3), null);
    }

    public static final CloseAllAction getInstance() {
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean closeAll(ActionEvent actionEvent) {
        AreaManager areaManager = CloseAllAction.getAreaManager();
        Collection collection = areaManager.getModifiedInstances();
        if (collection.size() > 0) {
            FileInstance fileInstance;
            CloseDialog closeDialog = new CloseDialog((Frame)CloseAllAction.getMainFrame(), collection);
            Collection collection2 = closeDialog.getReturnList();
            if (collection2 == null) return false;
            Iterator iterator = areaManager.getOpenedInstances().iterator();
            while (iterator.hasNext()) {
                fileInstance = (FileInstance)iterator.next();
                if (collection2.contains(fileInstance)) continue;
                areaManager.closeInstanceHard(fileInstance);
            }
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                fileInstance = (FileInstance)iterator.next();
                areaManager.setActivateFileInstance(fileInstance);
                if (!SaveFileAction.getInstance().save(actionEvent, false)) {
                    return false;
                }
                areaManager.closeActiveInstance();
            }
            return true;
        } else {
            Iterator iterator = areaManager.getOpenedInstances().iterator();
            while (iterator.hasNext()) {
                areaManager.closeInstanceHard((FileInstance)iterator.next());
            }
        }
        return true;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        this.closeAll(actionEvent);
    }
}

