/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.core.actions.IFileType;
import net.wordrider.core.actions.TextRiderProcess;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.dialogs.SaveSettingsDialog;
import net.wordrider.ti89.TITextFileInfo;
import net.wordrider.ti89.TITextFileWriter;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public class SaveAsFileAction
extends CoreAction {
    private static final SaveAsFileAction instance = new SaveAsFileAction();
    private static final String CODE = "SaveAsFileAction";
    private static final String LASTFOLDER_KEY = "lastOpenFolder";

    public static SaveAsFileAction getInstance() {
        return instance;
    }

    private SaveAsFileAction() {
        super(CODE, KeyStroke.getKeyStroke(83, 3), "save_as.gif");
    }

    boolean runSaveProcess(JFrame jFrame, File file, IFileInstance iFileInstance, boolean bl) {
        try {
            TextRiderProcess textRiderProcess = new TextRiderProcess();
            String string = textRiderProcess.getTxtRiderTextForDocument((StyledDocument)iFileInstance.getTextComponent().getDocument(), iFileInstance.getFileInfo(), true);
            Utils.log(0, string);
            TITextFileWriter tITextFileWriter = new TITextFileWriter();
            tITextFileWriter.setFileInfo(iFileInstance.getFileInfo());
            tITextFileWriter.setTextContent(string);
            tITextFileWriter.saveToFile(file);
            iFileInstance.setFile(file);
        }
        catch (BadLocationException badLocationException) {
            Swinger.showErrorDialog(jFrame, AppPrefs.getLabel("message.error.Fwriting", badLocationException.getMessage()));
            Utils.processException(badLocationException);
            return false;
        }
        catch (IOException iOException) {
            Utils.log(3, iOException.getMessage());
            Swinger.showErrorDialog(jFrame, AppPrefs.getLabel("message.error.saving", iOException.getMessage()));
            return false;
        }
        if (jFrame != null && bl) {
            Swinger.showInformationDialog(jFrame, AppPrefs.getLabel("message.information.savedSuccess", file.getAbsolutePath()));
        }
        return true;
    }

    boolean saveAsProcess(ActionEvent actionEvent, boolean bl) {
        int n;
        JFrame jFrame = SaveAsFileAction.getMainFrame();
        IFileInstance iFileInstance = SaveAsFileAction.getAreaManager().getActiveFileInstance();
        if (iFileInstance == null) {
            return false;
        }
        SaveSettingsDialog saveSettingsDialog = new SaveSettingsDialog((Frame)jFrame, iFileInstance.getFileInfo());
        TITextFileInfo tITextFileInfo = saveSettingsDialog.getResult();
        if (tITextFileInfo == null) {
            return false;
        }
        iFileInstance.setFileInfo(tITextFileInfo);
        File file = new File(AppPrefs.getProperty(LASTFOLDER_KEY, ""));
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle(AppPrefs.getLabel("SaveAsFileAction.dialog.title"));
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        if (fileChooserUI instanceof BasicFileChooserUI) {
            ((BasicFileChooserUI)fileChooserUI).setFileName(tITextFileInfo.getVarName());
        }
        jFileChooser.setFileFilter(iFileInstance.getFileFilter());
        if (jFileChooser.showSaveDialog(jFrame) != 0) {
            return false;
        }
        FileFilter fileFilter = jFileChooser.getFileFilter();
        File file2 = jFileChooser.getSelectedFile();
        if (file2 == null) {
            return false;
        }
        if (fileFilter instanceof IFileType && Utils.getExtension(file2) == null) {
            String string = ((IFileType)((Object)fileFilter)).getExtension();
            file2 = new File(file2.getPath().concat(".").concat(string));
        }
        if (file2.exists() && (n = Swinger.getChoice(jFrame, AppPrefs.getLabel("message.confirm.overwrite"))) == 1) {
            return false;
        }
        AppPrefs.storeProperty(LASTFOLDER_KEY, file2.getAbsolutePath());
        return this.runSaveProcess(jFrame, file2, iFileInstance, bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.saveAsProcess(actionEvent, true);
    }
}

