/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import net.wordrider.area.RiderArea;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.MainApp;
import net.wordrider.core.actions.CloseActiveAction;
import net.wordrider.core.actions.OpenFileAction;
import net.wordrider.core.actions.SaveFileAction;
import net.wordrider.core.managers.ManagerDirector;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.core.managers.interfaces.IInformedTab;
import net.wordrider.ti89.TITextFileInfo;
import net.wordrider.utilities.Swinger;

public final class FileInstance
implements IFileInstance,
IInformedTab,
Comparable {
    private File file = null;
    private static int untitledCount;
    private String name;
    private final RiderArea area = new RiderArea();
    private final JScrollPane scrollPane = new JScrollPane();
    private TITextFileInfo fileInfo;
    private ManagerDirector director;

    public FileInstance() {
        this.setFileInfo(new TITextFileInfo());
        this.init();
    }

    public FileInstance(File file, TITextFileInfo tITextFileInfo) {
        this.setFileInfo(tITextFileInfo);
        this.file = file;
        this.init();
    }

    private void init() {
        this.scrollPane.getViewport().add(this.area);
        this.scrollPane.setFocusable(false);
        this.scrollPane.setFocusCycleRoot(false);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.updateName();
        this.director = MainApp.getInstance().getMainAppFrame().getManagerDirector();
    }

    private void updateName() {
        this.name = this.file == null ? AppPrefs.getLabel("editor.untitled", String.valueOf(++untitledCount)) : this.file.getName();
    }

    public int compareTo(Object object) {
        return this.getName().compareTo(object.toString());
    }

    public final File getFile() {
        return this.file;
    }

    public final String getName() {
        return this.name;
    }

    public final TITextFileInfo getFileInfo() {
        return this.fileInfo;
    }

    public final void setFileInfo(TITextFileInfo tITextFileInfo) {
        this.fileInfo = tITextFileInfo;
    }

    public final void setFile(File file) {
        this.file = file;
        this.updateName();
        this.director.getAreaManager().setTabTitle(this);
        CloseActiveAction.getInstance().updateStatusName(this);
        this.director.getStatusbarManager().displayFilePath(file.getAbsolutePath());
        this.area.setModified(false);
    }

    public final JTextComponent getTextComponent() {
        return this.area;
    }

    public final Component getComponent() {
        return this.scrollPane;
    }

    public FileFilter getFileFilter() {
        return new OpenFileAction.File89tFilter();
    }

    public final Icon getIcon() {
        return null;
    }

    public final String getTip() {
        return this.file != null ? this.file.getAbsolutePath() : null;
    }

    public final void activate() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileInstance.this.area.requestFocus();
            }
        });
    }

    public String getTabName() {
        return this.isModified() ? this.getName() + "*" : this.getName();
    }

    public boolean closeSoft() {
        if (this.area.isModified()) {
            switch (Swinger.getChoiceCancel(MainApp.getInstance().getMainAppFrame(), AppPrefs.getLabel("message.confirm.changed"))) {
                case 0: {
                    SaveFileAction.getInstance().actionPerformed(null);
                    break;
                }
                case 1: {
                    this.closeHard();
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        this.closeHard();
        return true;
    }

    public final String toString() {
        return this.getName();
    }

    public void closeHard() {
        this.area.finalize();
    }

    public boolean isModified() {
        return this.area.isModified();
    }

    public final void deactivate() {
    }
}

