/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import net.wordrider.area.RiderArea;
import net.wordrider.area.actions.AligmentCenterAction;
import net.wordrider.area.actions.AligmentLeftAction;
import net.wordrider.area.actions.AligmentRightAction;
import net.wordrider.area.actions.ChangeDottedStyleAction;
import net.wordrider.area.actions.ChangeExponentStyleAction;
import net.wordrider.area.actions.ChangeFontSizeStyle1Action;
import net.wordrider.area.actions.ChangeFontSizeStyle2Action;
import net.wordrider.area.actions.ChangeFontSizeStyle3Action;
import net.wordrider.area.actions.ChangeInvertStyleAction;
import net.wordrider.area.actions.ChangeMathStyleAction;
import net.wordrider.area.actions.ChangeStrikedStyleAction;
import net.wordrider.area.actions.ChangeUnderlineStyleAction;
import net.wordrider.area.actions.ChangeVectorStyleAction;
import net.wordrider.area.actions.ChangeWordWrapStyleAction;
import net.wordrider.area.actions.CopyAction;
import net.wordrider.area.actions.CutAction;
import net.wordrider.area.actions.InsertPictureAction;
import net.wordrider.area.actions.InsertSeparatorDoubleAction;
import net.wordrider.area.actions.InsertSeparatorSingleAction;
import net.wordrider.area.actions.Margin10Action;
import net.wordrider.area.actions.Margin20Action;
import net.wordrider.area.actions.Margin30Action;
import net.wordrider.area.actions.PasteAction;
import net.wordrider.area.actions.RedoAction;
import net.wordrider.area.actions.SelectAllAction;
import net.wordrider.area.actions.ShowFindReplaceDialogAction;
import net.wordrider.area.actions.UndoAction;
import net.wordrider.area.actions.UpdateBreakpointAction;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.actions.ChangeLanguageAction;
import net.wordrider.core.actions.ChangeLookAndFeelAction;
import net.wordrider.core.actions.CheckForNewVersion;
import net.wordrider.core.actions.CloseActiveAction;
import net.wordrider.core.actions.CloseAllAction;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.core.actions.CreateNewFileAction;
import net.wordrider.core.actions.ExitAction;
import net.wordrider.core.actions.OpenFileAction;
import net.wordrider.core.actions.OpenRecentFileAction;
import net.wordrider.core.actions.RunGCAction;
import net.wordrider.core.actions.SaveAsFileAction;
import net.wordrider.core.actions.SaveFileAction;
import net.wordrider.core.actions.ShowAboutAction;
import net.wordrider.core.actions.Toggle89ViewAreaAction;
import net.wordrider.core.actions.Toggle92ViewAreaAction;
import net.wordrider.core.actions.ToggleAntialisingAreaAction;
import net.wordrider.core.actions.ToggleFullViewAreaAction;
import net.wordrider.core.actions.ToggleStatusBarAction;
import net.wordrider.core.actions.ToggleToolbarAction;
import net.wordrider.core.managers.ManagerDirector;
import net.wordrider.core.managers.interfaces.IAreaChangeListener;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.dialogs.JButtonGroup;
import net.wordrider.gui.LookAndFeels;
import net.wordrider.utilities.Swinger;

public final class MenuManager
implements IAreaChangeListener {
    private RiderArea editor;
    private final JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu insertMenu;
    private JMenu formatMenu;
    private JMenu paragraphMenu;
    private JMenu viewMenu;
    private JMenu wordRiderMenu;
    private JMenu widthViewMenu;
    private JMenu recentMenu;
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    private JMenuItem cutItem;
    private JMenuItem copyItem;
    private JMenuItem pasteItem;
    private JMenuItem selectAllItem;
    private JMenuItem findItem;
    private JMenuItem separatorSingleItem;
    private JMenuItem separatorDoubleItem;
    private JCheckBoxMenuItem viewToolbarItem;
    private JCheckBoxMenuItem viewStatusBarItem;
    private JCheckBoxMenuItem viewAntialiased;
    private JRadioButtonMenuItem fullViewItem;
    private JRadioButtonMenuItem ti89ViewItem;
    private JRadioButtonMenuItem ti92ViewItem;
    private static final String languagesListFile = "languages.properties";
    private static final String languageNonameIcon = "blank.gif";

    public MenuManager(ManagerDirector managerDirector) {
        managerDirector.getMainFrame().setJMenuBar(this.menuBar);
        this.menuBar.add(this.getFileMenu());
        this.menuBar.add(this.getEditMenu());
        this.menuBar.add(this.getFormatMenu());
        this.menuBar.add(this.getParagraphMenu());
        this.menuBar.add(this.getInsertMenu());
        this.menuBar.add(this.getViewMenu());
        this.menuBar.add(this.getWordRiderMenu());
    }

    private static final JMenu initMenu(String string) {
        JMenu jMenu = new JMenu(AppPrefs.getLabel("menu." + string));
        jMenu.setMnemonic(AppPrefs.getMnemonic("menu." + string));
        return jMenu;
    }

    private Component getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = MenuManager.initMenu("view");
            this.viewToolbarItem = new JCheckBoxMenuItem();
            CoreAction coreAction = ToggleToolbarAction.getInstance(this.viewToolbarItem);
            this.viewToolbarItem.setAction(coreAction);
            this.viewMenu.add(this.viewToolbarItem);
            this.viewStatusBarItem = new JCheckBoxMenuItem();
            coreAction = ToggleStatusBarAction.getInstance(this.viewStatusBarItem);
            this.viewStatusBarItem.setAction(coreAction);
            this.viewMenu.add(this.viewStatusBarItem);
            this.viewMenu.addSeparator();
            this.viewAntialiased = new JCheckBoxMenuItem();
            coreAction = ToggleAntialisingAreaAction.getInstance(this.viewAntialiased);
            this.viewMenu.add(this.viewAntialiased);
            this.viewAntialiased.setAction(coreAction);
            this.viewMenu.addSeparator();
            this.widthViewMenu = MenuManager.initMenu("view.emulation");
            this.viewMenu.add(this.widthViewMenu);
            JButtonGroup jButtonGroup = new JButtonGroup();
            this.fullViewItem = new JRadioButtonMenuItem(ToggleFullViewAreaAction.getInstance());
            jButtonGroup.add(this.fullViewItem);
            this.ti89ViewItem = new JRadioButtonMenuItem(Toggle89ViewAreaAction.getInstance());
            jButtonGroup.add(this.ti89ViewItem);
            this.ti92ViewItem = new JRadioButtonMenuItem(Toggle92ViewAreaAction.getInstance());
            jButtonGroup.add(this.ti92ViewItem);
            this.fullViewItem.setSelected(true);
            this.widthViewMenu.add(this.fullViewItem);
            this.widthViewMenu.add(this.ti89ViewItem);
            this.widthViewMenu.add(this.ti92ViewItem);
        }
        return this.viewMenu;
    }

    private Component getWordRiderMenu() {
        if (this.wordRiderMenu == null) {
            this.wordRiderMenu = MenuManager.initMenu("wordrider");
            JMenu jMenu = MenuManager.initMenu("ChangeLanguageAction");
            JMenu jMenu2 = MenuManager.initMenu("ChangeLookAndFeelAction");
            this.wordRiderMenu.add(jMenu);
            this.wordRiderMenu.add(jMenu2);
            this.initLanguageMenu(jMenu);
            jMenu2.setMnemonic(AppPrefs.getMnemonic("ChangeLookAndFeelAction"));
            jMenu.setMnemonic(AppPrefs.getMnemonic("ChangeLanguageAction"));
            this.initLookAndFeelMenu(jMenu2);
            this.wordRiderMenu.addSeparator();
            this.wordRiderMenu.add(new JMenuItem(CheckForNewVersion.getInstance()));
            this.wordRiderMenu.addSeparator();
            this.wordRiderMenu.add(new JMenuItem(RunGCAction.getInstance()));
            this.wordRiderMenu.addSeparator();
            this.wordRiderMenu.add(new JMenuItem(ShowAboutAction.getInstance()));
        }
        return this.wordRiderMenu;
    }

    private void initLookAndFeelMenu(JMenu jMenu) {
        String string;
        String string2;
        Properties properties = AppPrefs.loadProperties("resources/lookandfeels/lookandfeels.properties", true);
        JButtonGroup jButtonGroup = new JButtonGroup();
        int n = -1;
        while ((string2 = properties.getProperty(string = "laf" + ++n)) != null) {
            String string3;
            if (LookAndFeels.isPresent(string2) == null || (string3 = properties.getProperty(string + ".theme", null)) != null && (string3 == null || LookAndFeels.isPresent(string3) == null)) continue;
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new ChangeLookAndFeelAction(string2, properties.getProperty(string + ".name", string2), string3));
            jButtonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setSelected(LookAndFeels.isSelectedLaF(string2, string3));
        }
    }

    private void initLanguageMenu(JMenu jMenu) {
        String string;
        String string2;
        jMenu.setIcon(Swinger.getIcon(languageNonameIcon));
        Properties properties = AppPrefs.loadProperties("resources/languages/languages.properties", true);
        int n = -1;
        String string3 = AppPrefs.getSelectedLanguageCode();
        JButtonGroup jButtonGroup = new JButtonGroup();
        while ((string2 = properties.getProperty(string = "language" + ++n)) != null) {
            Integer n2 = new Integer(properties.getProperty(string + ".mnemonic", "\u0000").charAt(0));
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new ChangeLanguageAction(string2, properties.getProperty(string + ".name"), n2, properties.getProperty(string + ".icon", languageNonameIcon)));
            jButtonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setSelected(string3.equals(string2));
        }
    }

    private Component getParagraphMenu() {
        if (this.paragraphMenu == null) {
            this.paragraphMenu = MenuManager.initMenu("paragraph");
            this.paragraphMenu.add(new JMenuItem(AligmentLeftAction.getInstance()));
            this.paragraphMenu.add(new JMenuItem(AligmentRightAction.getInstance()));
            this.paragraphMenu.add(new JMenuItem(AligmentCenterAction.getInstance()));
            this.paragraphMenu.addSeparator();
            this.paragraphMenu.add(new JMenuItem(Margin10Action.getInstance()));
            this.paragraphMenu.add(new JMenuItem(Margin20Action.getInstance()));
            this.paragraphMenu.add(new JMenuItem(Margin30Action.getInstance()));
            this.paragraphMenu.addSeparator();
            this.paragraphMenu.add(new JMenuItem(ChangeMathStyleAction.getInstance()));
        }
        return this.paragraphMenu;
    }

    private Component getFormatMenu() {
        if (this.formatMenu == null) {
            this.formatMenu = MenuManager.initMenu("format");
            this.formatMenu.add(new JMenuItem(ChangeFontSizeStyle1Action.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeFontSizeStyle2Action.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeFontSizeStyle3Action.getInstance()));
            this.formatMenu.addSeparator();
            this.formatMenu.add(new JMenuItem(ChangeExponentStyleAction.getInstance()));
            this.formatMenu.addSeparator();
            this.formatMenu.add(new JMenuItem(ChangeUnderlineStyleAction.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeDottedStyleAction.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeStrikedStyleAction.getInstance()));
            this.formatMenu.addSeparator();
            this.formatMenu.add(new JMenuItem(ChangeInvertStyleAction.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeVectorStyleAction.getInstance()));
            this.formatMenu.add(new JMenuItem(ChangeWordWrapStyleAction.getInstance()));
        }
        return this.formatMenu;
    }

    private Component getInsertMenu() {
        if (this.insertMenu == null) {
            this.insertMenu = MenuManager.initMenu("insert");
            this.insertMenu.add(new JMenuItem(InsertPictureAction.getInstance()));
            this.insertMenu.addSeparator();
            this.separatorSingleItem = new JMenuItem(InsertSeparatorSingleAction.getInstance());
            this.insertMenu.add(this.separatorSingleItem);
            this.separatorDoubleItem = new JMenuItem(InsertSeparatorDoubleAction.getInstance());
            this.insertMenu.add(this.separatorDoubleItem);
            this.insertMenu.addSeparator();
            this.insertMenu.add(new JMenuItem(UpdateBreakpointAction.getInstance()));
        }
        return this.insertMenu;
    }

    private Component getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = MenuManager.initMenu("file");
            this.fileMenu.add(new JMenuItem(CreateNewFileAction.getInstance()));
            this.fileMenu.add(new JMenuItem(OpenFileAction.getInstance()));
            this.fileMenu.addSeparator();
            this.fileMenu.add(new JMenuItem(SaveFileAction.getInstance()));
            this.fileMenu.add(new JMenuItem(SaveAsFileAction.getInstance()));
            this.fileMenu.addSeparator();
            this.fileMenu.add(new JMenuItem(CloseActiveAction.getInstance()));
            this.fileMenu.add(new JMenuItem(CloseAllAction.getInstance()));
            this.fileMenu.addSeparator();
            this.recentMenu = MenuManager.initMenu("file.recentFiles");
            this.fileMenu.add(this.recentMenu);
            this.recentMenu.setEnabled(false);
            this.fileMenu.addSeparator();
            this.fileMenu.add(new JMenuItem(ExitAction.getInstance()));
        }
        return this.fileMenu;
    }

    private Component getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = MenuManager.initMenu("edit");
            this.undoItem = new JMenuItem(UndoAction.getInstance());
            this.redoItem = new JMenuItem(RedoAction.getInstance());
            this.editMenu.add(this.undoItem);
            this.editMenu.add(this.redoItem);
            this.editMenu.add(new JSeparator());
            this.cutItem = new JMenuItem(CutAction.getInstance());
            this.editMenu.add(this.cutItem);
            this.copyItem = new JMenuItem(CopyAction.getInstance());
            this.editMenu.add(this.copyItem);
            this.pasteItem = new JMenuItem(PasteAction.getInstance());
            this.editMenu.add(this.pasteItem);
            this.selectAllItem = new JMenuItem(SelectAllAction.getInstance());
            this.editMenu.add(this.selectAllItem);
            this.editMenu.addSeparator();
            this.findItem = new JMenuItem(ShowFindReplaceDialogAction.getInstance());
            this.editMenu.add(this.findItem);
        }
        return this.editMenu;
    }

    public void selectedAreaChanged(IFileInstance iFileInstance) {
        boolean bl = iFileInstance != null;
        this.editor = bl ? (RiderArea)iFileInstance.getTextComponent() : null;
        RedoAction.getInstance().updateRedoState(this.editor);
        UndoAction.getInstance().updateUndoState(this.editor);
        ChangeFontSizeStyle1Action.getInstance().setEnabled(bl);
        ChangeFontSizeStyle2Action.getInstance().setEnabled(bl);
        ChangeFontSizeStyle3Action.getInstance().setEnabled(bl);
        AligmentLeftAction.getInstance().setEnabled(bl);
        AligmentCenterAction.getInstance().setEnabled(bl);
        AligmentRightAction.getInstance().setEnabled(bl);
        Margin10Action.getInstance().setEnabled(bl);
        Margin20Action.getInstance().setEnabled(bl);
        Margin30Action.getInstance().setEnabled(bl);
        ChangeInvertStyleAction.getInstance().setEnabled(bl);
        ChangeVectorStyleAction.getInstance().setEnabled(bl);
        ChangeWordWrapStyleAction.getInstance().setEnabled(bl);
        ChangeExponentStyleAction.getInstance().setEnabled(bl);
        ChangeUnderlineStyleAction.getInstance().setEnabled(bl);
        ChangeDottedStyleAction.getInstance().setEnabled(bl);
        ChangeStrikedStyleAction.getInstance().setEnabled(bl);
        UpdateBreakpointAction.getInstance().setEnabled(bl);
        InsertPictureAction.getInstance().setEnabled(bl);
        InsertSeparatorDoubleAction.getInstance().setEnabled(bl);
        InsertSeparatorSingleAction.getInstance().setEnabled(bl);
        ChangeMathStyleAction.getInstance().setEnabled(bl);
        if (this.editor != null) {
            boolean bl2 = this.editor.getSelectionStart() != this.editor.getSelectionEnd();
            CopyAction.getInstance().setEnabled(bl2 && this.editor.isEditable());
            CutAction.getInstance().setEnabled(bl2 && this.editor.isEditable());
            PasteAction.getInstance().setEnabled(this.editor.isEditable());
            switch (this.editor.getViewBorder()) {
                case 0: {
                    this.fullViewItem.setSelected(true);
                    break;
                }
                case 1: {
                    this.ti89ViewItem.setSelected(true);
                    break;
                }
                case 2: {
                    this.ti92ViewItem.setSelected(true);
                }
            }
        } else {
            CopyAction.getInstance().setEnabled(bl);
            CutAction.getInstance().setEnabled(bl);
            CopyAction.getInstance().setEnabled(bl);
            PasteAction.getInstance().setEnabled(bl);
        }
        this.widthViewMenu.setEnabled(bl);
        SelectAllAction.getInstance().setEnabled(bl);
        ShowFindReplaceDialogAction.getInstance().setEnabled(bl);
        SaveFileAction.getInstance().setEnabled(bl && this.editor.isModified());
        SaveAsFileAction.getInstance().setEnabled(bl);
        CloseActiveAction.getInstance().setEnabled(bl);
        CloseActiveAction.getInstance().updateStatusName(iFileInstance);
        CloseAllAction.getInstance().setEnabled(bl);
    }

    public void updateRecentMenu(Collection collection) {
        this.recentMenu.removeAll();
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            this.recentMenu.add(new JMenuItem(new OpenRecentFileAction(file, this.getMnemonicByPosition(n))));
            ++n;
        }
        this.recentMenu.setEnabled(collection.size() > 0);
    }

    private char getMnemonicByPosition(int n) {
        return (char)(n > 9 ? 65 + n - 10 : 48 + n);
    }
}

