/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.io.File;
import java.util.Iterator;
import java.util.Stack;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.managers.MenuManager;
import net.wordrider.core.managers.interfaces.IFileChangeListener;

public class RecentFilesManager
implements IFileChangeListener {
    private final MenuManager menuManager;
    private static final int MAX_RECENT_FILES = AppPrefs.getProperty("recent_files_max_count", 5);
    private final Stack recentFilesList = new Stack();
    private static final String RECENT_PREFERENCES = "recent";

    public RecentFilesManager(MenuManager menuManager) {
        this.menuManager = menuManager;
        this.loadRecentFiles();
    }

    private void loadRecentFiles() {
        String string;
        String string2;
        int n = 0;
        while ((string2 = AppPrefs.getProperty(string = RECENT_PREFERENCES + n, null)) != null) {
            if (string2.length() > 0) {
                this.recentFilesList.add(0, new File(string2));
                AppPrefs.removeProperty(string);
            }
            ++n;
        }
        if (this.recentFilesList.size() > MAX_RECENT_FILES) {
            this.recentFilesList.setSize(MAX_RECENT_FILES);
        }
        if (this.recentFilesList.size() > 0) {
            this.buildRecentFileMenu();
        }
    }

    public void fileWasOpened(File file) {
        if (file == null) {
            return;
        }
        int n = this.recentFilesList.indexOf(file);
        if (n != -1) {
            this.recentFilesList.remove(n);
            this.buildRecentFileMenu();
        }
    }

    public void fileWasClosed(File file) {
        if (file == null) {
            return;
        }
        if (this.recentFilesList.indexOf(file) < 0) {
            this.recentFilesList.add(0, file);
            if (this.recentFilesList.size() > MAX_RECENT_FILES) {
                this.recentFilesList.setSize(MAX_RECENT_FILES);
            }
            this.buildRecentFileMenu();
        }
    }

    private void buildRecentFileMenu() {
        this.menuManager.updateRecentMenu(this.recentFilesList);
    }

    public void removeBadFile(File file) {
        this.fileWasOpened(file);
    }

    public void storeRecentFiles() {
        int n = this.recentFilesList.size() - 1;
        Iterator iterator = this.recentFilesList.iterator();
        while (iterator.hasNext()) {
            AppPrefs.storeProperty(RECENT_PREFERENCES + n, iterator.next().toString());
            --n;
        }
    }
}

