/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.wordrider.core.managers.interfaces.IInformedTab;
import net.wordrider.core.managers.interfaces.IRiderManager;

public abstract class TabManager
implements IRiderManager {
    protected final JTabbedPane tabbedPane = new JTabbedPane(1, 1);
    private static int anIDCounter;
    protected final Map runningTabs = new HashMap(4);
    protected final Map runningInstancesIDs = new HashMap(4);
    protected Integer activeInstanceID;

    public TabManager() {
        this.tabbedPane.setFocusable(false);
        this.tabbedPane.getModel().addChangeListener(new TabListener());
    }

    final Object getActiveInstance() {
        return this.activeInstanceID != null ? this.runningInstancesIDs.get(this.activeInstanceID) : null;
    }

    public final Component getManagerComponent() {
        return this.tabbedPane;
    }

    final void registerNewOne(IInformedTab iInformedTab) {
        Integer n = TabManager.nextID();
        this.runningInstancesIDs.put(n, iInformedTab);
        Component component = iInformedTab.getComponent();
        this.runningTabs.put(component, n);
        this.tabbedPane.addTab(iInformedTab.getTabName(), iInformedTab.getIcon(), component, iInformedTab.getTip());
        this.tabbedPane.setSelectedComponent(component);
    }

    protected void deactivateInstance(Integer n) {
        ((IInformedTab)this.runningInstancesIDs.get(n)).deactivate();
    }

    void activateInstance(Integer n) {
        if (this.activeInstanceID != null && this.runningInstancesIDs.containsKey(this.activeInstanceID)) {
            this.deactivateInstance(this.activeInstanceID);
        }
        this.activeInstanceID = n;
        IInformedTab iInformedTab = (IInformedTab)this.runningInstancesIDs.get(n);
        iInformedTab.activate();
    }

    protected void closeSoft(Integer n) {
        if (n == null || !this.runningInstancesIDs.containsKey(n)) {
            return;
        }
        IInformedTab iInformedTab = (IInformedTab)this.runningInstancesIDs.get(n);
        boolean bl = iInformedTab.closeSoft();
        if (bl) {
            this.removeInstance(n);
        }
    }

    protected void closeHard(Integer n) {
        if (n == null || !this.runningInstancesIDs.containsKey(n)) {
            return;
        }
        this.removeInstance(n);
    }

    private synchronized void removeInstance(Integer n) {
        IInformedTab iInformedTab = (IInformedTab)this.runningInstancesIDs.get(n);
        this.runningTabs.remove(iInformedTab.getComponent());
        if (this.runningTabs.size() == 0) {
            this.deactivateInstance(n);
        }
        this.runningInstancesIDs.remove(n);
        this.tabbedPane.remove(iInformedTab.getComponent());
        this.tabbedPane.validate();
        this.activeInstanceID = null;
        if (this.tabbedPane.getSelectedComponent() != null) {
            this.activateInstance((Integer)this.runningTabs.get(this.tabbedPane.getSelectedComponent()));
        }
    }

    private static synchronized Integer nextID() {
        return new Integer(++anIDCounter);
    }

    public void getPrevTab() {
        int n = this.runningTabs.size();
        if (n > 1) {
            int n2 = this.tabbedPane.getSelectedIndex();
            if (n2 - 1 < 0) {
                n2 = n;
            }
            this.tabbedPane.setSelectedIndex(n2 - 1);
        }
    }

    public void getNextTab() {
        int n = this.runningTabs.size();
        if (n > 1) {
            int n2 = this.tabbedPane.getSelectedIndex();
            if (n2 + 1 == n) {
                n2 = -1;
            }
            this.tabbedPane.setSelectedIndex(n2 + 1);
        }
    }

    private final class TabListener
    implements ChangeListener {
        private TabListener() {
        }

        public final void stateChanged(ChangeEvent changeEvent) {
            if (TabManager.this.tabbedPane.getSelectedComponent() != null) {
                Integer n = (Integer)TabManager.this.runningTabs.get(TabManager.this.tabbedPane.getSelectedComponent());
                if (n != null && !n.equals(TabManager.this.activeInstanceID)) {
                    TabManager.this.activateInstance(n);
                } else if (TabManager.this.activeInstanceID != null) {
                    TabManager.this.deactivateInstance(TabManager.this.activeInstanceID);
                    TabManager.this.activeInstanceID = null;
                }
            } else {
                TabManager.this.activeInstanceID = null;
            }
        }
    }
}

