/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.wordrider.core.AppPrefs;
import net.wordrider.dialogs.AppDialog;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public class ConnectDialog
extends AppDialog {
    private JTextField inputLoginName = new JTextField();
    private JCheckBox checkProxy;
    private JButton btnCheck;
    private JButton btnCancel;
    private JPanel panelProxy;
    private JTextField inputHostName = new JTextField();
    private JCheckBox checkAuthentification;
    private JLabel labelWarning = new JLabel();
    private JTextField inputPortNumber = new JTextField();
    private JCheckBox checkSavePassword = new JCheckBox();
    private JLabel labelPassword;
    private JLabel labelLoginName;
    private JTextField inputPassword = new JPasswordField();
    private JLabel labelPortNumber;
    private JLabel labelHostName;

    public ConnectDialog(Frame frame) throws HeadlessException {
        super(frame, true);
        try {
            this.init();
            this.initData();
            this.useHttpProxy(this.checkProxy.isSelected());
            this.useAuthentification(this.checkAuthentification.isSelected());
            this.setModal(true);
            this.setTitle(AppPrefs.getLabel("dialog.connect.title", "WordRider 0.55"));
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(305, 225);
            Swinger.centerDialog(frame, this);
            this.setVisible(true);
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
    }

    private void initData() {
        this.checkProxy.setSelected(AppPrefs.getProperty("settings.proxy.proxy", false));
        this.checkAuthentification.setSelected(AppPrefs.getProperty("settings.proxy.login", false));
        this.inputHostName.setText(AppPrefs.getProperty("settings.proxy.url", ""));
        this.inputPortNumber.setText(AppPrefs.getProperty("settings.proxy.port", ""));
        this.checkSavePassword.setSelected(AppPrefs.getProperty("settings.proxy.savepassword", false));
        this.inputLoginName.setText(AppPrefs.getProperty("settings.proxy.username", ""));
        this.inputPassword.setText(Utils.generateXorString(AppPrefs.getProperty("settings.proxy.password", "")));
    }

    private void btnCancel_actionPerformed() {
        this.result = 1;
        this.cancel();
    }

    private void btnCheck_actionPerformed() {
        if (this.checkProxy.isSelected()) {
            if (this.inputHostName.getText().length() == 0) {
                Swinger.showErrorDialog((Frame)this.getParent(), AppPrefs.getLabel("dialog.connect.message.enterHostName"));
                Swinger.inputFocus(this.inputHostName);
                return;
            }
            if (this.inputPortNumber.getText().length() == 0) {
                Swinger.showErrorDialog((Frame)this.getParent(), AppPrefs.getLabel("dialog.connect.message.enterPort"));
                Swinger.inputFocus(this.inputPortNumber);
                return;
            }
            if (this.checkAuthentification.isSelected() && this.inputLoginName.getText().length() == 0) {
                Swinger.showErrorDialog((Frame)this.getParent(), AppPrefs.getLabel("dialog.connect.message.enterLogin"));
                Swinger.inputFocus(this.inputLoginName);
                return;
            }
        }
        AppPrefs.storeProperty("settings.proxy.proxy", this.checkProxy.isSelected());
        AppPrefs.storeProperty("settings.proxy.login", this.checkAuthentification.isSelected());
        AppPrefs.storeProperty("settings.proxy.url", this.inputHostName.getText());
        AppPrefs.storeProperty("settings.proxy.port", this.inputPortNumber.getText());
        AppPrefs.storeProperty("settings.proxy.savepassword", this.checkSavePassword.isSelected());
        AppPrefs.storeProperty("settings.proxy.username", this.inputLoginName.getText());
        AppPrefs.storeProperty("settings.proxy.password", Utils.generateXorString(this.inputPassword.getText()));
        this.result = 0;
        this.cancel();
    }

    private void useAuthentification(boolean bl) {
        this.inputLoginName.setEnabled(bl);
        this.inputPassword.setEnabled(bl);
        this.checkSavePassword.setEnabled(bl);
        if (bl) {
            this.inputLoginName.setSelectionStart(0);
            this.inputLoginName.setSelectionEnd(this.inputLoginName.getText().length());
            this.inputLoginName.requestFocus();
        }
    }

    private void useHttpProxy(boolean bl) {
        this.getContentPane().setEnabled(bl);
        this.checkProxy.setSelected(bl);
        this.inputHostName.setEnabled(bl);
        this.inputPortNumber.setEnabled(bl);
        this.checkAuthentification.setEnabled(bl);
        if (this.checkAuthentification.isSelected() && bl) {
            this.useAuthentification(true);
        } else {
            this.useAuthentification(false);
        }
        if (bl) {
            this.inputHostName.setSelectionStart(0);
            this.inputHostName.setSelectionEnd(this.inputHostName.getText().length());
            this.inputHostName.requestFocus();
        }
    }

    private void init() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        CheckAdapter checkAdapter = new CheckAdapter();
        Utils.addKeyActions(this.inputHostName);
        Utils.addKeyActions(this.inputLoginName);
        Utils.addKeyActions(this.inputPassword);
        Utils.addKeyActions(this.inputPortNumber);
        this.checkProxy = Swinger.getRiderCheckBox("dialog.connect.checkProxy");
        this.checkProxy.addActionListener(checkAdapter);
        container.add((Component)this.checkProxy, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 3, new Insets(1, 1, 1, 1), 0, 0));
        this.panelProxy = new JPanel();
        this.panelProxy.setLayout(new GridBagLayout());
        this.panelProxy.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.gray, 1), AppPrefs.getLabel("dialog.connect.labelSettings")));
        container.add((Component)this.panelProxy, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.labelHostName = new JLabel(AppPrefs.getLabel("dialog.connect.labelHostName"));
        this.labelHostName.setLabelFor(this.inputHostName);
        this.panelProxy.add((Component)this.labelHostName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.panelProxy.add((Component)this.inputHostName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 75, 2));
        this.labelPortNumber = new JLabel(AppPrefs.getLabel("dialog.connect.labelPortNumber"));
        this.labelPortNumber.setLabelFor(this.inputPortNumber);
        this.panelProxy.add((Component)this.labelPortNumber, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 4, 1, 1), 0, 0));
        this.panelProxy.add((Component)this.inputPortNumber, new GridBagConstraints(3, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(1, 1, 1, 1), 50, 2));
        this.panelProxy.add((Component)this.inputPassword, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 75, 2));
        this.checkAuthentification = Swinger.getRiderCheckBox("dialog.connect.checkAutentification");
        this.checkAuthentification.addActionListener(checkAdapter);
        this.panelProxy.add((Component)this.checkAuthentification, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.labelLoginName = new JLabel(AppPrefs.getLabel("dialog.connect.labelLoginName"));
        this.labelLoginName.setLabelFor(this.inputLoginName);
        this.panelProxy.add((Component)this.labelLoginName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.panelProxy.add((Component)this.inputLoginName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 75, 2));
        this.labelPassword = new JLabel(AppPrefs.getLabel("dialog.connect.labelPassword"));
        this.labelPassword.setLabelFor(this.inputPassword);
        this.panelProxy.add((Component)this.labelPassword, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 2));
        this.checkSavePassword = Swinger.getRiderCheckBox("dialog.connect.checkSavePassword");
        this.panelProxy.add((Component)this.checkSavePassword, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 2, 1, 1), 0, 4));
        this.labelWarning = new JLabel(AppPrefs.getLabel("dialog.connect.labelWarning"));
        this.panelProxy.add((Component)this.labelWarning, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.btnCheck = Swinger.getRiderButton("dialog.connect.btnCheck");
        container.add((Component)this.btnCheck, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(1, 1, 1, 6), 20, 0));
        this.btnCancel = Swinger.getRiderButton("dialog.connect.btnCancel");
        container.add((Component)this.btnCancel, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(1, 1, 1, 1), 20, 0));
        Dimension dimension = new Dimension(80, 25);
        ActionButtonsAdapter actionButtonsAdapter = new ActionButtonsAdapter();
        this.btnCheck.addActionListener(actionButtonsAdapter);
        this.btnCancel.addActionListener(actionButtonsAdapter);
        this.btnCheck.setRolloverEnabled(false);
        this.btnCancel.setRolloverEnabled(false);
        this.btnCheck.setMinimumSize(dimension);
        this.btnCheck.setPreferredSize(dimension);
        this.btnCheck.setMaximumSize(dimension);
        this.btnCancel.setMinimumSize(dimension);
        this.btnCancel.setPreferredSize(dimension);
        this.btnCancel.setMaximumSize(dimension);
    }

    private class ActionButtonsAdapter
    implements ActionListener {
        private ActionButtonsAdapter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(ConnectDialog.this.btnCheck)) {
                ConnectDialog.this.btnCheck_actionPerformed();
            } else {
                ConnectDialog.this.btnCancel_actionPerformed();
            }
        }
    }

    private class CheckAdapter
    implements ActionListener {
        private CheckAdapter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(ConnectDialog.this.checkProxy)) {
                ConnectDialog.this.useHttpProxy(ConnectDialog.this.checkProxy.isSelected());
            } else if (actionEvent.getSource().equals(ConnectDialog.this.checkAuthentification)) {
                ConnectDialog.this.useAuthentification(ConnectDialog.this.checkAuthentification.isSelected());
            }
        }
    }
}

