/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.wordrider.area.RiderEditorKit;
import net.wordrider.area.RiderStyles;
import net.wordrider.core.AppPrefs;
import net.wordrider.dialogs.FindReplaceEvent;
import net.wordrider.dialogs.FindReplaceListener;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public final class FindReplaceDialog
extends JDialog {
    private int mode;
    private JEditorPane editor;
    private Document doc;
    private String searchText;
    private String phrase;
    private String newPhrase;
    private int lastPos;
    private int offset;
    private int replaceDiff;
    private boolean findInProgress = false;
    private int operation;
    private int replaceChoice;
    private final Vector listeners = new Vector(0);
    private static final Object[] replaceOptions = new Object[]{AppPrefs.getLabel("dialog.findr.btnYes"), AppPrefs.getLabel("dialog.findr.btnNo"), AppPrefs.getLabel("dialog.findr.btnAll"), AppPrefs.getLabel("dialog.findr.btnDone")};
    private static final boolean STATE_LOCKED = false;
    private static final boolean STATE_UNLOCKED = true;
    public static final int RO_YES = 0;
    public static final int RO_NO = 1;
    private static final int RO_ALL = 2;
    private static final int RO_DONE = 3;
    private static final int MODE_DOCUMENT = 1;
    private static final int MODE_PROJECT = 2;
    private static final int OP_NONE = 0;
    private static final int OP_FIND = 1;
    private static final int OP_REPLACE = 2;
    private TitledBorder titledBorder1;
    private final JButton btnFindNext = Swinger.getRiderButton("dialog.findr.findNext");
    private final JCheckBox jcbStartOnTop = Swinger.getRiderCheckBox("dialog.findr.fromStart");
    private final JRadioButton radioButtonDown = new JRadioButton();
    private final JCheckBox jcbWholeWords = Swinger.getRiderCheckBox("dialog.findr.whole");
    private final JPanel panelBtn = new JPanel();
    private final JPanel panelOptions = new JPanel();
    private final JPanel panelFind = new JPanel();
    private JComboBox textFieldReplace;
    private final JPanel panelMain = new JPanel();
    private final JRadioButton radioButtonUp = new JRadioButton();
    private JComboBox textFieldPhrase;
    private final JCheckBox jcbMatchCase = Swinger.getRiderCheckBox("dialog.findr.case");
    private final JLabel jLabel3 = new JLabel();
    private final JLabel jLabel4 = new JLabel();
    private final GridBagLayout gridBagLayout4 = new GridBagLayout();
    private final GridBagLayout gridBagLayout5 = new GridBagLayout();
    private final JButton btnClose = Swinger.getRiderButton("dialog.findr.closeBtn");
    private final GridBagLayout gridBagLayout6 = new GridBagLayout();
    private final JButton btnReplace = Swinger.getRiderButton("dialog.findr.replaceBtn");
    private final JButton btnCancel = Swinger.getRiderButton("dialog.findr.cancelBtn");
    private final JCheckBox jcbProject = new JCheckBox();
    private int replaceCount;
    private static final String PHRASE_PREFERENCES = "findPhrase";
    private static final String REPLACE_PREFERENCES = "replacePhrase";
    private static final int MAX_RECENT_PHRASES_COUNT = 5;

    public FindReplaceDialog(Frame frame, JEditorPane jEditorPane) {
        super(frame, true);
        this.setDefaultCloseOperation(2);
        this.setEditor(jEditorPane);
        this.setMode(1);
        try {
            this.init();
            this.initDialogContents();
            this.centerDialog(frame);
            this.pack();
            this.setVisible(true);
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            Utils.logDebug("Saving find/replace strings to preferences");
            this.saveUsedPhrases();
        }
        super.processWindowEvent(windowEvent);
    }

    public final void addFindReplaceListener(FindReplaceListener findReplaceListener) {
        this.listeners.addElement(findReplaceListener);
    }

    public final void removeFindReplaceListener(FindReplaceListener findReplaceListener) {
        this.listeners.removeElement(findReplaceListener);
    }

    protected final JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FindReplaceDialog.this.btnCancel.isEnabled()) {
                    FindReplaceDialog.this.btnCancel_actionPerformed();
                } else {
                    FindReplaceDialog.this.btnClose_actionPerformed();
                }
            }
        };
        JRootPane jRootPane = new JRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        return jRootPane;
    }

    private void fireGetNextDocument() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((FindReplaceListener)enumeration.nextElement()).getNextDocument(new FindReplaceEvent(this));
        }
    }

    private void fireGetFirstDocument() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((FindReplaceListener)enumeration.nextElement()).getFirstDocument(new FindReplaceEvent(this));
        }
    }

    public final void resumeOperation() {
        this.doc = this.editor.getDocument();
        this.findInProgress = false;
        this.initFind();
        switch (this.operation) {
            case 1: {
                this.find();
                break;
            }
            case 2: {
                this.replace();
            }
        }
    }

    private void terminateOperation() {
        switch (this.operation) {
            case 1: {
                this.message(AppPrefs.getLabel("dialog.findr.notfound"));
                this.toggleState(true);
                this.btnReplace.setEnabled(true);
                break;
            }
            case 2: {
                switch (this.replaceChoice) {
                    case 0: 
                    case 1: {
                        this.message(AppPrefs.getLabel("dialog.findr.notfound"));
                        break;
                    }
                    case 2: {
                        this.message(AppPrefs.getLabel("dialog.findr.replaceCount", new Integer(this.replaceCount)));
                    }
                }
                this.toggleState(true);
                this.editor.firePropertyChange("undoredo", true, false);
                this.setVisible(true);
            }
        }
        this.operation = 0;
    }

    private void btnFindNext_actionPerformed() {
        this.operation = 1;
        this.btnReplace.setEnabled(false);
        if (this.mode == 2 && this.jcbProject.isSelected() && this.listeners.size() > 0 && !this.findInProgress) {
            this.fireGetFirstDocument();
        } else {
            this.initFind();
            this.find();
        }
    }

    private void btnReplace_actionPerformed() {
        this.operation = 2;
        this.replaceChoice = 0;
        this.setVisible(false);
        if (this.mode == 2 && this.jcbProject.isSelected() && this.listeners.size() > 0) {
            this.fireGetFirstDocument();
        } else {
            this.initFind();
            this.replace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FindReplaceDialog.this.textFieldReplace.requestFocus();
            }
        });
    }

    private void btnCancel_actionPerformed() {
        this.toggleState(true);
        this.btnReplace.setEnabled(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FindReplaceDialog.this.textFieldPhrase.requestFocus();
            }
        });
    }

    private void storeProperties(String string, JComboBox jComboBox) {
        Collection collection = ((MyComboDefaultModel)jComboBox.getModel()).getList();
        int n = collection.size() - 1;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AppPrefs.storeProperty(string + n, iterator.next().toString());
            --n;
        }
    }

    private void saveUsedPhrases() {
        this.storeProperties(PHRASE_PREFERENCES, this.textFieldPhrase);
        this.storeProperties(REPLACE_PREFERENCES, this.textFieldReplace);
    }

    private void btnClose_actionPerformed() {
        this.saveUsedPhrases();
        this.dispose();
    }

    private void setEditor(JEditorPane jEditorPane) {
        this.editor = jEditorPane;
        this.doc = jEditorPane.getDocument();
    }

    private void setMode(int n) {
        this.mode = n;
        if (n == 2) {
            this.jcbProject.setVisible(true);
        } else {
            this.jcbProject.setVisible(false);
        }
    }

    private void initFind() {
        if (!this.findInProgress) {
            try {
                this.searchText = this.doc.getText(0, this.doc.getLength());
            }
            catch (Exception exception) {
                Utils.processException(exception);
            }
            this.phrase = this.textFieldPhrase.getEditor().getItem().toString();
            ((MyComboDefaultModel)this.textFieldPhrase.getModel()).addElement(this.phrase);
            this.newPhrase = this.textFieldReplace.getEditor().getItem().toString();
            ((MyComboDefaultModel)this.textFieldReplace.getModel()).addElement(this.newPhrase);
            this.replaceDiff = this.newPhrase.length() - this.phrase.length();
            this.offset = 0;
            if (!this.jcbMatchCase.isSelected()) {
                this.phrase = this.phrase.toLowerCase();
                this.searchText = this.searchText.toLowerCase();
            }
            this.lastPos = this.jcbStartOnTop.isSelected() ? (this.radioButtonUp.isSelected() ? this.doc.getLength() : 0) : this.editor.getSelectionStart();
            this.toggleState(false);
        }
    }

    private void find() {
        if (!this.doFind()) {
            if (this.mode == 2 && this.jcbProject.isSelected() && this.listeners.size() > 0) {
                this.fireGetNextDocument();
            } else {
                this.terminateOperation();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FindReplaceDialog.this.textFieldPhrase.requestFocus();
                }
            });
        } else {
            this.btnFindNext.setEnabled(true);
            this.btnFindNext.requestFocus();
        }
    }

    private boolean doFind() {
        boolean bl = false;
        int n = this.findNext();
        if (this.jcbWholeWords.isSelected()) {
            n = this.findWholeWords(n);
        }
        if (n >= 0) {
            this.lastPos = n;
            if (this.radioButtonDown.isSelected()) {
                n += this.offset;
            }
            this.editor.select(n, n + this.phrase.length());
            bl = true;
        }
        return bl;
    }

    private int findNext() {
        int n = this.radioButtonUp.isSelected() ? (this.lastPos < this.doc.getLength() ? this.searchText.lastIndexOf(this.phrase, this.lastPos - 1) : this.searchText.lastIndexOf(this.phrase, this.lastPos)) : (this.lastPos > 0 ? this.searchText.indexOf(this.phrase, this.lastPos + this.phrase.length()) : this.searchText.indexOf(this.phrase, this.lastPos));
        return n;
    }

    private int findWholeWords(int n) {
        while (!(n <= 0 || RiderEditorKit.WORD_SEPARATORS.get(this.searchText.charAt(n - 1)) && RiderEditorKit.WORD_SEPARATORS.get(this.searchText.charAt(n + this.phrase.length())))) {
            this.lastPos = n;
            n = this.findNext();
        }
        return n;
    }

    private void replace() {
        this.editor.firePropertyChange("undoredo", false, true);
        while (this.doFind() && this.replaceChoice != 3) {
            if (this.replaceChoice != 2) {
                this.replaceChoice = this.getReplaceChoice();
            }
            switch (this.replaceChoice) {
                case 0: {
                    this.replaceOne();
                    break;
                }
                case 2: {
                    this.replaceOne();
                    this.replaceCount = 1;
                    while (this.doFind()) {
                        this.replaceOne();
                        ++this.replaceCount;
                    }
                    break;
                }
            }
        }
        if (this.mode == 2 && this.jcbProject.isSelected() && this.listeners.size() > 0) {
            switch (this.replaceChoice) {
                case 0: 
                case 1: 
                case 2: {
                    this.fireGetNextDocument();
                    break;
                }
                case 3: {
                    this.terminateOperation();
                }
            }
        } else {
            this.terminateOperation();
        }
    }

    private int getReplaceChoice() {
        return JOptionPane.showOptionDialog(this, AppPrefs.getLabel("dialog.findr.confirmR", this.phrase), AppPrefs.getLabel("dialog.findr.title"), 1, 3, null, replaceOptions, null);
    }

    private void replaceOne() {
        this.editor.replaceSelection(this.newPhrase);
        this.offset += this.replaceDiff;
    }

    private void initDialogContents() {
        this.btnCancel.setEnabled(false);
        this.radioButtonUp.setSelected(false);
        this.radioButtonDown.setSelected(true);
        this.jcbWholeWords.setSelected(false);
        this.jcbMatchCase.setSelected(false);
        this.jcbStartOnTop.setSelected(true);
        this.jcbProject.setSelected(false);
        this.textFieldPhrase.getEditor().setItem(this.editor.getSelectedText());
        this.btnFindNext.setEnabled(!FindReplaceDialog.isEmpty(this.textFieldPhrase));
        this.btnReplace.setEnabled(this.btnFindNext.isEnabled());
        this.textFieldReplace.getEditor().setItem("");
    }

    private void centerDialog(Frame frame) {
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = frame.getSize();
        Point point = frame.getLocation();
        this.setLocation((dimension2.width - dimension.width) / 2 + point.x + 150, (dimension2.height - dimension.height) / 2 + point.y - 50);
    }

    private void toggleState(boolean bl) {
        this.btnCancel.setEnabled(!bl);
        this.btnFindNext.setEnabled(bl && !FindReplaceDialog.isEmpty(this.textFieldPhrase));
        this.textFieldPhrase.setEnabled(bl);
        this.textFieldReplace.setEnabled(bl);
        this.jLabel3.setEnabled(bl);
        this.jLabel4.setEnabled(bl);
        this.jcbWholeWords.setEnabled(bl);
        this.jcbMatchCase.setEnabled(bl);
        this.jcbStartOnTop.setEnabled(bl);
        this.radioButtonUp.setEnabled(bl);
        this.radioButtonDown.setEnabled(bl);
        this.jcbProject.setEnabled(bl);
        this.findInProgress = !bl;
    }

    private void message(String string) {
        JOptionPane.showMessageDialog(this, string, AppPrefs.getLabel("dialog.findr.title"), 1);
    }

    private static boolean isEmpty(JComboBox jComboBox) {
        Object object = jComboBox.getEditor().getItem();
        return object == null || object.equals("");
    }

    private void init() {
        Serializable serializable;
        this.textFieldPhrase = new JComboBox(this.loadSearchUsedList(PHRASE_PREFERENCES));
        this.textFieldReplace = new JComboBox(this.loadSearchUsedList(REPLACE_PREFERENCES));
        this.textFieldPhrase.setEditable(true);
        this.textFieldReplace.setEditable(true);
        this.textFieldPhrase.setMaximumRowCount(5);
        this.textFieldReplace.setMaximumRowCount(5);
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), AppPrefs.getLabel("dialog.findr.options"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnFindNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindReplaceDialog.this.btnFindNext_actionPerformed();
            }
        });
        Dimension dimension = new Dimension(90, 25);
        this.btnFindNext.setPreferredSize(dimension);
        this.btnFindNext.setMinimumSize(dimension);
        this.btnFindNext.setMaximumSize(dimension);
        this.radioButtonDown.setText(AppPrefs.getLabel("dialog.findr.searchDown"));
        this.radioButtonDown.setMnemonic(AppPrefs.getMnemonic("dialog.findr.searchDown"));
        this.panelBtn.setLayout(this.gridBagLayout4);
        this.panelOptions.setBorder(this.titledBorder1);
        this.panelOptions.setLayout(new GridBagLayout());
        this.panelOptions.setPreferredSize(new Dimension(305, 88));
        this.panelFind.setLayout(this.gridBagLayout5);
        this.textFieldReplace.setMinimumSize(new Dimension(4, 12));
        this.textFieldReplace.setPreferredSize(new Dimension(30, 12));
        this.panelMain.setLayout(this.gridBagLayout6);
        this.radioButtonUp.setText(AppPrefs.getLabel("dialog.findr.searchup"));
        this.radioButtonUp.setMnemonic(AppPrefs.getMnemonic("dialog.findr.searchup"));
        this.textFieldPhrase.setMinimumSize(new Dimension(4, 12));
        this.textFieldPhrase.setPreferredSize(new Dimension(44, 12));
        Swinger.SelectAllOnFocusListener selectAllOnFocusListener = new Swinger.SelectAllOnFocusListener();
        ActionKeyListener actionKeyListener = new ActionKeyListener();
        this.textFieldPhrase.addKeyListener(actionKeyListener);
        Component component = this.textFieldPhrase.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            serializable = (JTextComponent)component;
            ((Component)serializable).addKeyListener(actionKeyListener);
            ((JTextComponent)serializable).getDocument().addDocumentListener(new InputFieldsMethodListener());
            ((Component)serializable).addFocusListener(selectAllOnFocusListener);
            Utils.addKeyActions((JComponent)serializable);
        }
        if ((component = this.textFieldReplace.getEditor().getEditorComponent()) instanceof JTextComponent) {
            serializable = (JTextComponent)component;
            ((Component)serializable).addKeyListener(actionKeyListener);
            ((Component)serializable).addFocusListener(selectAllOnFocusListener);
            Utils.addKeyActions((JComponent)serializable);
        }
        serializable = RiderStyles.getAreaFont().deriveFont(0, 12.0f);
        this.textFieldPhrase.setFont((Font)serializable);
        this.textFieldReplace.setFont((Font)serializable);
        this.jLabel3.setText(AppPrefs.getLabel("dialog.findr.replacewith"));
        this.jLabel4.setText(AppPrefs.getLabel("dialog.findr.textfind"));
        this.jLabel3.setLabelFor(this.textFieldPhrase);
        this.jLabel3.setDisplayedMnemonic(AppPrefs.getMnemonic("dialog.findr.replacewith"));
        this.jLabel4.setDisplayedMnemonic(AppPrefs.getMnemonic("dialog.findr.textfind"));
        this.jLabel4.setLabelFor(this.textFieldReplace);
        this.btnClose.setPreferredSize(dimension);
        this.btnClose.setMaximumSize(dimension);
        this.btnClose.setMinimumSize(dimension);
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindReplaceDialog.this.btnClose_actionPerformed();
            }
        });
        this.setModal(true);
        this.setTitle(AppPrefs.getLabel("dialog.findr.title"));
        this.btnReplace.setPreferredSize(dimension);
        this.btnReplace.setMaximumSize(dimension);
        this.btnReplace.setMinimumSize(dimension);
        this.btnReplace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindReplaceDialog.this.btnReplace_actionPerformed();
            }
        });
        this.btnCancel.setPreferredSize(dimension);
        this.btnCancel.setMaximumSize(dimension);
        this.btnCancel.setMinimumSize(dimension);
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindReplaceDialog.this.btnCancel_actionPerformed();
            }
        });
        this.getContentPane().add((Component)this.panelMain, "North");
        this.panelBtn.add((Component)this.btnFindNext, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(4, 4, 0, 4), 0, 0));
        this.panelBtn.add((Component)this.btnClose, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 4, 4, 4), 0, 0));
        this.panelBtn.add((Component)this.btnReplace, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.panelBtn.add((Component)this.btnCancel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.panelMain.add((Component)this.panelFind, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.panelMain.add((Component)this.panelBtn, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 12, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.panelFind.add((Component)this.textFieldPhrase, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 0, 0), 0, 12));
        this.panelFind.add((Component)this.jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.panelFind.add((Component)this.textFieldReplace, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 0, 0), 0, 12));
        this.panelFind.add((Component)this.jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.panelMain.add((Component)this.panelOptions, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.panelOptions.add((Component)this.jcbWholeWords, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(-10, 0, 0, 0), 10, 0));
        this.panelOptions.add((Component)this.jcbMatchCase, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(-6, 0, -5, 0), 10, 0));
        this.panelOptions.add((Component)this.jcbStartOnTop, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(-3, 0, -5, 0), 10, 0));
        this.panelOptions.add((Component)this.radioButtonUp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(-10, 0, 0, 0), 0, 0));
        this.panelOptions.add((Component)this.radioButtonDown, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(-3, 0, 0, 0), 0, 0));
        buttonGroup.add(this.radioButtonUp);
        buttonGroup.add(this.radioButtonDown);
    }

    private ComboBoxModel loadSearchUsedList(String string) {
        String string2;
        String string3;
        Stack<String> stack = new Stack<String>();
        int n = 0;
        while ((string3 = AppPrefs.getProperty(string2 = string + n, null)) != null) {
            if (string3.length() > 0) {
                stack.add(0, string3);
                AppPrefs.removeProperty(string2);
            }
            ++n;
        }
        return new MyComboDefaultModel(stack);
    }

    private class MyComboDefaultModel
    extends DefaultComboBoxModel {
        private Stack stack;

        public MyComboDefaultModel(Stack stack) {
            super(stack);
            this.stack = stack;
        }

        public final void addElement(Object object) {
            if (!object.equals("") && this.getIndexOf(object) < 0) {
                super.insertElementAt(object, 0);
                if (this.stack.size() > 5) {
                    super.removeElementAt(4);
                }
            }
        }

        public final Collection getList() {
            return this.stack;
        }
    }

    private final class InputFieldsMethodListener
    implements DocumentListener {
        private InputFieldsMethodListener() {
        }

        public void inputMethodTextChanged() {
            boolean bl = FindReplaceDialog.isEmpty(FindReplaceDialog.this.textFieldPhrase);
            if (FindReplaceDialog.this.btnFindNext.isEnabled() != !bl) {
                FindReplaceDialog.this.btnFindNext.setEnabled(!bl);
            }
            if (FindReplaceDialog.this.btnReplace.isEnabled() != !bl) {
                FindReplaceDialog.this.btnReplace.setEnabled(!bl);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.inputMethodTextChanged();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.inputMethodTextChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.inputMethodTextChanged();
        }
    }

    private final class ActionKeyListener
    implements KeyListener {
        private ActionKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getSource();
            if (keyEvent.getKeyCode() == 10) {
                if (jTextField.equals(FindReplaceDialog.this.textFieldPhrase)) {
                    FindReplaceDialog.this.btnFindNext_actionPerformed();
                } else {
                    FindReplaceDialog.this.btnReplace_actionPerformed();
                }
                keyEvent.consume();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

