/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.wordrider.core.AppPrefs;
import net.wordrider.dialogs.AppDialog;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public class LoadingDialog
extends AppDialog {
    private JProgressBar progressBar = new JProgressBar();

    public LoadingDialog(Frame frame) {
        super(frame, true);
        try {
            this.init();
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
        Swinger.centerDialog(frame, this);
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
    }

    private void init() throws Exception {
        this.setUndecorated(true);
        Container container = this.getContentPane();
        container.setCursor(Cursor.getPredefinedCursor(3));
        JPanel jPanel = new JPanel(new FlowLayout());
        container.add(jPanel);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), AppPrefs.getLabel("dialog.loading.checkNewVersion")));
        this.progressBar.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        jPanel.add(this.progressBar);
        this.progressBar.setStringPainted(true);
        this.progressBar.setIndeterminate(true);
        this.pack();
    }

    public void setStatusText(String string) {
        this.progressBar.setString(string);
    }
}

